/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.monitoring.metrics.AutoValue_MetricPoint;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricsUtils;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@AutoValue
public abstract class MetricPoint<V>
implements Comparable<MetricPoint<V>> {
    @VisibleForTesting
    public static <V> MetricPoint<V> create(Metric<V> metric, ImmutableList<String> labelValues, Instant timestamp, V value) {
        MetricsUtils.checkLabelValuesLength(metric, labelValues);
        return new AutoValue_MetricPoint<V>(metric, labelValues, new Interval((ReadableInstant)timestamp, (ReadableInstant)timestamp), value);
    }

    @VisibleForTesting
    public static <V> MetricPoint<V> create(Metric<V> metric, ImmutableList<String> labelValues, Instant startTime, Instant endTime, V value) {
        MetricsUtils.checkLabelValuesLength(metric, labelValues);
        return new AutoValue_MetricPoint<V>(metric, labelValues, new Interval((ReadableInstant)startTime, (ReadableInstant)endTime), value);
    }

    public abstract Metric<V> metric();

    public abstract ImmutableList<String> labelValues();

    public abstract Interval interval();

    public abstract V value();

    @Override
    public int compareTo(MetricPoint<V> other) {
        int minLength = Math.min(this.labelValues().size(), other.labelValues().size());
        for (int index = 0; index < minLength; ++index) {
            int comparisonResult = ((String)this.labelValues().get(index)).compareTo((String)other.labelValues().get(index));
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        return Integer.compare(this.labelValues().size(), other.labelValues().size());
    }
}

