/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.monitoring.metrics.Counter;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.EventMetric;
import com.google.monitoring.metrics.IncrementableMetric;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricRegistry;
import com.google.monitoring.metrics.SettableMetric;
import com.google.monitoring.metrics.StoredMetric;
import com.google.monitoring.metrics.VirtualMetric;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetricRegistryImpl
implements MetricRegistry {
    private static final Logger logger = Logger.getLogger(MetricRegistryImpl.class.getName());
    private static final MetricRegistryImpl INSTANCE = new MetricRegistryImpl();
    private final ConcurrentHashMap<String, Metric<?>> registeredMetrics = new ConcurrentHashMap();

    @VisibleForTesting
    public MetricRegistryImpl() {
    }

    public static MetricRegistryImpl getDefault() {
        return INSTANCE;
    }

    @Override
    public EventMetric newEventMetric(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels, DistributionFitter distributionFitter) {
        EventMetric metric = new EventMetric(name, description, valueDisplayName, distributionFitter, labels);
        this.registerMetric(name, metric);
        logger.info("Registered new event metric: " + name);
        return metric;
    }

    @Override
    @CanIgnoreReturnValue
    public <V> Metric<V> newGauge(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels, Supplier<ImmutableMap<ImmutableList<String>, V>> metricCallback, Class<V> valueClass) {
        VirtualMetric<V> metric = new VirtualMetric<V>(name, description, valueDisplayName, labels, metricCallback, valueClass);
        this.registerMetric(name, metric);
        logger.info("Registered new callback metric: " + name);
        return metric;
    }

    @Override
    public <V> SettableMetric<V> newSettableMetric(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels, Class<V> valueClass) {
        StoredMetric<V> metric = new StoredMetric<V>(name, description, valueDisplayName, labels, valueClass);
        this.registerMetric(name, metric);
        logger.info("Registered new stored metric: " + name);
        return metric;
    }

    @Override
    public IncrementableMetric newIncrementableMetric(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels) {
        Counter metric = new Counter(name, description, valueDisplayName, labels);
        this.registerMetric(name, metric);
        logger.info("Registered new counter: " + name);
        return metric;
    }

    @Override
    public ImmutableList<Metric<?>> getRegisteredMetrics() {
        return ImmutableList.copyOf(this.registeredMetrics.values());
    }

    @VisibleForTesting
    public void unregisterMetric(String name) {
        this.registeredMetrics.remove(name);
        logger.info("Unregistered metric: " + name);
    }

    @VisibleForTesting
    public void unregisterAllMetrics() {
        this.registeredMetrics.clear();
    }

    @VisibleForTesting
    void registerMetric(String name, Metric<?> metric) {
        Metric<?> previousMetric = this.registeredMetrics.putIfAbsent(name, metric);
        Preconditions.checkState((previousMetric == null ? 1 : 0) != 0, (String)"Duplicate metric of same name: %s", (Object)name);
    }
}

