/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.monitoring.metrics.Metric;
import com.google.monitoring.metrics.MetricExporter;
import com.google.monitoring.metrics.MetricMetrics;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricRegistry;
import com.google.monitoring.metrics.MetricRegistryImpl;
import com.google.monitoring.metrics.MetricWriter;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetricReporter
extends AbstractScheduledService {
    private static final Logger logger = Logger.getLogger(MetricReporter.class.getName());
    private final long writeInterval;
    private final MetricRegistry metricRegistry;
    private final BlockingQueue<Optional<ImmutableList<MetricPoint<?>>>> writeQueue;
    private MetricExporter metricExporter;
    private final MetricWriter metricWriter;
    private final ThreadFactory threadFactory;

    public MetricReporter(MetricWriter metricWriter, long writeInterval, ThreadFactory threadFactory) {
        this(metricWriter, writeInterval, threadFactory, MetricRegistryImpl.getDefault(), new ArrayBlockingQueue(1000));
    }

    @VisibleForTesting
    MetricReporter(MetricWriter metricWriter, long writeInterval, ThreadFactory threadFactory, MetricRegistry metricRegistry, BlockingQueue<Optional<ImmutableList<MetricPoint<?>>>> writeQueue) {
        Preconditions.checkArgument((writeInterval > 0L ? 1 : 0) != 0, (Object)"writeInterval must be greater than zero");
        this.metricWriter = metricWriter;
        this.writeInterval = writeInterval;
        this.threadFactory = threadFactory;
        this.metricRegistry = metricRegistry;
        this.writeQueue = writeQueue;
        this.metricExporter = new MetricExporter(writeQueue, metricWriter, threadFactory);
    }

    protected void runOneIteration() {
        logger.info("Running background metric push");
        if (this.metricExporter.state() == Service.State.FAILED) {
            this.startMetricExporter();
        }
        ImmutableList.Builder points = new ImmutableList.Builder();
        for (Metric metric : this.metricRegistry.getRegisteredMetrics()) {
            points.addAll(metric.getTimestampedValues());
            logger.fine(String.format("Enqueued metric %s", metric));
            MetricMetrics.pushedPoints.increment(metric.getMetricSchema().kind().name(), metric.getValueClass().toString());
        }
        if (!this.writeQueue.offer(Optional.of(points.build()))) {
            logger.severe("writeQueue full, dropped a reporting interval of points");
        }
        MetricMetrics.pushIntervals.increment(new String[0]);
    }

    protected void shutDown() {
        this.runOneIteration();
        this.writeQueue.offer(Optional.empty());
        try {
            this.metricExporter.awaitTerminated(10L, TimeUnit.SECONDS);
            logger.info("Shut down MetricExporter");
        }
        catch (IllegalStateException exception) {
            logger.log(Level.SEVERE, "Failed to shut down MetricExporter because it was FAILED", this.metricExporter.failureCause());
        }
        catch (TimeoutException exception) {
            logger.log(Level.SEVERE, "Failed to shut down MetricExporter within the timeout", exception);
        }
    }

    protected void startUp() {
        this.startMetricExporter();
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)this.writeInterval, (long)this.writeInterval, (TimeUnit)TimeUnit.SECONDS);
    }

    protected ScheduledExecutorService executor() {
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        this.addListener(new Service.Listener(){

            public void terminated(Service.State from) {
                executor.shutdown();
            }

            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return executor;
    }

    private void startMetricExporter() {
        switch (this.metricExporter.state()) {
            case NEW: {
                this.metricExporter.startAsync();
                break;
            }
            case FAILED: {
                logger.log(Level.SEVERE, "MetricExporter died unexpectedly, restarting", this.metricExporter.failureCause());
                this.metricExporter = new MetricExporter(this.writeQueue, this.metricWriter, this.threadFactory);
                this.metricExporter.startAsync();
                break;
            }
            default: {
                throw new IllegalStateException("MetricExporter not FAILED or NEW, should not be calling startMetricExporter");
            }
        }
    }
}

