/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.metrics.AutoValue_MetricSchema;
import com.google.monitoring.metrics.LabelDescriptor;

@AutoValue
public abstract class MetricSchema {
    MetricSchema() {
    }

    @VisibleForTesting
    public static MetricSchema create(String name, String description, String valueDisplayName, Kind kind, ImmutableSet<LabelDescriptor> labels) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name must not be blank");
        Preconditions.checkArgument((!description.isEmpty() ? 1 : 0) != 0, (Object)"Description must not be blank");
        Preconditions.checkArgument((!valueDisplayName.isEmpty() ? 1 : 0) != 0, (Object)"Value Display Name must not be empty");
        Preconditions.checkArgument((boolean)name.startsWith("/"), (Object)"Name must be URL-like and start with a '/'");
        return new AutoValue_MetricSchema(name, description, valueDisplayName, kind, labels);
    }

    public abstract String name();

    public abstract String description();

    public abstract String valueDisplayName();

    public abstract Kind kind();

    public abstract ImmutableSet<LabelDescriptor> labels();

    public static enum Kind {
        CUMULATIVE,
        GAUGE;

    }
}

