/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.monitoring.metrics.Metric;
import java.util.concurrent.ConcurrentHashMap;

final class MetricsUtils {
    private static final Double NEGATIVE_ZERO = -0.0;
    private static final String LABEL_SIZE_ERROR = "The count of labelValues must be equal to the underlying Metric's count of labels.";
    private static final int HASHMAP_INITIAL_CAPACITY = 16;
    private static final float HASHMAP_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    private MetricsUtils() {
    }

    static void checkLabelValuesLength(Metric<?> metric, String[] labelValues) {
        Preconditions.checkArgument((labelValues.length == metric.getMetricSchema().labels().size() ? 1 : 0) != 0, (Object)LABEL_SIZE_ERROR);
    }

    static void checkLabelValuesLength(Metric<?> metric, ImmutableList<String> labelValues) {
        Preconditions.checkArgument((labelValues.size() == metric.getMetricSchema().labels().size() ? 1 : 0) != 0, (Object)LABEL_SIZE_ERROR);
    }

    static void checkDouble(double value) {
        Preconditions.checkArgument((!Double.isInfinite(value) && !Double.isNaN(value) && !NEGATIVE_ZERO.equals(value) ? 1 : 0) != 0, (Object)"value must be finite, not NaN, and not -0.0");
    }

    static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int concurrencyLevel) {
        return new ConcurrentHashMap(16, 0.75f, concurrencyLevel);
    }
}

