/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.common.primitives.Doubles;
import com.google.monitoring.metrics.Distribution;
import com.google.monitoring.metrics.DistributionFitter;
import com.google.monitoring.metrics.MetricsUtils;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableDistribution
implements Distribution {
    private final TreeRangeMap<Double, Long> intervalCounts;
    private final DistributionFitter distributionFitter;
    private double sumOfSquaredDeviation = 0.0;
    private double mean = 0.0;
    private long count = 0L;

    public MutableDistribution(DistributionFitter distributionFitter) {
        this.distributionFitter = (DistributionFitter)Preconditions.checkNotNull((Object)distributionFitter);
        ImmutableSortedSet<Double> boundaries = distributionFitter.boundaries();
        Preconditions.checkArgument((boundaries.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)Ordering.natural().isOrdered(boundaries));
        this.intervalCounts = TreeRangeMap.create();
        double[] boundariesArray = Doubles.toArray(distributionFitter.boundaries());
        this.intervalCounts.put(Range.lessThan((Comparable)Double.valueOf(boundariesArray[0])), (Object)0L);
        this.intervalCounts.put(Range.atLeast((Comparable)Double.valueOf(boundariesArray[boundariesArray.length - 1])), (Object)0L);
        for (int i = 1; i < boundariesArray.length; ++i) {
            this.intervalCounts.put(Range.closedOpen((Comparable)Double.valueOf(boundariesArray[i - 1]), (Comparable)Double.valueOf(boundariesArray[i])), (Object)0L);
        }
    }

    public void add(double value) {
        this.add(value, 1L);
    }

    public void add(double value, long numSamples) {
        Preconditions.checkArgument((numSamples >= 0L ? 1 : 0) != 0, (Object)"numSamples must be non-negative");
        MetricsUtils.checkDouble(value);
        if (numSamples == 0L) {
            return;
        }
        Map.Entry entry = this.intervalCounts.getEntry((Comparable)Double.valueOf(value));
        this.intervalCounts.put((Range)entry.getKey(), (Object)((Long)entry.getValue() + numSamples));
        this.count += numSamples;
        double delta = value - this.mean;
        this.mean += delta * (double)numSamples / (double)this.count;
        this.sumOfSquaredDeviation += delta * (value - this.mean) * (double)numSamples;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double sumOfSquaredDeviation() {
        return this.sumOfSquaredDeviation;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public ImmutableRangeMap<Double, Long> intervalCounts() {
        return ImmutableRangeMap.copyOf(this.intervalCounts);
    }

    @Override
    public DistributionFitter distributionFitter() {
        return this.distributionFitter;
    }
}

