/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.metrics.AbstractMetric;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricSchema;
import com.google.monitoring.metrics.MetricsUtils;
import com.google.monitoring.metrics.SettableMetric;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Instant;

@ThreadSafe
public class StoredMetric<V>
extends AbstractMetric<V>
implements SettableMetric<V> {
    private final ConcurrentHashMap<ImmutableList<String>, V> values = new ConcurrentHashMap();

    StoredMetric(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels, Class<V> valueClass) {
        super(name, description, valueDisplayName, MetricSchema.Kind.GAUGE, labels, valueClass);
    }

    @VisibleForTesting
    final void set(V value, ImmutableList<String> labelValues) {
        this.values.put(labelValues, value);
    }

    @Override
    public final void set(V value, String ... labelValues) {
        MetricsUtils.checkLabelValuesLength(this, labelValues);
        this.set(value, (ImmutableList<String>)ImmutableList.copyOf((Object[])labelValues));
    }

    @Override
    public final ImmutableList<MetricPoint<V>> getTimestampedValues() {
        return this.getTimestampedValues(Instant.now());
    }

    @Override
    public final int getCardinality() {
        return this.values.size();
    }

    @VisibleForTesting
    final ImmutableList<MetricPoint<V>> getTimestampedValues(Instant timestamp) {
        ImmutableList.Builder timestampedValues = new ImmutableList.Builder();
        for (Map.Entry<ImmutableList<String>, V> entry : this.values.entrySet()) {
            timestampedValues.add(MetricPoint.create(this, entry.getKey(), timestamp, timestamp, entry.getValue()));
        }
        return timestampedValues.build();
    }
}

