/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.monitoring.metrics.AbstractMetric;
import com.google.monitoring.metrics.LabelDescriptor;
import com.google.monitoring.metrics.MetricPoint;
import com.google.monitoring.metrics.MetricSchema;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Instant;

@ThreadSafe
public final class VirtualMetric<V>
extends AbstractMetric<V> {
    private final Supplier<ImmutableMap<ImmutableList<String>, V>> valuesSupplier;
    private volatile int cardinality;

    VirtualMetric(String name, String description, String valueDisplayName, ImmutableSet<LabelDescriptor> labels, Supplier<ImmutableMap<ImmutableList<String>, V>> valuesSupplier, Class<V> valueClass) {
        super(name, description, valueDisplayName, MetricSchema.Kind.GAUGE, labels, valueClass);
        this.valuesSupplier = valuesSupplier;
    }

    @Override
    public ImmutableList<MetricPoint<V>> getTimestampedValues() {
        return this.getTimestampedValues(Instant.now());
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @VisibleForTesting
    ImmutableList<MetricPoint<V>> getTimestampedValues(Instant timestamp) {
        ImmutableMap values = (ImmutableMap)this.valuesSupplier.get();
        ImmutableList.Builder metricPoints = new ImmutableList.Builder();
        for (Map.Entry entry : values.entrySet()) {
            metricPoints.add(MetricPoint.create(this, (ImmutableList<String>)((ImmutableList)entry.getKey()), timestamp, timestamp, entry.getValue()));
        }
        this.cardinality = values.size();
        return metricPoints.build();
    }
}

