/*
 * Decompiled with CFR 0.152.
 */
package de.kalpatec.pojosr.framework;

import de.kalpatec.pojosr.framework.felix.framework.ServiceRegistry;
import de.kalpatec.pojosr.framework.felix.framework.capabilityset.SimpleFilter;
import de.kalpatec.pojosr.framework.felix.framework.util.EventDispatcher;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PojoSRBundleContext
implements BundleContext {
    private final Bundle m_bundle;
    private final ServiceRegistry m_reg;
    private final EventDispatcher m_dispatcher;
    private final Map<Long, Bundle> m_bundles;
    static /* synthetic */ Class class$org$osgi$framework$ServiceListener;
    static /* synthetic */ Class class$org$osgi$framework$FrameworkListener;
    static /* synthetic */ Class class$org$osgi$framework$BundleListener;

    public PojoSRBundleContext(Bundle bundle, ServiceRegistry reg, EventDispatcher dispatcher, Map<Long, Bundle> bundles) {
        this.m_bundle = bundle;
        this.m_reg = reg;
        this.m_dispatcher = dispatcher;
        this.m_bundles = bundles;
    }

    public boolean ungetService(ServiceReference reference) {
        return this.m_reg.ungetService(this.m_bundle, reference);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.m_dispatcher.removeListener(this, class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = PojoSRBundleContext.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener, (EventListener)listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.removeListener(this, class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = PojoSRBundleContext.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener, (EventListener)listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.m_dispatcher.removeListener(this, class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = PojoSRBundleContext.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener, (EventListener)listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.m_reg.registerService(this.m_bundle, new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.m_reg.registerService(this.m_bundle, clazzes, service, properties);
    }

    public Bundle installBundle(String location) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getAllServiceReferences(clazz, filter);
    }

    public ServiceReference getServiceReference(String clazz) {
        try {
            return this.getBestServiceReference(this.getAllServiceReferences(clazz, null));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private ServiceReference getBestServiceReference(ServiceReference[] refs) {
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference bestRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            if (bestRef.compareTo((Object)refs[i]) >= 0) continue;
            bestRef = refs[i];
        }
        return bestRef;
    }

    public Object getService(ServiceReference reference) {
        return this.m_reg.getService(this.m_bundle, reference);
    }

    public String getProperty(String key) {
        return System.getProperty(key);
    }

    public File getDataFile(String filename) {
        File root = new File(new StringBuffer().append("bundle").append(this.m_bundle.getBundleId()).toString());
        if (System.getProperty("org.osgi.framework.storage") != null) {
            root = new File(new File(System.getProperty("org.osgi.framework.storage")), root.getName());
        }
        root.mkdirs();
        return filename.trim().length() > 0 ? new File(root, filename) : root;
    }

    public Bundle[] getBundles() {
        Bundle[] result = this.m_bundles.values().toArray(new Bundle[this.m_bundles.size()]);
        Arrays.sort(result, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o1.getBundleId() - o2.getBundleId());
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((Bundle)x0, (Bundle)x1);
            }
        });
        return result;
    }

    public Bundle getBundle(long id) {
        return this.m_bundles.get(new Long(id));
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        List result;
        SimpleFilter simple = null;
        if (filter != null) {
            try {
                simple = SimpleFilter.parse(filter);
            }
            catch (Exception ex) {
                throw new InvalidSyntaxException(ex.getMessage(), filter);
            }
        }
        return (result = this.m_reg.getServiceReferences(clazz, simple)).isEmpty() ? null : result.toArray(new ServiceReference[result.size()]);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)filter);
    }

    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.m_dispatcher.addListener(this, class$org$osgi$framework$ServiceListener == null ? (class$org$osgi$framework$ServiceListener = PojoSRBundleContext.class$("org.osgi.framework.ServiceListener")) : class$org$osgi$framework$ServiceListener, (EventListener)listener, filter == null ? null : FrameworkUtil.createFilter((String)filter));
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.addListener(this, class$org$osgi$framework$FrameworkListener == null ? (class$org$osgi$framework$FrameworkListener = PojoSRBundleContext.class$("org.osgi.framework.FrameworkListener")) : class$org$osgi$framework$FrameworkListener, (EventListener)listener, null);
    }

    public void addBundleListener(BundleListener listener) {
        this.m_dispatcher.addListener(this, class$org$osgi$framework$BundleListener == null ? (class$org$osgi$framework$BundleListener = PojoSRBundleContext.class$("org.osgi.framework.BundleListener")) : class$org$osgi$framework$BundleListener, (EventListener)listener, null);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), service, properties);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(refs);
    }

    public Bundle getBundle(String location) {
        for (Bundle bundle : this.m_bundles.values()) {
            if (!location.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

