/*
 * Decompiled with CFR 0.152.
 */
package de.kalpatec.pojosr.framework;

import de.kalpatec.pojosr.framework.PojoSR;
import de.kalpatec.pojosr.framework.launch.ClasspathScanner;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistry;
import de.kalpatec.pojosr.framework.launch.PojoServiceRegistryFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;

public class PojoServiceRegistryFactoryImpl
implements PojoServiceRegistryFactory,
FrameworkFactory {
    public PojoServiceRegistry newPojoServiceRegistry(Map configuration) throws Exception {
        return new PojoSR(configuration);
    }

    public Framework newFramework(Map configuration) {
        return new FrameworkImpl((String)configuration.get("pojosr.filter"));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FrameworkImpl
    implements Framework {
        private final String m_filter;
        private volatile Bundle m_bundle = null;
        private volatile PojoServiceRegistry m_reg = null;

        public FrameworkImpl(String filter) {
            this.m_filter = filter;
        }

        public void init() throws BundleException {
            try {
                this.m_reg = new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(new HashMap());
                this.m_bundle = this.m_reg.getBundleContext().getBundle();
            }
            catch (Exception ex) {
                throw new BundleException("Unable to scan classpath", (Throwable)ex);
            }
        }

        public int getState() {
            return this.m_bundle == null ? 2 : this.m_bundle.getState();
        }

        public void start(int options) throws BundleException {
            this.start();
        }

        public void start() throws BundleException {
            try {
                this.m_reg.startBundles(this.m_filter != null ? new ClasspathScanner().scanForBundles(this.m_filter) : new ClasspathScanner().scanForBundles());
            }
            catch (Exception e) {
                throw new BundleException("Error starting framework", (Throwable)e);
            }
        }

        public void stop(int options) throws BundleException {
            this.m_bundle.stop(options);
        }

        public void stop() throws BundleException {
            this.m_bundle.stop();
        }

        public void update(InputStream input) throws BundleException {
            this.m_bundle.update(input);
        }

        public void update() throws BundleException {
            this.m_bundle.update();
        }

        public void uninstall() throws BundleException {
            this.m_bundle.uninstall();
        }

        public Dictionary getHeaders() {
            return this.m_bundle.getHeaders();
        }

        public long getBundleId() {
            return this.m_bundle.getBundleId();
        }

        public String getLocation() {
            return this.m_bundle.getLocation();
        }

        public ServiceReference[] getRegisteredServices() {
            return this.m_bundle.getRegisteredServices();
        }

        public ServiceReference[] getServicesInUse() {
            return this.m_bundle.getServicesInUse();
        }

        public boolean hasPermission(Object permission) {
            return this.m_bundle.hasPermission(permission);
        }

        public URL getResource(String name) {
            return this.m_bundle.getResource(name);
        }

        public Dictionary getHeaders(String locale) {
            return this.m_bundle.getHeaders(locale);
        }

        public String getSymbolicName() {
            return this.m_bundle.getSymbolicName();
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.m_bundle.loadClass(name);
        }

        public Enumeration getResources(String name) throws IOException {
            return this.m_bundle.getResources(name);
        }

        public Enumeration getEntryPaths(String path) {
            return this.m_bundle.getEntryPaths(path);
        }

        public URL getEntry(String path) {
            return this.m_bundle.getEntry(path);
        }

        public long getLastModified() {
            return this.m_bundle.getLastModified();
        }

        public Enumeration findEntries(String path, String filePattern, boolean recurse) {
            return this.m_bundle.findEntries(path, filePattern, recurse);
        }

        public BundleContext getBundleContext() {
            return this.m_bundle.getBundleContext();
        }

        public Map getSignerCertificates(int signersType) {
            return this.m_bundle.getSignerCertificates(signersType);
        }

        public Version getVersion() {
            return this.m_bundle.getVersion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
            final Object lock = new Object();
            this.m_bundle.getBundleContext().addBundleListener((BundleListener)new SynchronousBundleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void bundleChanged(BundleEvent event) {
                    if (event.getBundle() == FrameworkImpl.this.m_bundle && event.getType() == 4) {
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    }
                }
            });
            Object object = lock;
            synchronized (object) {
                while (this.m_bundle.getState() != 4) {
                    if (this.m_bundle.getState() == 16) {
                        lock.wait(100L);
                        continue;
                    }
                    lock.wait();
                }
            }
            return new FrameworkEvent(64, this.m_bundle, null);
        }

        public File getDataFile(String filename) {
            return this.m_bundle.getDataFile(filename);
        }

        public int compareTo(Bundle o) {
            if (o == this) {
                return 0;
            }
            return this.m_bundle.compareTo((Object)o);
        }

        public <A> A adapt(Class<A> type) {
            return (A)this.m_bundle.adapt(type);
        }

        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((Bundle)x0);
        }
    }
}

