/*
 * Decompiled with CFR 0.152.
 */
package de.kalpatec.pojosr.framework.felix.framework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class Util {
    private static final String DEFAULT_PROPERTIES_FILE = "default.properties";
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decTab = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public static String getDefaultProperty(String name) {
        String value = null;
        URL propURL = Util.class.getClassLoader().getResource(DEFAULT_PROPERTIES_FILE);
        if (propURL != null) {
            InputStream is = null;
            try {
                is = propURL.openConnection().getInputStream();
                Properties props = new Properties();
                props.load(is);
                is.close();
                value = props.getProperty(name);
                value = value != null ? Util.substVars(value, name, null, props) : null;
            }
            catch (Exception ex) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                ex.printStackTrace();
            }
        }
        return value;
    }

    public static long getBundleIdFromModuleId(String id) {
        try {
            String bundleId = id.indexOf(46) >= 0 ? id.substring(0, id.indexOf(46)) : id;
            return Long.parseLong(bundleId);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static int getModuleRevisionFromModuleId(String id) {
        try {
            int index = id.indexOf(46);
            if (index >= 0) {
                return Integer.parseInt(id.substring(index + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static String getClassName(String className) {
        if (className == null) {
            className = "";
        }
        return className.lastIndexOf(46) < 0 ? "" : className.substring(className.lastIndexOf(46) + 1);
    }

    public static String getClassPackage(String className) {
        if (className == null) {
            className = "";
        }
        return className.lastIndexOf(46) < 0 ? "" : className.substring(0, className.lastIndexOf(46));
    }

    public static String getResourcePackage(String resource) {
        if (resource == null) {
            resource = "";
        }
        String pkgName = resource.startsWith("/") ? resource.substring(1) : resource;
        pkgName = pkgName.lastIndexOf(47) < 0 ? "" : pkgName.substring(0, pkgName.lastIndexOf(47));
        pkgName = pkgName.replace('/', '.');
        return pkgName;
    }

    public static Class loadClassUsingClass(Class clazz, String name) {
        Class loadedClass = null;
        while (clazz != null) {
            ClassLoader loader = clazz.getClassLoader();
            loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                Class<?>[] ifcs = clazz.getInterfaces();
                for (int i = 0; i < ifcs.length; ++i) {
                    loadedClass = Util.loadClassUsingClass(ifcs[i], name);
                    if (loadedClass == null) continue;
                    return loadedClass;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static boolean isServiceAssignable(Bundle requester, ServiceReference ref) {
        boolean allow = true;
        String[] objectClass = (String[])ref.getProperty("objectClass");
        for (int classIdx = 0; allow && classIdx < objectClass.length; ++classIdx) {
            if (ref.isAssignableTo(requester, objectClass[classIdx])) continue;
            allow = false;
        }
        return allow;
    }

    public static String base64Encode(String s) throws IOException {
        return Util.encode(s.getBytes(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] in, int len) throws IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            bais = new ByteArrayInputStream(in);
            Util.encode(bais, baos, len);
            String string = new String(baos.toByteArray());
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static void encode(InputStream in, OutputStream out, int len) throws IOException {
        int b;
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int bits = 0;
        int nbits = 0;
        int nbytes = 0;
        while ((b = in.read()) != -1) {
            bits = bits << 8 | b;
            nbits += 8;
            while (nbits >= 6) {
                out.write(encTab[0x3F & bits >> (nbits -= 6)]);
                if (len == 0 || ++nbytes < len) continue;
                out.write(13);
                out.write(10);
                nbytes -= len;
            }
        }
        switch (nbits) {
            case 2: {
                out.write(encTab[0x3F & bits << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 4: {
                out.write(encTab[0x3F & bits << 2]);
                out.write(61);
            }
        }
        if (len != 0) {
            if (nbytes != 0) {
                out.write(13);
                out.write(10);
            }
            out.write(13);
            out.write(10);
        }
    }

    public static String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = -1;
        int startDelim = -1;
        do {
            int idx;
            if ((stopDelim = val.indexOf(DELIM_STOP, stopDelim + 1)) < 0) {
                return val;
            }
            startDelim = val.indexOf(DELIM_START);
            if (startDelim < 0) {
                return val;
            }
            while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
                if (idx >= stopDelim) continue;
                startDelim = idx;
            }
        } while (startDelim > stopDelim && stopDelim >= 0);
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = Util.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

