/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.tree.expressions;

import com.lyncode.jtwig.JtwigContext;
import com.lyncode.jtwig.exception.CalculateException;
import com.lyncode.jtwig.exception.ParseBypassException;
import com.lyncode.jtwig.exception.ParseException;
import com.lyncode.jtwig.tree.api.Expression;
import com.lyncode.jtwig.tree.expressions.Constant;
import java.util.ArrayList;
import java.util.List;

public class ValueList
implements Expression {
    private List<Expression> values = new ArrayList<Expression>();

    public static ValueList create(Constant init, Constant end) {
        ValueList valueList = new ValueList();
        if (init.isInstanceOf(Integer.class)) {
            int endValue;
            if (!end.isInstanceOf(Integer.class)) {
                throw new ParseBypassException(new ParseException("Expected an integer for the end of the comprehension list"));
            }
            int initValue = init.as(Integer.class);
            if (initValue < (endValue = end.as(Integer.class).intValue())) {
                for (int i = initValue; i <= endValue; ++i) {
                    valueList.add(new Constant<Integer>(i));
                }
            } else {
                for (int i = endValue; i >= initValue; --i) {
                    valueList.add(new Constant<Integer>(i));
                }
            }
        } else if (init.isInstanceOf(Character.class)) {
            char endValue;
            if (!end.isInstanceOf(Character.class)) {
                throw new ParseBypassException(new ParseException("Expected a character for the end of the comprehension list"));
            }
            char initValue = init.as(Character.class).charValue();
            if (initValue < (endValue = end.as(Character.class).charValue())) {
                for (char i = initValue; i <= endValue; i = (char)(i + '\u0001')) {
                    valueList.add(new Constant<Character>(Character.valueOf(i)));
                }
            } else {
                for (char i = endValue; i >= initValue; i = (char)(i - '\u0001')) {
                    valueList.add(new Constant<Character>(Character.valueOf(i)));
                }
            }
        } else {
            throw new ParseBypassException(new ParseException("Only integers and characters are allowed in comprehension lists"));
        }
        return valueList;
    }

    public boolean add(Expression element) {
        this.values.add(element);
        return true;
    }

    @Override
    public List<Object> calculate(JtwigContext context) throws CalculateException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression obj : this.values) {
            result.add(obj.calculate(context));
        }
        return result;
    }

    public Expression first() {
        return this.values.get(0);
    }

    public Expression get(int index) {
        return this.values.get(index);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }
}

