/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "audit";
    public static final String ENABLED = "enabled";
    static final String HEADERS = "headers";
    static final String AUDIT = "audit";
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMP = "timestamp";
    public static final Map<String, Object> config;
    private static final List<String> headerList;
    private static final List<String> auditList;
    private static boolean statusCode;
    private static boolean responseTime;
    static final Logger audit;
    public static final AttachmentKey<Map> AUDIT_INFO;
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map auditInfo = (Map)exchange.getAttachment(AUDIT_INFO);
        LinkedHashMap<String, Object> auditMap = new LinkedHashMap<String, Object>();
        long start = System.currentTimeMillis();
        auditMap.put(TIMESTAMP, System.currentTimeMillis());
        if (auditInfo != null && auditList != null && auditList.size() > 0) {
            for (String name : auditList) {
                auditMap.put(name, auditInfo.get(name));
            }
        }
        if (headerList != null && headerList.size() > 0) {
            for (String name : headerList) {
                auditMap.put(name, exchange.getRequestHeaders().getFirst(name));
            }
        }
        if (statusCode || responseTime) {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                if (statusCode) {
                    auditMap.put(STATUS_CODE, exchange1.getStatusCode());
                }
                if (responseTime) {
                    auditMap.put(RESPONSE_TIME, System.currentTimeMillis() - start);
                }
                nextListener.proceed();
            });
        }
        audit.info(Config.getInstance().getMapper().writeValueAsString(auditMap));
        this.next.handleRequest(exchange);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    public void register() {
        ModuleRegistry.registerModule((String)AuditHandler.class.getName(), config, null);
    }

    static {
        statusCode = false;
        responseTime = false;
        audit = LoggerFactory.getLogger((String)"Audit");
        AUDIT_INFO = AttachmentKey.create(Map.class);
        config = Config.getInstance().getJsonMapConfigNoCache("audit");
        headerList = (List)config.get(HEADERS);
        auditList = (List)config.get("audit");
        Object object = config.get(STATUS_CODE);
        if (object != null && ((Boolean)object).booleanValue()) {
            statusCode = true;
        }
        if ((object = config.get(RESPONSE_TIME)) != null && ((Boolean)object).booleanValue()) {
            responseTime = true;
        }
    }
}

