/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.config.Config;
import com.networknt.exception.ExpiredTokenException;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.security.JwtHelper;
import com.networknt.status.Status;
import com.networknt.swagger.ApiNormalisedPath;
import com.networknt.swagger.NormalisedPath;
import com.networknt.swagger.SwaggerHandler;
import com.networknt.swagger.SwaggerHelper;
import com.networknt.swagger.SwaggerOperation;
import com.networknt.utility.ModuleRegistry;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtVerifyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(JwtVerifyHandler.class);
    static final String ENABLE_VERIFY_SCOPE = "enableVerifyScope";
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static final Map<String, Object> config = Config.getInstance().getJsonMapConfig("security");
    private volatile HttpHandler next;

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        String jwt = JwtHelper.getJwtFromAuthorization((String)authorization);
        if (jwt != null) {
            try {
                JwtClaims claims = JwtHelper.verifyJwt((String)jwt);
                headerMap.add(new HttpString("client_id"), claims.getStringClaimValue("client_id"));
                headerMap.add(new HttpString("user_id"), claims.getStringClaimValue("user_id"));
                headerMap.add(new HttpString("scope"), claims.getStringListClaimValue("scope").toString());
                if (config != null && ((Boolean)config.get(ENABLE_VERIFY_SCOPE)).booleanValue() && SwaggerHelper.swagger != null) {
                    Status status3;
                    Operation operation;
                    SwaggerOperation swaggerOperation = (SwaggerOperation)exchange.getAttachment(SwaggerHandler.SWAGGER_OPERATION);
                    if (swaggerOperation == null) {
                        ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI());
                        Optional maybeApiPath = SwaggerHelper.findMatchingApiPath((NormalisedPath)requestPath);
                        if (!maybeApiPath.isPresent()) {
                            Status status2 = new Status(STATUS_INVALID_REQUEST_PATH, new Object[0]);
                            exchange.setStatusCode(status2.getStatusCode());
                            exchange.getResponseSender().send(status2.toString());
                            return;
                        }
                        NormalisedPath swaggerPathString = (NormalisedPath)maybeApiPath.get();
                        Path swaggerPath = SwaggerHelper.swagger.getPath(swaggerPathString.original());
                        HttpMethod httpMethod = HttpMethod.valueOf((String)exchange.getRequestMethod().toString());
                        operation = (Operation)swaggerPath.getOperationMap().get(httpMethod);
                        if (operation == null) {
                            Status status3 = new Status(STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                            exchange.setStatusCode(status3.getStatusCode());
                            exchange.getResponseSender().send(status3.toString());
                            return;
                        }
                        swaggerOperation = new SwaggerOperation(swaggerPathString, swaggerPath, httpMethod, operation);
                        swaggerOperation.setEndpoint(swaggerPathString.normalised() + "@" + httpMethod);
                        swaggerOperation.setClientId(claims.getStringClaimValue("client_id"));
                        exchange.putAttachment(SwaggerHandler.SWAGGER_OPERATION, (Object)swaggerOperation);
                    } else {
                        operation = swaggerOperation.getOperation();
                        swaggerOperation.setClientId(claims.getStringClaimValue("client_id"));
                    }
                    String scopeHeader = headerMap.getFirst("X-Scope-Token");
                    String scopeJwt = JwtHelper.getJwtFromAuthorization((String)scopeHeader);
                    List secondaryScopes = null;
                    if (scopeJwt != null) {
                        Status status4;
                        try {
                            JwtClaims scopeClaims = JwtHelper.verifyJwt((String)scopeJwt);
                            secondaryScopes = scopeClaims.getStringListClaimValue("scope");
                            headerMap.add(new HttpString("scope_client_id"), scopeClaims.getStringClaimValue("client_id"));
                        }
                        catch (MalformedClaimException | InvalidJwtException e) {
                            logger.error("InvalidJwtException", e);
                            status4 = new Status(STATUS_INVALID_SCOPE_TOKEN, new Object[0]);
                            exchange.setStatusCode(status4.getStatusCode());
                            exchange.getResponseSender().send(status4.toString());
                            return;
                        }
                        catch (ExpiredTokenException e) {
                            status4 = new Status(STATUS_SCOPE_TOKEN_EXPIRED, new Object[0]);
                            exchange.setStatusCode(status4.getStatusCode());
                            exchange.getResponseSender().send(status4.toString());
                            return;
                        }
                    }
                    List specScopes = null;
                    List security = operation.getSecurity();
                    if (security != null) {
                        Map requirement;
                        status3 = security.iterator();
                        while (status3.hasNext() && (specScopes = (List)(requirement = (Map)status3.next()).get(SwaggerHelper.oauth2Name)) == null) {
                        }
                    }
                    if (scopeHeader != null) {
                        if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Scopes " + secondaryScopes + " and specificatio token " + specScopes + " are not matched in scope token");
                            }
                            status3 = new Status(STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, new Object[]{secondaryScopes, specScopes});
                            exchange.setStatusCode(status3.getStatusCode());
                            exchange.getResponseSender().send(status3.toString());
                            return;
                        }
                    } else {
                        List primaryScopes;
                        try {
                            primaryScopes = claims.getStringListClaimValue("scope");
                        }
                        catch (MalformedClaimException e) {
                            logger.error("MalformedClaimException", (Throwable)e);
                            Status status5 = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                            exchange.setStatusCode(status5.getStatusCode());
                            exchange.getResponseSender().send(status5.toString());
                            return;
                        }
                        if (!this.matchedScopes(primaryScopes, specScopes)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Authorization jwt token scope " + primaryScopes + " is not matched with " + specScopes);
                            }
                            Status status6 = new Status(STATUS_AUTH_TOKEN_SCOPE_MISMATCH, new Object[]{primaryScopes, specScopes});
                            exchange.setStatusCode(status6.getStatusCode());
                            exchange.getResponseSender().send(status6.toString());
                            return;
                        }
                    }
                }
                this.next.handleRequest(exchange);
            }
            catch (InvalidJwtException e) {
                logger.error("Exception: ", (Throwable)e);
                Status status = new Status(STATUS_INVALID_AUTH_TOKEN, new Object[0]);
                exchange.setStatusCode(status.getStatusCode());
                exchange.getResponseSender().send(status.toString());
            }
            catch (ExpiredTokenException e) {
                Status status = new Status(STATUS_AUTH_TOKEN_EXPIRED, new Object[0]);
                exchange.setStatusCode(status.getStatusCode());
                exchange.getResponseSender().send(status.toString());
            }
        } else {
            Status status = new Status(STATUS_MISSING_AUTH_TOKEN, new Object[0]);
            exchange.setStatusCode(status.getStatusCode());
            exchange.getResponseSender().send(status.toString());
        }
    }

    protected boolean matchedScopes(List<String> jwtScopes, List<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (jwtScopes != null && jwtScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!jwtScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        Object object = config.get("enableVerifyJwt");
        return object != null && (Boolean)object != false;
    }

    public void register() {
        ModuleRegistry.registerModule((String)JwtVerifyHandler.class.getName(), config, null);
    }
}

