/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.spi;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public interface Environment {
    public File basedir();

    public File tempdir();

    public File outdir();

    public String param(String var1, String var2);

    public ClassLoader classloader();

    public Collection<String> classpath();

    public Collection<File> files(String var1);

    public boolean exclude(String var1, String var2);

    public Collection<String> excludes(String var1);

    public static final class Mock
    implements Environment {
        private final transient File basedir;
        private final transient Set<String> classpath = new HashSet<String>(0);
        private final transient ConcurrentMap<String, String> params = new ConcurrentHashMap<String, String>();
        private transient String excl;

        public Mock() throws IOException {
            File temp = File.createTempFile("mock", ".qulice", new File(System.getProperty("java.io.tmpdir")));
            if (!temp.delete()) {
                throw new IllegalStateException("files collision");
            }
            if (!temp.mkdirs()) {
                throw new IllegalStateException("mkdir failed");
            }
            FileUtils.forceDeleteOnExit((File)temp);
            this.basedir = new File(temp, "basedir");
            if (this.basedir.mkdirs()) assert (this.basedir != null);
            this.classpath.add(this.outdir().getAbsolutePath().replace(File.separatorChar, '/'));
        }

        public Mock withParam(String name, String value) {
            this.params.put(name, value);
            return this;
        }

        public Mock withFile(String name, String content) throws IOException {
            File file = new File(this.basedir, name);
            FileUtils.writeStringToFile((File)file, (String)content);
            return this;
        }

        public Mock withFile(String name, byte[] bytes) throws IOException {
            File file = new File(this.basedir, name);
            FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
            return this;
        }

        public Mock withExcludes(String excludes) {
            this.excl = excludes;
            return this;
        }

        public Mock withDefaultClasspath() {
            Collections.addAll(this.classpath, System.getProperty("java.class.path").split(System.getProperty("path.separator")));
            return this;
        }

        @Override
        public File basedir() {
            return this.basedir;
        }

        @Override
        public File tempdir() {
            File file = new File(this.basedir, "target/tempdir");
            if (file.mkdirs()) assert (file != null);
            return file;
        }

        @Override
        public File outdir() {
            File file = new File(this.basedir, "target/classes");
            if (file.mkdirs()) assert (file != null);
            return file;
        }

        @Override
        public String param(String name, String value) {
            String val = (String)this.params.get(name);
            if (val == null) {
                val = value;
            }
            return val;
        }

        @Override
        public ClassLoader classloader() {
            return Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Collection<String> classpath() {
            return Collections.unmodifiableCollection(this.classpath);
        }

        @Override
        public Collection<File> files(String pattern) {
            String[] dirs;
            LinkedList<File> files = new LinkedList<File>();
            WildcardFileFilter filter = new WildcardFileFilter(pattern);
            for (String dir : dirs = new String[]{"src"}) {
                File sources = new File(this.basedir(), dir);
                if (!sources.exists()) continue;
                files.addAll(FileUtils.listFiles((File)sources, (IOFileFilter)filter, (IOFileFilter)DirectoryFileFilter.INSTANCE));
            }
            return files;
        }

        @Override
        public boolean exclude(String check, String name) {
            return false;
        }

        @Override
        public Collection<String> excludes(String checker) {
            List<String> exc = this.excl == null ? Collections.emptyList() : Arrays.asList(this.excl.split(","));
            return exc;
        }
    }
}

