/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.channel;

import com.twitter.finagle.Failure;
import com.twitter.finagle.netty4.channel.ChannelStats;
import com.twitter.finagle.netty4.channel.ChannelStatsHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Duration;
import com.twitter.util.Monitor$;
import com.twitter.util.Stopwatch$;
import com.twitter.util.TimeLike;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.Attribute;
import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ChannelHandler.Sharable
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dwAB\u0001\u0003\u0011\u0003!A\"A\nDQ\u0006tg.\u001a7Ti\u0006$8\u000fS1oI2,'O\u0003\u0002\u0004\t\u000591\r[1o]\u0016d'BA\u0003\u0007\u0003\u0019qW\r\u001e;zi)\u0011q\u0001C\u0001\bM&t\u0017m\u001a7f\u0015\tI!\"A\u0004uo&$H/\u001a:\u000b\u0003-\t1aY8n!\tia\"D\u0001\u0003\r\u0019y!\u0001#\u0001\u0005!\t\u00192\t[1o]\u0016d7\u000b^1ug\"\u000bg\u000e\u001a7feN\u0011a\"\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000baqA\u0011\u0001\u000e\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0004\u0005\t99\u0011\r\u0011\"\u0001\u0003;\u0005\u00112i\u001c8oK\u000e$\u0018n\u001c8Ti\u0006$8oS3z+\u0005q\u0002cA\u0010'Q5\t\u0001E\u0003\u0002\"E\u0005!Q\u000f^5m\u0015\t\u0019C%A\u0003oKR$\u0018PC\u0001&\u0003\tIw.\u0003\u0002(A\ta\u0011\t\u001e;sS\n,H/Z&fsB\u0011Q\"K\u0005\u0003U\t\u0011Ab\u00115b]:,Gn\u0015;biNDa\u0001\f\b!\u0002\u0013q\u0012aE\"p]:,7\r^5p]N#\u0018\r^:LKf\u0004\u0003\u0002\u0003\u0018\u000f\u0005\u0004%\tAA\u0018\u0002+\r{gN\\3di&|g\u000eR;sCRLwN\\&fsV\t\u0001\u0007E\u0002 ME\u0002\"AM\u001c\u000f\u0005M*T\"\u0001\u001b\u000b\u0005\u0005B\u0011B\u0001\u001c5\u0003%\u0019Fo\u001c9xCR\u001c\u0007.\u0003\u00029s\t9Q\t\\1qg\u0016$\u0017B\u0001\u001e5\u0005%\u0019Fo\u001c9xCR\u001c\u0007\u000e\u0003\u0004=\u001d\u0001\u0006I\u0001M\u0001\u0017\u0007>tg.Z2uS>tG)\u001e:bi&|gnS3zA!AaH\u0004b\u0001\n\u0003\u0011q(A\u000bDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=\u0016\u0003\u0001\u00032a\b\u0014B!\t\u0011\")\u0003\u0002D'\t9!i\\8mK\u0006t\u0007BB#\u000fA\u0003%\u0001)\u0001\fDQ\u0006tg.\u001a7XCN<&/\u001b;bE2,7*Z=!\u0011!9eB1A\u0005\u0002\ty\u0013AG\"iC:tW\r\\,sSR\f'\r\\3EkJ\fG/[8o\u0017\u0016L\bBB%\u000fA\u0003%\u0001'A\u000eDQ\u0006tg.\u001a7Xe&$\u0018M\u00197f\tV\u0014\u0018\r^5p].+\u0017\u0010\t\u0004\u0006\u001f\t\u0001AaS\n\u0003\u00152\u0003\"!T(\u000e\u00039S!a\u0001\u0012\n\u0005As%\u0001F\"iC:tW\r\u001c#va2,\u0007\u0010S1oI2,'\u000f\u0003\u0005S\u0015\n\u0005\t\u0015!\u0003T\u00035\u0019H/\u0019;t%\u0016\u001cW-\u001b<feB\u0011AkV\u0007\u0002+*\u0011aKB\u0001\u0006gR\fGo]\u0005\u00031V\u0013Qb\u0015;biN\u0014VmY3jm\u0016\u0014\b\"\u0002\rK\t\u0003QFCA.]!\ti!\nC\u0003S3\u0002\u00071\u000b\u0003\u0004_\u0015\u0002\u0006IaX\u0001\u0004Y><\u0007C\u00011g\u001b\u0005\t'B\u00012d\u0003\u001dawnZ4j]\u001eT!!\t3\u000b\u0003\u0015\fAA[1wC&\u0011q-\u0019\u0002\u0007\u0019><w-\u001a:\t\r%T\u0005\u0015!\u0003k\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$\bCA6q\u001b\u0005a'BA7o\u0003\u0019\tGo\\7jG*\u0011qnY\u0001\u000bG>t7-\u001e:sK:$\u0018BA9m\u0005%auN\\4BI\u0012,'\u000f\u0003\u0004t\u0015\u0002\u0006I\u0001^\u0001\tG>tg.Z2ugB\u0011A+^\u0005\u0003mV\u0013qaQ8v]R,'\u000f\u0003\u0004y\u0015\u0002\u0006I!_\u0001\u0013G>tg.Z2uS>tG)\u001e:bi&|g\u000e\u0005\u0002Uu&\u001110\u0016\u0002\u0005'R\fG\u000f\u0003\u0004~\u0015\u0002\u0006I!_\u0001\u0018G>tg.Z2uS>t'+Z2fSZ,GMQ=uKNDaa &!\u0002\u0013I\u0018aE2p]:,7\r^5p]N+g\u000e\u001e\"zi\u0016\u001c\bbBA\u0002\u0015\u0002\u0006I\u0001^\u0001\u000ee\u0016\u001cW-\u001b<fI\nKH/Z:\t\u000f\u0005\u001d!\n)A\u0005i\u0006I1/\u001a8u\u0005f$Xm\u001d\u0005\b\u0003\u0017Q\u0005\u0015!\u0003u\u0003!9(/\u001b;bE2,\u0007bBA\b\u0015\u0002\u0006I\u0001^\u0001\u000bk:<(/\u001b;bE2,\u0007bBA\n\u0015\u0002\u0006IaU\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\bbBA\f\u0015\u0002\u0006I\u0001^\u0001\fG2|7/Z:D_VtG\u000f\u0003\u0005\u0002\u001c)\u0003\u000b\u0011BA\u000f\u0003-\u0019wN\u001c8fGRLwN\\:\u0011\u0007Q\u000by\"C\u0002\u0002\"U\u0013QaR1vO\u0016Dq!!\nK\t\u0003\n9#\u0001\u0007iC:$G.\u001a:BI\u0012,G\r\u0006\u0003\u0002*\u0005=\u0002c\u0001\n\u0002,%\u0019\u0011QF\n\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003c\t\u0019\u00031\u0001\u00024\u0005\u00191\r\u001e=\u0011\u00075\u000b)$C\u0002\u000289\u0013Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0004\u0002<)#\t%!\u0010\u0002\u001b\rD\u0017M\u001c8fY\u0006\u001bG/\u001b<f)\u0011\tI#a\u0010\t\u0011\u0005E\u0012\u0011\ba\u0001\u0003gAq!a\u0011K\t\u0003\n)%A\u0003xe&$X\r\u0006\u0005\u0002*\u0005\u001d\u0013\u0011JA-\u0011!\t\t$!\u0011A\u0002\u0005M\u0002\u0002CA&\u0003\u0003\u0002\r!!\u0014\u0002\u00075\u001cx\r\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019\u0006Z\u0001\u0005Y\u0006tw-\u0003\u0003\u0002X\u0005E#AB(cU\u0016\u001cG\u000f\u0003\u0005\u0002\\\u0005\u0005\u0003\u0019AA/\u0003\u0005\u0001\bcA'\u0002`%\u0019\u0011\u0011\r(\u0003\u001d\rC\u0017M\u001c8fYB\u0013x.\\5tK\"9\u0011Q\r&\u0005B\u0005\u001d\u0014aC2iC:tW\r\u001c*fC\u0012$b!!\u000b\u0002j\u0005-\u0004\u0002CA\u0019\u0003G\u0002\r!a\r\t\u0011\u0005-\u00131\ra\u0001\u0003\u001bBq!a\u001cK\t\u0003\n\t(A\u0003dY>\u001cX\r\u0006\u0004\u0002*\u0005M\u0014Q\u000f\u0005\t\u0003c\ti\u00071\u0001\u00024!A\u00111LA7\u0001\u0004\ti\u0006C\u0004\u0002z)#\t%a\u001f\u0002\u001f\rD\u0017M\u001c8fY&s\u0017m\u0019;jm\u0016$B!!\u000b\u0002~!A\u0011\u0011GA<\u0001\u0004\t\u0019\u0004C\u0004\u0002\u0002*#\t%a!\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!!\u000b\u0002\u0006\u0006\u001d\u0005\u0002CA\u0019\u0003\u007f\u0002\r!a\r\t\u0011\u0005%\u0015q\u0010a\u0001\u0003\u0017\u000bQaY1vg\u0016\u0004B!!$\u0002\u001e:!\u0011qRAM\u001d\u0011\t\t*a&\u000e\u0005\u0005M%bAAK3\u00051AH]8pizJ\u0011\u0001F\u0005\u0004\u00037\u001b\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003?\u000b\tKA\u0005UQJ|w/\u00192mK*\u0019\u00111T\n\t\u000f\u0005\u0015&\n\"\u0011\u0002(\u0006I2\r[1o]\u0016dwK]5uC\nLG.\u001b;z\u0007\"\fgnZ3e)\u0011\tI#!+\t\u0011\u0005E\u00121\u0015a\u0001\u0003gA3ASAW!\u0011\ty+!1\u000f\t\u0005E\u0016Q\u0018\b\u0005\u0003g\u000bYL\u0004\u0003\u00026\u0006ef\u0002BAI\u0003oK\u0011!J\u0005\u0003G\u0011J!a\u0001\u0012\n\u0007\u0005}f*\u0001\bDQ\u0006tg.\u001a7IC:$G.\u001a:\n\t\u0005\r\u0017Q\u0019\u0002\t'\"\f'/\u00192mK*\u0019\u0011q\u0018(")
public class ChannelStatsHandler
extends ChannelDuplexHandler {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    public final LongAdder com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount = new LongAdder();
    private final Counter connects;
    private final Stat connectionDuration;
    private final Stat connectionReceivedBytes;
    private final Stat connectionSentBytes;
    private final Counter receivedBytes;
    private final Counter sentBytes;
    private final Counter writable;
    private final Counter unwritable;
    private final StatsReceiver exceptions;
    private final Counter closesCount;
    private final Gauge connections;

    public void handlerAdded(ChannelHandlerContext ctx) {
        ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).set((Object)new ChannelStats(new LongAdder(), new LongAdder()));
        ctx.channel().attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey()).set((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ctx.channel().attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.connects.incr();
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.increment();
        ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).set((Object)Stopwatch$.MODULE$.start());
        super.channelActive(ctx);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            int readableBytes = byteBuf.readableBytes();
            LongAdder channelWriteCount = ((ChannelStats)ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesWritten();
            channelWriteCount.add(readableBytes);
            this.sentBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer write");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.write(ctx, msg, p);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            LongAdder channelReadCount = ((ChannelStats)ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get()).bytesRead();
            int readableBytes = byteBuf.readableBytes();
            channelReadCount.add(readableBytes);
            this.receivedBytes.incr(readableBytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.log.warning("ChannelStatsHandler received non-channelbuffer read");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.channelRead(ctx, msg);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise p) {
        this.closesCount.incr();
        super.close(ctx, p);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ChannelStats channelStats = (ChannelStats)ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionStatsKey()).get();
        this.connectionReceivedBytes.add((float)channelStats.bytesRead().sum());
        this.connectionSentBytes.add((float)channelStats.bytesWritten().sum());
        Function0 function0 = (Function0)ctx.channel().attr(ChannelStatsHandler$.MODULE$.ConnectionDurationKey()).get();
        if (function0 == null) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.connectionDuration.add((float)((TimeLike)function0.apply()).inMilliseconds());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.decrement();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.exceptions.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{cause.getClass().getName()})).incr();
        if (!Monitor$.MODULE$.isActive()) {
            Level level;
            Throwable throwable = cause;
            if (throwable instanceof IOException) {
                level = Level.FINE;
            } else if (throwable instanceof Failure) {
                Failure failure = (Failure)throwable;
                level = failure.logLevel();
            } else {
                level = Level.WARNING;
            }
            Level level2 = level;
            this.log.log(level2, "ChannelStatsHandler caught an exception", cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        Attribute wasWritableAttr;
        boolean isWritable = ctx.channel().isWritable();
        if (isWritable != BoxesRunTime.unboxToBoolean((Object)(wasWritableAttr = ctx.channel().attr(ChannelStatsHandler$.MODULE$.ChannelWasWritableKey())).get())) {
            Attribute writableDuration = ctx.channel().attr(ChannelStatsHandler$.MODULE$.ChannelWritableDurationKey());
            Duration elapsed = (Duration)((Function0)writableDuration.get()).apply();
            Counter stat = BoxesRunTime.unboxToBoolean((Object)wasWritableAttr.get()) ? this.writable : this.unwritable;
            stat.incr((int)elapsed.inMilliseconds());
            wasWritableAttr.set((Object)BoxesRunTime.boxToBoolean((boolean)isWritable));
            writableDuration.set((Object)Stopwatch$.MODULE$.start());
        }
        super.channelWritabilityChanged(ctx);
    }

    public ChannelStatsHandler(StatsReceiver statsReceiver) {
        this.connects = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connects"}));
        this.connectionDuration = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_duration"}));
        this.connectionReceivedBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_received_bytes"}));
        this.connectionSentBytes = statsReceiver.stat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connection_sent_bytes"}));
        this.receivedBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"received_bytes"}));
        this.sentBytes = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sent_bytes"}));
        this.writable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_writable_ms"}));
        this.unwritable = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"socket_unwritable_ms"}));
        this.exceptions = statsReceiver.scope("exn");
        this.closesCount = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"closes"}));
        this.connections = statsReceiver.addGauge((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connections"}), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChannelStatsHandler $outer;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return this.$outer.com$twitter$finagle$netty4$channel$ChannelStatsHandler$$connectionCount.sum();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

