/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;

public class HeartbeatInterceptor
extends AtmosphereInterceptorAdapter {
    public static final String HEARTBEAT_INTERVAL_IN_SECONDS = HeartbeatInterceptor.class.getName() + ".heartbeatFrequencyInSeconds";
    public static final String INTERCEPTOR_ADDED = HeartbeatInterceptor.class.getName();
    public static final String HEARTBEAT_FUTURE = "heartbeat.future";
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatInterceptor.class);
    private ScheduledExecutorService heartBeat;
    private byte[] paddingBytes = " ".getBytes();
    private int heartbeatFrequencyInSeconds = 60;

    public HeartbeatInterceptor paddingText(byte[] paddingBytes) {
        this.paddingBytes = paddingBytes;
        return this;
    }

    public HeartbeatInterceptor heartbeatFrequencyInSeconds(int heartbeatFrequencyInSeconds) {
        this.heartbeatFrequencyInSeconds = heartbeatFrequencyInSeconds;
        return this;
    }

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter(HEARTBEAT_INTERVAL_IN_SECONDS);
        if (s != null) {
            this.heartbeatFrequencyInSeconds = Integer.valueOf(s);
        }
        this.heartBeat = ExecutorsFactory.getScheduler(config);
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        final AtmosphereResponse response = r.getResponse();
        final AtmosphereRequest request = r.getRequest();
        if (Utils.pollableTransport(r.transport())) {
            return Action.CONTINUE;
        }
        super.inspect(r);
        r.addEventListener(new Clock(){

            @Override
            public void onSuspend(AtmosphereResourceEvent event) {
                HeartbeatInterceptor.this.clock(r, request, response);
            }

            @Override
            public void onResume(AtmosphereResourceEvent event) {
                HeartbeatInterceptor.this.cancelF(request);
            }

            @Override
            public void onDisconnect(AtmosphereResourceEvent event) {
                HeartbeatInterceptor.this.cancelF(request);
            }

            @Override
            public void onClose(AtmosphereResourceEvent event) {
                HeartbeatInterceptor.this.cancelF(request);
            }
        });
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (!Utils.resumableTransport(r.transport()) && AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass()) && r.getRequest().getAttribute(INTERCEPTOR_ADDED) == null) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(new AsyncIOInterceptorAdapter(){

                @Override
                public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
                    HeartbeatInterceptor.this.cancelF(request);
                    return responseDraft;
                }

                @Override
                public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                    logger.trace("Scheduling heartbeat for {}", (Object)r.uuid());
                    HeartbeatInterceptor.this.clock(r, request, response);
                }
            });
            r.getRequest().setAttribute(INTERCEPTOR_ADDED, Boolean.TRUE);
        }
        return Action.CONTINUE;
    }

    void cancelF(AtmosphereRequest request) {
        try {
            Future f = (Future)request.getAttribute(HEARTBEAT_FUTURE);
            if (f != null) {
                f.cancel(false);
            }
            request.removeAttribute(HEARTBEAT_FUTURE);
        }
        catch (Exception ex) {
            logger.trace("", (Throwable)ex);
        }
    }

    public HeartbeatInterceptor clock(final AtmosphereResource r, final AtmosphereRequest request, final AtmosphereResponse response) {
        request.setAttribute(HEARTBEAT_FUTURE, this.heartBeat.schedule(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                block5: {
                    if (((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).isInScope() && r.isSuspended()) {
                        try {
                            logger.trace("Heartbeat for Resource {}", (Object)r);
                            response.write(HeartbeatInterceptor.this.paddingBytes, false);
                            if (Utils.resumableTransport(r.transport())) {
                                r.resume();
                                break block5;
                            }
                            response.flushBuffer();
                        }
                        catch (Throwable t) {
                            logger.trace("{}", (Object)r.uuid(), (Object)t);
                            HeartbeatInterceptor.this.cancelF(request);
                        }
                    } else {
                        HeartbeatInterceptor.this.cancelF(request);
                    }
                }
                return null;
            }
        }, (long)this.heartbeatFrequencyInSeconds, TimeUnit.SECONDS));
        return this;
    }

    @Override
    public String toString() {
        return "Heartbeat Interceptor Support";
    }

    private static class Clock
    extends AtmosphereResourceEventListenerAdapter
    implements AllowInterceptor {
    }
}

