/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.bind.DatatypeConverter;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;

public class TrackMessageSizeB64Interceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TrackMessageSizeB64Interceptor.class);
    private static final String DELIMITER = "|";
    private static final String OUT_ENCODING = "UTF-8";
    public static final String SKIP_INTERCEPTOR = TrackMessageSizeB64Interceptor.class.getName() + ".skip";
    private final HashSet<String> excludedContentTypes = new HashSet();
    private final Interceptor interceptor = new Interceptor();

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.client.TrackMessageSizeInterceptor.excludedContentType");
        if (s != null) {
            this.excludedContentTypes.addAll(Arrays.asList(s.split(",")));
        }
    }

    public TrackMessageSizeB64Interceptor excludedContentType(String excludedContentType) {
        this.excludedContentTypes.add(excludedContentType.toLowerCase());
        return this;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereResponse response = r.getResponse();
        super.inspect(r);
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            ((AtmosphereInterceptorWriter)AtmosphereInterceptorWriter.class.cast(writer)).interceptor(this.interceptor);
        } else {
            logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return " Track Message Size Base64 Interceptor using |";
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        @Override
        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            if (!(response.request().getAttribute(SKIP_INTERCEPTOR) != null || response.getContentType() != null && TrackMessageSizeB64Interceptor.this.excludedContentTypes.contains(response.getContentType().toLowerCase()))) {
                response.setCharacterEncoding(TrackMessageSizeB64Interceptor.OUT_ENCODING);
                String s = DatatypeConverter.printBase64Binary((byte[])responseDraft);
                StringBuilder sb = new StringBuilder();
                sb.append(s.length()).append(TrackMessageSizeB64Interceptor.DELIMITER).append(s);
                return sb.toString().getBytes(TrackMessageSizeB64Interceptor.OUT_ENCODING);
            }
            return responseDraft;
        }
    }
}

