/* Generated By:JavaCC: Do not edit this line. Parser.java */
package com.vaadin.sass.internal.parser;

import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.LexicalUnit;

import org.w3c.flute.parser.selectors.SelectorFactoryImpl;
import org.w3c.flute.parser.selectors.ConditionFactoryImpl;

import org.w3c.flute.util.Encoding;

import com.vaadin.sass.internal.handler.*;

import com.vaadin.sass.internal.tree.*;

/**
 * A CSS2 parser
 *
 * @author Philippe Le H�garet
 * @version $Revision: 1.15 $
 */
public class Parser implements org.w3c.css.sac.Parser, ParserConstants {

    // replaces all \t, \n, etc with this StringBuffer.
    static final StringBuilder SPACE = new StringBuilder(" ");

    // the document handler for the parser
    protected SCSSDocumentHandlerImpl documentHandler;
    // the error handler for the parser
    protected ErrorHandler errorHandler;
    // the input source for the parser
    protected InputSource source;

    protected ConditionFactory conditionFactory;
    protected SelectorFactory selectorFactory;

    // temporary place holder for pseudo-element ...
    private String pseudoElt;

    /**
     * Creates a new Parser
     */
    public Parser() {
        this((CharStream) null);
    }

    /**
     * @@TODO
     * @exception CSSException Not yet implemented
     */
    public void setLocale(Locale locale) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    public InputSource getInputSource(){
        return source;
    }

    /**
     * Set the document handler for this parser
     */
    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = (SCSSDocumentHandlerImpl) handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory = conditionFactory;
    }

    /**
     * Set the error handler for this parser
     */
    public void setErrorHandler(ErrorHandler error) {
        this.errorHandler = error;
    }

    /**
     * Main parse methods
     *
     * @param source the source of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));
        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }

        parserUnit();
    }

    /**
     * Convenient method for URIs.
     *
     * @param systemId the fully resolved URI of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(String systemId)
            throws CSSException, IOException {
        parseStyleSheet(new InputSource(systemId));
    }

    /**
     * This method parses only one rule (style rule or at-rule, except @charset).
     *
     * @param source the source of the rule.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    // TODO required by original parser but not used by Vaadin?
    public void parseRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseRule();
    }

    /**
     * This method parses a style declaration (including the surrounding curly
     * braces).
     *
     * @param source the source of the style declaration.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleDeclaration(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseDeclarationBlock();
    }

    /**
     * This methods returns "http://www.w3.org/TR/REC-CSS2".
     * @return the string "http://www.w3.org/TR/REC-CSS2".
     */
    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    /**
     * Parse methods used by DOM Level 2 implementation.
     */
    public void parseImportRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseImportRule();
    }

    public void parseMediaRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseMediaRule();
    }

    public SelectorList parseSelectors(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return null;
    }

    public LexicalUnit parsePropertyValue(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return expr();
    }

    public boolean parsePriority(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return prio();
    }

    /**
     * Convert the source into a Reader. Used only by DOM Level 2 parser methods.
     */
    private Reader getReader(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        } else if (source.getByteStream() != null) {
            // My DOM level 2 implementation doesn't use this case.
            if (source.getEncoding() == null) {
                // unknown encoding, use ASCII as default.
                return new InputStreamReader(source.getByteStream(), "ASCII");
            } else {
                return new InputStreamReader(source.getByteStream(),
                                             source.getEncoding());
            }
        } else {
            // systemId
            // @@TODO
            throw new CSSException("not yet implemented");
        }
    }

    /**
     * Convert the source into a CharStream with encoding informations.
     * The encoding can be found in the InputSource or in the CSS document.
     * Since this method marks the reader and make a reset after looking for
     * the charset declaration, you'll find the charset declaration into the
     * stream.  
     */
    private CharStream getCharStreamWithLurk(InputSource source)
            throws CSSException, IOException {
        if (source.getCharacterStream() != null) {
            // all encoding are supposed to be resolved by the user
            // return the reader
            return new Generic_CharStream(source.getCharacterStream(), 1, 1);
        } else if (source.getByteStream() == null) {
            // @@CONTINUE ME. see also getReader() with systemId
            try {
                source.setByteStream(new URL(source.getURI()).openStream());
            } catch (Exception e) {
                try {
                    source.setByteStream(new FileInputStream(source.getURI()));
                } catch (IOException ex) {
                    throw new CSSException("invalid url ?");
                }
            }
        }
        //use UTF-8 as the default encoding.
        String encoding = source.getEncoding();
        InputStream input = source.getByteStream();
        if (!input.markSupported()) {
            // If mark is not supported, wrap it in a stream which supports mark
            input = new BufferedInputStream(input);
            source.setByteStream(input);
        }
        // Mark either the original stream or the wrapped stream
        input.mark(100);
        if(encoding == null){
            encoding = "ASCII";

            char c = ' ';

            c = (char) input.read();

            if (c == '@') {
                // hum, is it a charset ?
                int size   = 100;
                byte[] buf = new byte[size];
                input.read(buf, 0, 7);
                String keyword = new String(buf, 0, 7);
                if (keyword.equals("charset")) {
                    // Yes, this is the charset declaration !

                    // here I don't use the right declaration : white space are ' '.
                    while ((c = (char) input.read()) == ' ') {
                        // find the first quote
                    }
                    char endChar = c;
                    int i = 0;

                    if ((endChar != '"') && (endChar != '\u005c'')) {
                        // hum this is not a quote.
                        throw new CSSException("invalid charset declaration");
                    }

                    while ((c = (char) input.read()) != endChar) {
                        buf[i++] = (byte) c;
                        if (i == size) {
                            byte[] old = buf;
                            buf = new byte[size + 100];
                            System.arraycopy(old, 0, buf, 0, size);
                            size += 100;
                        }
                    }
                    while ((c = (char) input.read()) == ' ') {
                        // find the next relevant character
                    }
                    if (c != ';') {
                        // no semi colon at the end ?
                        throw new CSSException("invalid charset declaration: "
                                           + "missing semi colon");
                    }
                    encoding = new String(buf, 0, i);
                    if (source.getEncoding() != null) {
                        // compare the two encoding informations.
                        // For example, I don't accept to have ASCII and after UTF-8.
                        // Is it really good ? That is the question.
                        if (!encoding.equals(source.getEncoding())) {
                            throw new CSSException("invalid encoding information.");
                        }
                    }
                } // else no charset declaration available
            }
        }
        // ok set the real encoding of this source.
        source.setEncoding(encoding);
        // set the real reader of this source.
        source.setCharacterStream(new InputStreamReader(source.getByteStream(),
                                             Encoding.getJavaEncoding(encoding)));
        // reset the stream (leave the charset declaration in the stream).
        input.reset();

        return new Generic_CharStream(source.getCharacterStream(), 1, 1);
    }

    private LocatorImpl currentLocator;
    private Locator getLocator() {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this);
            return currentLocator;
        }
        return currentLocator.reInit(this);
    }
    private LocatorImpl getLocator(Token save) {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this, save);
            return currentLocator;
        }
        return currentLocator.reInit(this, save);
    }

    private void reportError(Locator l, Exception e) {
        if (errorHandler != null) {
            if (e instanceof ParseException) {
                // construct a clean error message.
                ParseException pe = (ParseException) e;
                if (pe.specialConstructor) {
                    StringBuffer errorM = new StringBuffer();
                    if (pe.currentToken != null) {
                        errorM.append("encountered \u005c"")
                            .append(pe.currentToken.next);
                    }
                    errorM.append('"');
                    if (pe.expectedTokenSequences.length != 0) {
                        errorM.append(". Was expecting one of: ");
                        for (int i = 0; i < pe.expectedTokenSequences.length; i++) {
                            for (int j = 0; j < pe.expectedTokenSequences[i].length; j++) {
                                int kind = pe.expectedTokenSequences[i][j];
                                if (kind != S) {
                                    errorM.append(pe.tokenImage[kind]);
                                    errorM.append(' ');
                                }
                            }
                        }
                    }
                    errorHandler.error(new CSSParseException(errorM.toString(),
                                                             l, e));
                } else {
                    errorHandler.error(new CSSParseException(e.getMessage(),
                                                             l, e));
                }
            } else if (e == null) {
                errorHandler.error(new CSSParseException("error", l, null));
            } else {
                errorHandler.error(new CSSParseException(e.getMessage(), l, e));
            }
        }
    }

    private void reportWarningSkipText(Locator l, String text) {
        if (errorHandler != null && text  != null) {
            errorHandler.warning(new CSSParseException("Skipping: " + text, l));
        }
    }

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {
    try {
          documentHandler.startDocument(source);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CHARSET_SYM:
        charset();
        break;
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          comments();
          break;
        case CDO:
        case CDC:
        case ATKEYWORD:
          ignoreStatement();
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IMPORT_SYM:
          ;
          break;
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        importDeclaration();
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case CDO:
          case CDC:
          case ATKEYWORD:
            ;
            break;
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
          ignoreStatement();
          label_4:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[5] = jj_gen;
              break label_4;
            }
            jj_consume_token(S);
          }
        }
      }
      afterImportDeclaration();
      jj_consume_token(0);
    } finally {
        documentHandler.endDocument(source);
    }
  }

  final public void charset() throws ParseException {
  Token n;
    try {
      jj_consume_token(CHARSET_SYM);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_6;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[8] = jj_gen;
        acceptMissingSemicolon(EOF);
      }
    } catch (ParseException e) {
        reportError(getLocator(e.currentToken.next), e);
    skipStatement();
    // reportWarningSkipText(getLocator(), skipStatement());

    } catch (Exception e) {
        reportError(getLocator(), e);
    skipStatement();
    // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

  final public void afterImportDeclaration() throws ParseException {
 String ret;
 Locator l;
    label_7:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEBUG_SYM:
      case WARN_SYM:
        debuggingDirective();
        break;
      case MIXIN_SYM:
        mixinDirective();
        break;
      case FUNCTION_SYM:
        functionDirective();
        break;
      case EACH_SYM:
      case IF_SYM:
        controlDirective();
        break;
      case INCLUDE_SYM:
        includeDirective();
        break;
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case IDENT:
      case HASH:
        styleRule();
        break;
      case MEDIA_SYM:
        media();
        break;
      case PAGE_SYM:
        page();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      case KEY_FRAME_SYM:
        keyframes();
        break;
      case VARIABLE:
        variable();
        break;
      default:
        jj_la1[9] = jj_gen;
          l = getLocator();
        ret = skipStatement();
          if ((ret == null) || (ret.length() == 0)) {
              {if (true) return;}
          }
          if (ret.charAt(0) == '@') {
              documentHandler.unrecognizedRule(ret);
          } else {
              reportWarningSkipText(l, ret);
          }
      }
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CDO:
        case CDC:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_8;
        }
        ignoreStatement();
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[11] = jj_gen;
            break label_9;
          }
          jj_consume_token(S);
        }
      }
    }
  }

  final public void ignoreStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CDO:
      jj_consume_token(CDO);
      break;
    case CDC:
      jj_consume_token(CDC);
      break;
    case ATKEYWORD:
      atRuleDeclaration();
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {
 Token n;
 String uri;
 MediaListImpl ml = new MediaListImpl();
 boolean isURL = false;
    try {
      jj_consume_token(IMPORT_SYM);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        n = jj_consume_token(STRING);
                               uri = convertStringIndex(n.image, 1,
                                                        n.image.length() -1);
        break;
      case URL:
        n = jj_consume_token(URL);
               isURL=true;
               uri = n.image.substring(4, n.image.length()-1).trim();
               if ((uri.charAt(0) == '"')
                   || (uri.charAt(0) == '\u005c'')) {
                   uri = uri.substring(1, uri.length()-1);
               }
        break;
      default:
        jj_la1[14] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_11;
        }
        jj_consume_token(S);
      }
      mediaStatement(ml);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[16] = jj_gen;
        acceptMissingSemicolon(RBRACE, EOF);
      }
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_12;
        }
        jj_consume_token(S);
      }
               if (ml.getLength() == 0) {
                   // see section 6.3 of the CSS2 recommandation.
                   ml.addItem("all");
               }
               documentHandler.importStyle(uri, ml, isURL);
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void keyframes() throws ParseException {
    Token n;
    boolean start = false;
    String keyframeName = null;
    String animationname = "";
    try {
      n = jj_consume_token(KEY_FRAME_SYM);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_13;
        }
        jj_consume_token(S);
      }
                              keyframeName = n.image;
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          n = jj_consume_token(IDENT);
               animationname += n.image;
          break;
        case INTERPOLATION:
          n = jj_consume_token(INTERPOLATION);
                                                                  animationname += n.image;
          break;
        default:
          jj_la1[19] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERPOLATION:
        case IDENT:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_14;
        }
      }
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
    start = true; documentHandler.startKeyFrames(keyframeName, animationname);
      jj_consume_token(LBRACE);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO:
        case FROM:
        case CONTENT_SYM:
        case PERCENTAGE:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TO:
        case FROM:
        case PERCENTAGE:
          keyframeSelector();
          break;
        case CONTENT_SYM:
          contentDirective();
          break;
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
    } finally {
     if (start) {
         documentHandler.endKeyFrames();
     }
    }
  }

  final public void keyframeSelector() throws ParseException {
    Token n;
    String selector = "";
    boolean start = false;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case FROM:
        n = jj_consume_token(FROM);
        break;
      case TO:
        n = jj_consume_token(TO);
        break;
      case PERCENTAGE:
        n = jj_consume_token(PERCENTAGE);
        break;
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                                   selector += n.image;
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        label_21:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[29] = jj_gen;
            break label_21;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FROM:
          n = jj_consume_token(FROM);
          break;
        case TO:
          n = jj_consume_token(TO);
          break;
        case PERCENTAGE:
          n = jj_consume_token(PERCENTAGE);
          break;
        default:
          jj_la1[30] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                                                    selector += (", " + n.image);
        label_22:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[31] = jj_gen;
            break label_22;
          }
          jj_consume_token(S);
        }
      }
      jj_consume_token(LBRACE);
      label_23:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_23;
        }
        jj_consume_token(S);
      }
          start = true;
          documentHandler.startKeyframeSelector(selector);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case PARENT:
        case DOT:
        case COLON:
        case INTERPOLATION:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case EACH_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case MICROSOFT_RULE:
        case IDENT:
        case VARIABLE:
        case HASH:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_24;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case PARENT:
        case DOT:
        case COLON:
        case INTERPOLATION:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case EACH_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case IDENT:
        case VARIABLE:
        case HASH:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ifContentStatement();
          break;
        case MICROSOFT_RULE:
          microsoftExtension();
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
    } catch (ThrowedParseException e) {
        if (errorHandler != null) {
            LocatorImpl li = new LocatorImpl(this,
                                             e.e.currentToken.next.beginLine,
                                             e.e.currentToken.next.beginColumn-1);
            reportError(li, e.e);
        }
    } catch (ParseException e) {
        reportError(getLocator(), e);
        skipStatement();
        // reportWarningSkipText(getLocator(), skipStatement());

    } catch (TokenMgrError e) {
        reportWarningSkipText(getLocator(), skipStatement());
    } finally {
        if (start) {
            documentHandler.endKeyframeSelector();
        }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
/* see http://www.w3.org/TR/css3-mediaqueries/ */
  final public void media() throws ParseException {
    boolean start = false;
    String ret;
    MediaListImpl ml = new MediaListImpl();
    try {
      jj_consume_token(MEDIA_SYM);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_26;
        }
        jj_consume_token(S);
      }
      mediaStatement(ml);
     start = true; documentHandler.startMedia(ml);
      jj_consume_token(LBRACE);
      label_27:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[37] = jj_gen;
          break label_27;
        }
        jj_consume_token(S);
      }
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CDO:
        case LBRACE:
        case DASHMATCH:
        case INCLUDES:
        case PLUS:
        case MINUS:
        case COMMA:
        case SEMICOLON:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case PARENT:
        case DOT:
        case COLON:
        case INTERPOLATION:
        case NONASCII:
        case DEBUG_SYM:
        case WARN_SYM:
        case CONTENT_SYM:
        case STRING:
        case IDENT:
        case NUMBER:
        case URL:
        case PERCENTAGE:
        case HASH:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case CHARSET_SYM:
        case PAGE_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:
        case IMPORTANT_SYM:
        case UNICODERANGE:
        case FUNCTION:
        case UNKNOWN:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_28;
        }
        mediaDirective();
      }
      jj_consume_token(RBRACE);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
     if (start) {
     documentHandler.endMedia(ml);
     }
    }
  }

  final public void mediaDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEBUG_SYM:
    case WARN_SYM:
      debuggingDirective();
      break;
    case PLUS:
    case PRECEDES:
    case SIBLING:
    case LBRACKET:
    case ANY:
    case PARENT:
    case DOT:
    case COLON:
    case INTERPOLATION:
    case IDENT:
    case HASH:
      styleRule();
      break;
    case CDO:
    case LBRACE:
    case DASHMATCH:
    case INCLUDES:
    case MINUS:
    case COMMA:
    case SEMICOLON:
    case NONASCII:
    case STRING:
    case NUMBER:
    case URL:
    case PERCENTAGE:
    case IMPORT_SYM:
    case MEDIA_SYM:
    case CHARSET_SYM:
    case PAGE_SYM:
    case FONT_FACE_SYM:
    case ATKEYWORD:
    case IMPORTANT_SYM:
    case UNICODERANGE:
    case FUNCTION:
    case UNKNOWN:
      skipUnknownRule();
      break;
    case CONTENT_SYM:
      contentDirective();
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void mediaStatement(MediaListImpl ml) throws ParseException {
  Token t;
      t = getToken(1);
      // loop over comma separated parts, add each to ml
      while ((t.kind != LBRACE) && (t.kind != EOF) && (t.kind != SEMICOLON)) {
        StringBuffer s = new StringBuffer();
        s.append(getToken(0).image);
        while ((t.kind != COMMA) && (t.kind != LBRACE) && (t.kind != EOF) && (t.kind != SEMICOLON)) {
              s.append(t.image);
              getNextToken();
          t = getToken(1);
        }
        if (t.kind == COMMA) {
          // skip the comma and the token before it that is still the active token
          getNextToken();
          getNextToken();
          t = getToken(1);
        }
        String str = s.toString().trim();
        if (str.length() > 0) {
          ml.addItem(str);
        }
      }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String medium() throws ParseException {
 Token n;
    n = jj_consume_token(IDENT);
                {if (true) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void page() throws ParseException {
 boolean start = false;
 Token n = null;
 String page = null;
 String pseudo = null;
    try {
      jj_consume_token(PAGE_SYM);
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_30;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        n = jj_consume_token(IDENT);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[42] = jj_gen;
            break label_31;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[43] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        pseudo = pseudo_page();
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
          if (n != null) {
              page = convertIdent(n.image);
          }
      jj_consume_token(LBRACE);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[45] = jj_gen;
          break label_32;
        }
        jj_consume_token(S);
      }
          start = true;
          documentHandler.startPage(page, pseudo);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_33;
        }
        jj_consume_token(SEMICOLON);
        label_34:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[48] = jj_gen;
            break label_34;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERPOLATION:
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[49] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[50] = jj_gen;
          break label_35;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.currentToken.next.beginLine,
                                          e.currentToken.next.beginColumn-1);
         reportError(li, e);
         skipStatement();
         // reportWarningSkipText(li, skipStatement());
     } else {
         skipStatement();
     }
    } finally {
     if (start) {
         documentHandler.endPage(page, pseudo);
     }
    }
  }

  final public String pseudo_page() throws ParseException {
  Token n;
    jj_consume_token(COLON);
    n = jj_consume_token(IDENT);
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_36;
      }
      jj_consume_token(S);
    }
                             {if (true) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public void fontFace() throws ParseException {
    boolean start = false;
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_37;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_38:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[53] = jj_gen;
          break label_38;
        }
        jj_consume_token(S);
      }
        start = true; documentHandler.startFontFace();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[54] = jj_gen;
        ;
      }
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_39;
        }
        jj_consume_token(SEMICOLON);
        label_40:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[56] = jj_gen;
            break label_40;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERPOLATION:
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[57] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[58] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
     if (start) {
         documentHandler.endFontFace();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {
 Token n;
 String ret;
    n = jj_consume_token(ATKEYWORD);
        ret=skipStatement();
        if ((ret != null) && (ret.charAt(0) == '@')) {
            documentHandler.unrecognizedRule(ret);
        } else {
            reportWarningSkipText(getLocator(), ret);
        }
  }

  final public void skipUnknownRule() throws ParseException {
  Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATKEYWORD:
      n = jj_consume_token(ATKEYWORD);
      break;
    case CDO:
      n = jj_consume_token(CDO);
      break;
    case CHARSET_SYM:
      n = jj_consume_token(CHARSET_SYM);
      break;
    case COMMA:
      n = jj_consume_token(COMMA);
      break;
    case DASHMATCH:
      n = jj_consume_token(DASHMATCH);
      break;
    case FONT_FACE_SYM:
      n = jj_consume_token(FONT_FACE_SYM);
      break;
    case FUNCTION:
      n = jj_consume_token(FUNCTION);
      break;
    case IMPORTANT_SYM:
      n = jj_consume_token(IMPORTANT_SYM);
      break;
    case IMPORT_SYM:
      n = jj_consume_token(IMPORT_SYM);
      break;
    case INCLUDES:
      n = jj_consume_token(INCLUDES);
      break;
    case LBRACE:
      n = jj_consume_token(LBRACE);
      break;
    case MEDIA_SYM:
      n = jj_consume_token(MEDIA_SYM);
      break;
    case NONASCII:
      n = jj_consume_token(NONASCII);
      break;
    case NUMBER:
      n = jj_consume_token(NUMBER);
      break;
    case PAGE_SYM:
      n = jj_consume_token(PAGE_SYM);
      break;
    case PERCENTAGE:
      n = jj_consume_token(PERCENTAGE);
      break;
    case STRING:
      n = jj_consume_token(STRING);
      break;
    case UNICODERANGE:
      n = jj_consume_token(UNICODERANGE);
      break;
    case URL:
      n = jj_consume_token(URL);
      break;
    case SEMICOLON:
      n = jj_consume_token(SEMICOLON);
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      break;
    case UNKNOWN:
      n = jj_consume_token(UNKNOWN);
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     String ret;
     Locator loc = getLocator();
     ret=skipStatement();
     if ((ret != null) && (n.image.charAt(0) == '@')) {
         documentHandler.unrecognizedRule(ret);
     } else {
     reportWarningSkipText(loc, ret);
     }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char combinator() throws ParseException {
char connector = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case PRECEDES:
    case SIBLING:
      connector = combinatorChar();
      break;
    case S:
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
        connector = combinatorChar();
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                               {if (true) return connector;}
    throw new Error("Missing return statement in function");
  }

/**to refactor combinator and reuse in selector().*/
  final public char combinatorChar() throws ParseException {
 Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      t = jj_consume_token(PLUS);
      break;
    case PRECEDES:
      t = jj_consume_token(PRECEDES);
      break;
    case SIBLING:
      t = jj_consume_token(SIBLING);
      break;
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[63] = jj_gen;
        break label_42;
      }
      jj_consume_token(S);
    }
        {if (true) return t.image.charAt(0);}
    throw new Error("Missing return statement in function");
  }

  final public void microsoftExtension() throws ParseException {
  Token n;
  String name = "";
  String value = "";
    // This is not really taking the syntax of filter rules into account
      n = jj_consume_token(MICROSOFT_RULE);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_43;
      }
      jj_consume_token(S);
    }
                                    name = n.image;
    jj_consume_token(COLON);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        n = jj_consume_token(IDENT);
                          value += n.image;
        break;
      case NUMBER:
        n = jj_consume_token(NUMBER);
                            value += n.image;
        break;
      case STRING:
        n = jj_consume_token(STRING);
                            value += n.image;
        break;
      case COMMA:
        n = jj_consume_token(COMMA);
                           value += n.image;
        break;
      case INTERPOLATION:
        n = jj_consume_token(INTERPOLATION);
                                   value += n.image;
        break;
      case COLON:
        n = jj_consume_token(COLON);
                           value += n.image;
        break;
      case FUNCTION:
        n = jj_consume_token(FUNCTION);
                              value += n.image;
        break;
      case RPARAN:
        n = jj_consume_token(RPARAN);
                            value += n.image;
        break;
      case EQ:
        n = jj_consume_token(EQ);
                        value += n.image;
        break;
      case DOT:
        n = jj_consume_token(DOT);
                         value += n.image;
        break;
      case S:
        n = jj_consume_token(S);
                       if(value.lastIndexOf(' ') != value.length()-1)
        { value += n.image; }
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case EQ:
      case COMMA:
      case DOT:
      case RPARAN:
      case COLON:
      case INTERPOLATION:
      case STRING:
      case IDENT:
      case NUMBER:
      case FUNCTION:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_44;
      }
    }
    jj_consume_token(SEMICOLON);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[67] = jj_gen;
        break label_45;
      }
      jj_consume_token(S);
    }
          documentHandler.microsoftDirective(name, value);
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String property() throws ParseException {
 Token t;String s = "";
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
                 s += t.image;
        break;
      case INTERPOLATION:
        t = jj_consume_token(INTERPOLATION);
                                                        s += t.image;
        break;
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_46;
      }
    }
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_47;
      }
      jj_consume_token(S);
    }
        {if (true) return s;}
    throw new Error("Missing return statement in function");
  }

  final public String variableName() throws ParseException {
 Token n;
    n = jj_consume_token(VARIABLE);
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[71] = jj_gen;
        break label_48;
      }
      jj_consume_token(S);
    }
                         {if (true) return convertIdent(n.image.substring(1));}
    throw new Error("Missing return statement in function");
  }

  final public String functionName() throws ParseException {
 Token n;
    n = jj_consume_token(FUNCTION);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_49;
      }
      jj_consume_token(S);
    }
                           {if (true) return convertIdent(n.image.substring(0, n.image.length()-1));}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void styleRule() throws ParseException {
    boolean start = false;
    ArrayList<String> l = null;
    Token save;
    Locator loc;
    try {
      l = selectorList();
                        save = token;
      jj_consume_token(LBRACE);
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[73] = jj_gen;
          break label_50;
        }
        jj_consume_token(S);
      }
         start = true;
         documentHandler.startSelector(l);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case PARENT:
        case DOT:
        case COLON:
        case INTERPOLATION:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case EACH_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case MICROSOFT_RULE:
        case IDENT:
        case VARIABLE:
        case HASH:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ;
          break;
        default:
          jj_la1[74] = jj_gen;
          break label_51;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case PRECEDES:
        case SIBLING:
        case LBRACKET:
        case ANY:
        case PARENT:
        case DOT:
        case COLON:
        case INTERPOLATION:
        case INCLUDE_SYM:
        case DEBUG_SYM:
        case WARN_SYM:
        case EACH_SYM:
        case IF_SYM:
        case EXTEND_SYM:
        case CONTENT_SYM:
        case IDENT:
        case VARIABLE:
        case HASH:
        case MEDIA_SYM:
        case KEY_FRAME_SYM:
        case ATKEYWORD:
          ifContentStatement();
          break;
        case MICROSOFT_RULE:
          microsoftExtension();
          break;
        case IMPORT_SYM:
          importDeclaration();
          break;
        default:
          jj_la1[75] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_52;
        }
        jj_consume_token(S);
      }
    } catch (ThrowedParseException e) {
     if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.e.currentToken.next.beginLine,
                                          e.e.currentToken.next.beginColumn-1);
         reportError(li, e.e);
     }
    } catch (ParseException e) {
     reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } catch (TokenMgrError e) {
     reportWarningSkipText(getLocator(), skipStatement());
    } finally {
     if (start) {
         documentHandler.endSelector();
     }
    }
  }

  final public ArrayList<String> selectorList() throws ParseException {
     ArrayList<String> selectors = new  ArrayList<String>();
     String selector;
    selector = selector();
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[77] = jj_gen;
        break label_53;
      }
      jj_consume_token(COMMA);
      label_54:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[78] = jj_gen;
          break label_54;
        }
        jj_consume_token(S);
      }
                                        selectors.add(selector);
      selector = selector();
    }
    selectors.add(selector);
    {if (true) return selectors;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String selector() throws ParseException {
    String selector = null;
    char    comb;
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case IDENT:
      case HASH:
        selector = simple_selector(null, ' ');
        break;
      case PLUS:
      case PRECEDES:
      case SIBLING:
        comb = combinatorChar();
        selector = simple_selector(selector, comb);
        break;
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_55:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_55;
        }
        comb = combinator();
        selector = simple_selector(selector, comb);
      }
      label_56:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_56;
        }
        jj_consume_token(S);
      }
       {if (true) return selector;}
    } catch (ParseException e) {
     /*
     Token t = getToken(1);
     StringBuffer s = new StringBuffer();
     s.append(getToken(0).image);
     while ((t.kind != COMMA) && (t.kind != SEMICOLON) 
	    && (t.kind != LBRACE) && (t.kind != EOF)) {
	 s.append(t.image);
	 getNextToken();
	 t = getToken(1);
     }
     reportWarningSkipText(getLocator(), s.toString());
     */
     Token t = getToken(1);
     while ((t.kind != COMMA) && (t.kind != SEMICOLON)
            && (t.kind != LBRACE) && (t.kind != EOF)) {
         getNextToken();
         t = getToken(1);
     }

     {if (true) throw new ThrowedParseException(e);}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String simple_selector(String selector, char comb) throws ParseException {
    String simple_current = null;
    String cond = null;

    pseudoElt = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ANY:
    case PARENT:
    case INTERPOLATION:
    case IDENT:
      simple_current = element_name();
      label_57:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
        case DOT:
        case COLON:
        case HASH:
          ;
          break;
        default:
          jj_la1[81] = jj_gen;
          break label_57;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HASH:
          cond = hash(cond);
          break;
        case DOT:
          cond = _class(cond);
          break;
        case LBRACKET:
          cond = attrib(cond);
          break;
        case COLON:
          cond = pseudo(cond);
          break;
        default:
          jj_la1[82] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case LBRACKET:
    case DOT:
    case COLON:
    case HASH:
      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HASH:
          cond = hash(cond);
          break;
        case DOT:
          cond = _class(cond);
          break;
        case LBRACKET:
          cond = attrib(cond);
          break;
        case COLON:
          cond = pseudo(cond);
          break;
        default:
          jj_la1[83] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACKET:
        case DOT:
        case COLON:
        case HASH:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_58;
        }
      }
      break;
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
            if (simple_current == null) {
                simple_current = "";
            }
            if (cond != null) {
                simple_current = simple_current + cond;
            }
            StringBuilder builder = new StringBuilder();
            switch (comb) {
                case ' ':
                    if(selector!=null){
                        builder.append(selector).append(" ");
                    }
                    break;
                case '+':
                case '>':
                case '~':
                    if(selector!=null){
                        builder.append(selector).append(" ");
                    }
                    builder.append(comb).append(" ");
                    break;
                default:
                    {if (true) throw new ParseException("invalid state. send a bug report");}
            }
            builder.append(simple_current);
            selector = builder.toString();

            if (pseudoElt != null) {
                selector = selector + pseudoElt;
            }
            {if (true) return selector;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String _class(String pred) throws ParseException {
 Token t;
String s = ".";
    jj_consume_token(DOT);
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
                   s += t.image;
        break;
      case INTERPOLATION:
        t = jj_consume_token(INTERPOLATION);
                                                           s += t.image;
        break;
      default:
        jj_la1[86] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_59;
      }
    }
          if (pred == null) {
              {if (true) return s;}
          } else {
              {if (true) return pred + s;}
          }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String element_name() throws ParseException {
 Token t; String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERPOLATION:
    case IDENT:
      label_60:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          t = jj_consume_token(IDENT);
                 s += t.image;
          break;
        case INTERPOLATION:
          t = jj_consume_token(INTERPOLATION);
                                                        s += t.image;
          break;
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERPOLATION:
        case IDENT:
          ;
          break;
        default:
          jj_la1[89] = jj_gen;
          break label_60;
        }
      }
      {if (true) return s;}
      break;
    case ANY:
      jj_consume_token(ANY);
      {if (true) return "*";}
      break;
    case PARENT:
      jj_consume_token(PARENT);
      {if (true) return "&";}
      break;
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String attrib(String pred) throws ParseException {
    int cases = 0;
    Token att = null;
    Token val = null;
    String attValue = null;
    jj_consume_token(LBRACKET);
    label_61:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[91] = jj_gen;
        break label_61;
      }
      jj_consume_token(S);
    }
    att = jj_consume_token(IDENT);
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_62;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DASHMATCH:
    case CARETMATCH:
    case DOLLARMATCH:
    case STARMATCH:
    case INCLUDES:
    case EQ:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        jj_consume_token(EQ);
                          cases = 1;
        break;
      case INCLUDES:
        jj_consume_token(INCLUDES);
                          cases = 2;
        break;
      case DASHMATCH:
        jj_consume_token(DASHMATCH);
                          cases = 3;
        break;
      case CARETMATCH:
        jj_consume_token(CARETMATCH);
                           cases = 4;
        break;
      case DOLLARMATCH:
        jj_consume_token(DOLLARMATCH);
                            cases = 5;
        break;
      case STARMATCH:
        jj_consume_token(STARMATCH);
                          cases = 6;
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[94] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        val = jj_consume_token(IDENT);
                        attValue = val.image;
        break;
      case STRING:
        val = jj_consume_token(STRING);
                           attValue = val.image;
        break;
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_64:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[96] = jj_gen;
          break label_64;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[97] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
      String name = convertIdent(att.image);
      String c;
      switch (cases) {
          case 0:
          c = name;
          break;
          case 1:
          c = name + "=" + attValue;
          break;
          case 2:
          c = name + "~=" + attValue;
          break;
          case 3:
          c = name + "|=" +attValue;
          break;
          case 4:
          c = name + "^=" +attValue;
          break;
          case 5:
          c = name + "$=" +attValue;
          break;
          case 6:
          c = name + "*=" +attValue;
          break;
          default:
          // never reached.
          c = null;
      }
      c = "[" + c + "]";
      if (pred == null) {
          {if (true) return c;}
      } else {
          {if (true) return pred + c;}
      }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String pseudo(String pred) throws ParseException {
 Token n;
Token param;
String d;
boolean isPseudoElement = false;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
             isPseudoElement=true;
      break;
    default:
      jj_la1[98] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      n = jj_consume_token(IDENT);
            String s = ":" + convertIdent(n.image);
            if (isPseudoElement) {
                if (pseudoElt != null) {
                    {if (true) throw new CSSParseException("duplicate pseudo element definition "
                                                + s, getLocator());}
                } else {
                    pseudoElt = ":"+s;
                    {if (true) return pred;}
                }
            } else {
                String c = s;
                if (pred == null) {
                    {if (true) return c;}
                } else {
                    {if (true) return pred + c;}
                }
            }
      break;
    case FUNCTION:
      n = jj_consume_token(FUNCTION);
      label_65:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[99] = jj_gen;
          break label_65;
        }
        jj_consume_token(S);
      }
      d = skipStatementUntilMatchingRightParan();
      jj_consume_token(RPARAN);
                  // accept anything between function and a right parenthesis
                  String f = convertIdent(n.image);
                  String colons = isPseudoElement ? "::" : ":";
                  String pseudofn = colons + f + d + ")";
                      if (pred == null) {
                          {if (true) return pseudofn;}
                      } else {
                          {if (true) return pred + pseudofn;}
                  }
      break;
    default:
      jj_la1[100] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String hash(String pred) throws ParseException {
 Token n;
    n = jj_consume_token(HASH);
      String d = n.image;
      if (pred == null) {
          {if (true) return d;}
      } else {
          {if (true) return pred + d;}
      }
    throw new Error("Missing return statement in function");
  }

  final public void variable() throws ParseException {
    String name;
    SassList l = null;
    boolean guarded = false;
    String raw;
    try {
      name = variableName();
      jj_consume_token(COLON);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[101] = jj_gen;
          break label_66;
        }
        jj_consume_token(S);
      }
      l = expressionList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GUARDED_SYM:
        guarded = guarded();
        break;
      default:
        jj_la1[102] = jj_gen;
        ;
      }
      semicolonTerminator();
            documentHandler.variable(name, l.flatten(), guarded);
    } catch (JumpException e) {
        skipAfterExpression();
    } catch (NumberFormatException e) {
        if (errorHandler != null) {
            errorHandler.error(new CSSParseException("Invalid number "
                               + e.getMessage(), getLocator(), e));
        }
        reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
        if (errorHandler != null) {
            if (e.currentToken != null) {
                LocatorImpl li = new LocatorImpl(this,
                              e.currentToken.next.beginLine,
                              e.currentToken.next.beginColumn-1);
                reportError(li, e);
            } else {
                reportError(getLocator(), e);
            }
            skipAfterExpression();
        } else {
        skipAfterExpression();
        }
    }
  }

  final public SassList expressionList() throws ParseException {
    // Empty lists and parenthesized lists are not supported yet.
    List<SassListItem> primaryList = new ArrayList<SassListItem>();
    int line = token.beginLine;
    int column = token.beginColumn;
    SassList subList;
    subList = expressionSubList();
                                   primaryList.add(subList);
    label_67:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[103] = jj_gen;
        break label_67;
      }
      jj_consume_token(COMMA);
      label_68:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[104] = jj_gen;
          break label_68;
        }
        jj_consume_token(S);
      }
      subList = expressionSubList();
                                                    primaryList.add(subList);
    }
        SassList result = new SassList(SassList.Separator.COMMA, primaryList);
        result.setSourcePosition(line, column);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public SassList expressionSubList() throws ParseException {
    // Empty lists and parenthesized lists are not supported yet.
    LexicalUnitImpl unit;
    List<SassListItem> list = new ArrayList<SassListItem>();
    int line = token.beginLine;
    int column = token.beginColumn;
    label_69:
    while (true) {
      unit = variableListItem();
                                             list.add(unit);
      if (jj_2_2(2)) {
        ;
      } else {
        break label_69;
      }
    }
        SassList result = new SassList(SassList.Separator.SPACE, list);
        result.setSourcePosition(line, column);
        {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl variableListItem() throws ParseException {
    LexicalUnitImpl first, res;
    first = term(null);
                        res = first;
    label_70:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_70;
      }
      res = nonCommaOperator(res);
      res = term(res);
    }
      {if (true) return first;}
    throw new Error("Missing return statement in function");
  }

  final public void controlDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF_SYM:
      ifDirective();
      break;
    case EACH_SYM:
      eachDirective();
      break;
    default:
      jj_la1[105] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ifContentStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONTENT_SYM:
      contentDirective();
      break;
    case INCLUDE_SYM:
      includeDirective();
      break;
    case MEDIA_SYM:
      media();
      break;
    case EXTEND_SYM:
      extendDirective();
      break;
    case PLUS:
    case PRECEDES:
    case SIBLING:
    case LBRACKET:
    case ANY:
    case PARENT:
    case DOT:
    case COLON:
    case INTERPOLATION:
    case DEBUG_SYM:
    case WARN_SYM:
    case IDENT:
    case HASH:
      styleRuleOrDeclarationOrNestedProperties();
      break;
    case KEY_FRAME_SYM:
      keyframes();
      break;
    case VARIABLE:
      variable();
      break;
    case EACH_SYM:
    case IF_SYM:
      controlDirective();
      break;
    case ATKEYWORD:
      atRuleDeclaration();
      break;
    default:
      jj_la1[106] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ifDirective() throws ParseException {
  Token n = null;
  String s = null;
  String evaluator = "";
    jj_consume_token(IF_SYM);
    label_71:
    while (true) {
      s = booleanExpressionToken();
                                   evaluator += s;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case EQ:
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SUCCEEDS:
      case DIV:
      case ANY:
      case LPARAN:
      case RPARAN:
      case COMPARE:
      case OR:
      case AND:
      case NOT_EQ:
      case IDENT:
      case NUMBER:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_71;
      }
    }
    jj_consume_token(LBRACE);
    label_72:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_72;
      }
      jj_consume_token(S);
    }
    documentHandler.startIfElseDirective();
    documentHandler.ifDirective(evaluator);
    label_73:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[109] = jj_gen;
        break label_73;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[111] = jj_gen;
        break label_74;
      }
      jj_consume_token(S);
    }
    label_75:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE_SYM:
        ;
        break;
      default:
        jj_la1[112] = jj_gen;
        break label_75;
      }
      elseDirective();
    }
    documentHandler.endIfElseDirective();
  }

  final public void elseDirective() throws ParseException {
  String evaluator = "";
  Token n = null;
  String s = null;
    jj_consume_token(ELSE_SYM);
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[113] = jj_gen;
        break label_76;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      label_77:
      while (true) {
        s = booleanExpressionToken();
                                            evaluator += s;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case EQ:
        case PLUS:
        case MINUS:
        case PRECEDES:
        case SUCCEEDS:
        case DIV:
        case ANY:
        case LPARAN:
        case RPARAN:
        case COMPARE:
        case OR:
        case AND:
        case NOT_EQ:
        case IDENT:
        case NUMBER:
        case VARIABLE:
          ;
          break;
        default:
          jj_la1[114] = jj_gen;
          break label_77;
        }
      }
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[116] = jj_gen;
        break label_78;
      }
      jj_consume_token(S);
    }
    if(!evaluator.trim().equals("")){ documentHandler.ifDirective(evaluator); }
    else{ documentHandler.elseDirective(); }
    label_79:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[117] = jj_gen;
        break label_79;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      default:
        jj_la1[118] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_80:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[119] = jj_gen;
        break label_80;
      }
      jj_consume_token(S);
    }
  }

  final public String booleanExpressionToken() throws ParseException {
  Token n = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLE:
      n = jj_consume_token(VARIABLE);
      break;
    case IDENT:
      n = jj_consume_token(IDENT);
      break;
    case NUMBER:
      n = jj_consume_token(NUMBER);
      break;
    case LPARAN:
      n = jj_consume_token(LPARAN);
      break;
    case RPARAN:
      n = jj_consume_token(RPARAN);
      break;
    case PLUS:
      n = jj_consume_token(PLUS);
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      break;
    case DIV:
      n = jj_consume_token(DIV);
      break;
    case ANY:
      n = jj_consume_token(ANY);
      break;
    case COMPARE:
      n = jj_consume_token(COMPARE);
      break;
    case EQ:
      n = jj_consume_token(EQ);
      break;
    case PRECEDES:
      n = jj_consume_token(PRECEDES);
      break;
    case SUCCEEDS:
      n = jj_consume_token(SUCCEEDS);
      break;
    case OR:
      n = jj_consume_token(OR);
      break;
    case AND:
      n = jj_consume_token(AND);
      break;
    case S:
      n = jj_consume_token(S);
      break;
    case NOT_EQ:
      n = jj_consume_token(NOT_EQ);
      break;
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
   {if (true) return n.image;}
    throw new Error("Missing return statement in function");
  }

  final public void eachDirective() throws ParseException {
    Token var;
    SassList list = null;
    String listVariable = null;
    jj_consume_token(EACH_SYM);
    label_81:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[121] = jj_gen;
        break label_81;
      }
      jj_consume_token(S);
    }
    var = jj_consume_token(VARIABLE);
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_82;
      }
      jj_consume_token(S);
    }
    jj_consume_token(EACH_IN);
    label_83:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[123] = jj_gen;
        break label_83;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      list = stringList();
         documentHandler.startEachDirective(var.image, list);
      break;
    case VARIABLE:
      listVariable = variableName();
         documentHandler.startEachDirective(var.image, listVariable);
      break;
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[125] = jj_gen;
        break label_84;
      }
      jj_consume_token(S);
    }
    label_85:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[126] = jj_gen;
        break label_85;
      }
      ifContentStatement();
    }
    jj_consume_token(RBRACE);
    label_86:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[127] = jj_gen;
        break label_86;
      }
      jj_consume_token(S);
    }
      documentHandler.endEachDirective();
  }

  final public SassList stringList() throws ParseException {
    List<SassListItem> strings = new ArrayList<SassListItem>();
    LexicalUnitImpl unit;
    Token input;
    input = jj_consume_token(IDENT);
    label_87:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[128] = jj_gen;
        break label_87;
      }
      jj_consume_token(S);
    }
      unit = LexicalUnitImpl.createIdent(input.beginLine, input.beginColumn,
                                         null, input.image); strings.add(unit);
    label_88:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[129] = jj_gen;
        break label_88;
      }
      jj_consume_token(COMMA);
      label_89:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[130] = jj_gen;
          break label_89;
        }
        jj_consume_token(S);
      }
      input = jj_consume_token(IDENT);
          unit = LexicalUnitImpl.createIdent(input.beginLine, input.beginColumn,
                                             null, input.image); strings.add(unit);
      label_90:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[131] = jj_gen;
          break label_90;
        }
        jj_consume_token(S);
      }
    }
        {if (true) return new SassList(SassList.Separator.COMMA, strings);}
    throw new Error("Missing return statement in function");
  }

  final public void mixinDirective() throws ParseException {
    String name;
    ArrayList<VariableNode> args = null;
    boolean hasVariableArgs = false;
    jj_consume_token(MIXIN_SYM);
    label_91:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[132] = jj_gen;
        break label_91;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERPOLATION:
    case IDENT:
      name = property();
      break;
    case FUNCTION:
      name = functionName();
      args = arglist();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                       hasVariableArgs = true;
        label_92:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[133] = jj_gen;
            break label_92;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      jj_consume_token(RPARAN);
      label_93:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[135] = jj_gen;
          break label_93;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[136] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_94:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[137] = jj_gen;
        break label_94;
      }
      jj_consume_token(S);
    }
     documentHandler.startMixinDirective(name, args, hasVariableArgs);
    label_95:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case PAGE_SYM:
      case FONT_FACE_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ;
        break;
      default:
        jj_la1[138] = jj_gen;
        break label_95;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case INCLUDE_SYM:
      case DEBUG_SYM:
      case WARN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case EXTEND_SYM:
      case CONTENT_SYM:
      case IDENT:
      case VARIABLE:
      case HASH:
      case MEDIA_SYM:
      case KEY_FRAME_SYM:
      case ATKEYWORD:
        ifContentStatement();
        break;
      case FONT_FACE_SYM:
        fontFace();
        break;
      case PAGE_SYM:
        page();
        break;
      default:
        jj_la1[139] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_96:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[140] = jj_gen;
        break label_96;
      }
      jj_consume_token(S);
    }
     documentHandler.endMixinDirective();
  }

  final public void functionDirective() throws ParseException {
    String name;
    ArrayList<VariableNode> args = null;
    boolean hasVariableArgs = false;
    jj_consume_token(FUNCTION_SYM);
    label_97:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[141] = jj_gen;
        break label_97;
      }
      jj_consume_token(S);
    }
    name = functionName();
    args = arglist();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELLIPSIS:
      jj_consume_token(ELLIPSIS);
                                                          hasVariableArgs = true;
      label_98:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[142] = jj_gen;
          break label_98;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[143] = jj_gen;
      ;
    }
    jj_consume_token(RPARAN);
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[144] = jj_gen;
        break label_99;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LBRACE);
    label_100:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[145] = jj_gen;
        break label_100;
      }
      jj_consume_token(S);
    }
     documentHandler.startFunctionDirective(name, args, hasVariableArgs);
    label_101:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[146] = jj_gen;
        break label_101;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_102:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[147] = jj_gen;
        break label_102;
      }
      jj_consume_token(S);
    }
     documentHandler.endFunctionDirective();
  }

  final public void functionBlockStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLE:
      variable();
      break;
    case EACH_SYM:
    case IF_SYM:
      functionControlDirective();
      break;
    case RETURN_SYM:
      returnDirective();
      break;
    default:
      jj_la1[148] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void functionControlDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF_SYM:
      functionIfDirective();
      break;
    case EACH_SYM:
      functionEachDirective();
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void functionIfDirective() throws ParseException {
  String s = null;
  String condition = "";
    jj_consume_token(IF_SYM);
    label_103:
    while (true) {
      s = booleanExpressionToken();
                                   condition += s;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case EQ:
      case PLUS:
      case MINUS:
      case PRECEDES:
      case SUCCEEDS:
      case DIV:
      case ANY:
      case LPARAN:
      case RPARAN:
      case COMPARE:
      case OR:
      case AND:
      case NOT_EQ:
      case IDENT:
      case NUMBER:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[150] = jj_gen;
        break label_103;
      }
    }
    jj_consume_token(LBRACE);
    label_104:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[151] = jj_gen;
        break label_104;
      }
      jj_consume_token(S);
    }
    documentHandler.startIfElseDirective();
    documentHandler.ifDirective(condition);
    label_105:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[152] = jj_gen;
        break label_105;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_106:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[153] = jj_gen;
        break label_106;
      }
      jj_consume_token(S);
    }
    label_107:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELSE_SYM:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_107;
      }
      functionElseDirective();
    }
    documentHandler.endIfElseDirective();
  }

  final public void functionElseDirective() throws ParseException {
  String condition = "";
  String s = null;
    jj_consume_token(ELSE_SYM);
    label_108:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[155] = jj_gen;
        break label_108;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      label_109:
      while (true) {
        s = booleanExpressionToken();
                                            condition += s;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case EQ:
        case PLUS:
        case MINUS:
        case PRECEDES:
        case SUCCEEDS:
        case DIV:
        case ANY:
        case LPARAN:
        case RPARAN:
        case COMPARE:
        case OR:
        case AND:
        case NOT_EQ:
        case IDENT:
        case NUMBER:
        case VARIABLE:
          ;
          break;
        default:
          jj_la1[156] = jj_gen;
          break label_109;
        }
      }
      break;
    default:
      jj_la1[157] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_110:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[158] = jj_gen;
        break label_110;
      }
      jj_consume_token(S);
    }
    if(!condition.trim().equals("")){ documentHandler.ifDirective(condition); }
    else{ documentHandler.elseDirective(); }
    label_111:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[159] = jj_gen;
        break label_111;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_112:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[160] = jj_gen;
        break label_112;
      }
      jj_consume_token(S);
    }
  }

  final public void functionEachDirective() throws ParseException {
    Token var;
    SassList list = null;
    String listVariable = null;
    jj_consume_token(EACH_SYM);
    label_113:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[161] = jj_gen;
        break label_113;
      }
      jj_consume_token(S);
    }
    var = jj_consume_token(VARIABLE);
    label_114:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[162] = jj_gen;
        break label_114;
      }
      jj_consume_token(S);
    }
    jj_consume_token(EACH_IN);
    label_115:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_115;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      list = stringList();
         documentHandler.startEachDirective(var.image, list);
      break;
    case VARIABLE:
      listVariable = variableName();
         documentHandler.startEachDirective(var.image, listVariable);
      break;
    default:
      jj_la1[164] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(LBRACE);
    label_116:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[165] = jj_gen;
        break label_116;
      }
      jj_consume_token(S);
    }
    label_117:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RETURN_SYM:
      case EACH_SYM:
      case IF_SYM:
      case VARIABLE:
        ;
        break;
      default:
        jj_la1[166] = jj_gen;
        break label_117;
      }
      functionBlockStatement();
    }
    jj_consume_token(RBRACE);
    label_118:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_118;
      }
      jj_consume_token(S);
    }
      documentHandler.endEachDirective();
  }

  final public ArrayList<VariableNode> arglist() throws ParseException {
    ArrayList<VariableNode> args = new ArrayList<VariableNode>();
    VariableNode arg;
    boolean hasOptionalArguments = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VARIABLE:
      arg = mixinArg();
      label_119:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[168] = jj_gen;
          break label_119;
        }
        jj_consume_token(COMMA);
        label_120:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[169] = jj_gen;
            break label_120;
          }
          jj_consume_token(S);
        }
                             hasOptionalArguments = checkMixinForOptionalArguments(arg,
                                              hasOptionalArguments); args.add(arg);
        arg = mixinArg();
      }
          hasOptionalArguments = checkMixinForOptionalArguments(arg, hasOptionalArguments); args.add(arg);
      break;
    default:
      jj_la1[170] = jj_gen;
      ;
    }
        {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

// This method is used for checking whether the argument list of a mixin is legal. No required
// arguments should come after an optional argument. An argument is optional if it has a
// default value.
  boolean checkMixinForOptionalArguments(VariableNode arg, boolean hasOptionalArguments) throws ParseException {
    // here, arg.getExpr() is always either null or a SassList
    boolean argumentHasDefaultValue = arg.getExpr() instanceof SassList && ((SassList) arg.getExpr()).size() > 0;
    if(argumentHasDefaultValue){
        return true;
    }
    else if(hasOptionalArguments){
        throw new ParseException("Sass Error: Required argument $"+ arg.getName() +" must come "
                                  +  "before any optional arguments.");
    }
    else{
        return false;
    }
  }

  final public VariableNode mixinArg() throws ParseException {
    String name;
    Token variable = null;
    List<SassListItem> l = null;
    LexicalUnitImpl unit = null;
    name = variableName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
    case VARIABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        jj_consume_token(COLON);
                                    l = new ArrayList<SassListItem>();
        label_121:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[171] = jj_gen;
            break label_121;
          }
          jj_consume_token(S);
        }
        label_122:
        while (true) {
          unit = nonVariableTerm(null);
                                      l.add(unit);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLUS:
          case MINUS:
          case DOT:
          case TO:
          case THROUGH:
          case FROM:
          case STRING:
          case IDENT:
          case NUMBER:
          case URL:
          case PERCENTAGE:
          case PT:
          case MM:
          case CM:
          case PC:
          case IN:
          case PX:
          case EMS:
          case LEM:
          case REM:
          case EXS:
          case DEG:
          case RAD:
          case GRAD:
          case MS:
          case SECOND:
          case HZ:
          case KHZ:
          case DIMEN:
          case HASH:
          case UNICODERANGE:
          case FUNCTION:
            ;
            break;
          default:
            jj_la1[172] = jj_gen;
            break label_122;
          }
        }
        break;
      case VARIABLE:
        variable = jj_consume_token(VARIABLE);
                                unit = LexicalUnitImpl.createVariable(variable.beginLine, variable.beginColumn,
                null, variable.image); l.add(unit);
        break;
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[174] = jj_gen;
      ;
    }
        SassList value = (l == null) ? null : new SassList(SassList.Separator.SPACE, l);
        VariableNode arg = new VariableNode(name, value, false);
        {if (true) return arg;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<VariableNode> argValuelist() throws ParseException {
    ArrayList<VariableNode> args = new ArrayList<VariableNode>();
    VariableNode current;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DOT:
    case TO:
    case THROUGH:
    case FROM:
    case STRING:
    case IDENT:
    case NUMBER:
    case URL:
    case VARIABLE:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case FUNCTION:
      current = argValueListItem();
                                   args.add(current);
      label_123:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[175] = jj_gen;
          break label_123;
        }
        jj_consume_token(COMMA);
        label_124:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[176] = jj_gen;
            break label_124;
          }
          jj_consume_token(S);
        }
        current = argValueListItem();
                                                     args.add(current);
      }
      break;
    default:
      jj_la1[177] = jj_gen;
      ;
    }
     {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public VariableNode argValueListItem() throws ParseException {
    LexicalUnitImpl unit;
    String name = null;
    List<SassListItem> value = new ArrayList<SassListItem>();
    if (jj_2_4(3)) {
      name = variableName();
      jj_consume_token(COLON);
      label_125:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[178] = jj_gen;
          break label_125;
        }
        jj_consume_token(S);
      }
      label_126:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
        case DOT:
        case TO:
        case THROUGH:
        case FROM:
        case STRING:
        case IDENT:
        case NUMBER:
        case URL:
        case VARIABLE:
        case PERCENTAGE:
        case PT:
        case MM:
        case CM:
        case PC:
        case IN:
        case PX:
        case EMS:
        case LEM:
        case REM:
        case EXS:
        case DEG:
        case RAD:
        case GRAD:
        case MS:
        case SECOND:
        case HZ:
        case KHZ:
        case DIMEN:
        case HASH:
        case UNICODERANGE:
        case FUNCTION:
          ;
          break;
        default:
          jj_la1[179] = jj_gen;
          break label_126;
        }
        unit = term(null);
                                                                 value.add(unit);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case DOT:
      case TO:
      case THROUGH:
      case FROM:
      case STRING:
      case IDENT:
      case NUMBER:
      case URL:
      case VARIABLE:
      case PERCENTAGE:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case LEM:
      case REM:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case FUNCTION:
        label_127:
        while (true) {
          unit = term(null);
                          value.add(unit);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLUS:
          case MINUS:
          case DOT:
          case TO:
          case THROUGH:
          case FROM:
          case STRING:
          case IDENT:
          case NUMBER:
          case URL:
          case VARIABLE:
          case PERCENTAGE:
          case PT:
          case MM:
          case CM:
          case PC:
          case IN:
          case PX:
          case EMS:
          case LEM:
          case REM:
          case EXS:
          case DEG:
          case RAD:
          case GRAD:
          case MS:
          case SECOND:
          case HZ:
          case KHZ:
          case DIMEN:
          case HASH:
          case UNICODERANGE:
          case FUNCTION:
            ;
            break;
          default:
            jj_la1[180] = jj_gen;
            break label_127;
          }
        }
        break;
      default:
        jj_la1[181] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        SassListItem flattenedValue = new SassList(SassList.Separator.SPACE, value).flatten();
        VariableNode var = new VariableNode(name, flattenedValue, false);
        {if (true) return var;}
    throw new Error("Missing return statement in function");
  }

  final public void returnDirective() throws ParseException {
    SassList expr;
    jj_consume_token(RETURN_SYM);
    label_128:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[182] = jj_gen;
        break label_128;
      }
      jj_consume_token(S);
    }
    expr = expressionList();
    semicolonTerminator();
      documentHandler.returnDirective(expr.flatten());
  }

  final public void includeDirective() throws ParseException {
    String name;
    ArrayList<VariableNode> args=null;
    boolean hasVariableArgs = false;
    jj_consume_token(INCLUDE_SYM);
    label_129:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[183] = jj_gen;
        break label_129;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERPOLATION:
    case IDENT:
      name = property();
      break;
    case VARIABLE:
      name = variableName();
                                                name = "$"+name;
      break;
    case FUNCTION:
      name = functionName();
      args = argValuelist();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                                                                   hasVariableArgs = true;
        label_130:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[184] = jj_gen;
            break label_130;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[185] = jj_gen;
        ;
      }
      jj_consume_token(RPARAN);
      label_131:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[186] = jj_gen;
          break label_131;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[187] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     documentHandler.startInclude(name, args, hasVariableArgs);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      includeDirectiveBlockContents();
      break;
    default:
      jj_la1[188] = jj_gen;
      semicolonTerminator();
    }
     documentHandler.endInclude();
  }

  final public void semicolonTerminator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      label_132:
      while (true) {
        jj_consume_token(SEMICOLON);
        label_133:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[189] = jj_gen;
            break label_133;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[190] = jj_gen;
          break label_132;
        }
      }
      break;
    default:
      jj_la1[191] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  void acceptMissingSemicolon(Integer... acceptedTerminators) throws ParseException, ParseException {
    Token next = getToken(1);
    ArrayList<Integer> terminators = new ArrayList<Integer>(Arrays.asList(acceptedTerminators));
    if (!terminators.contains(next.kind)){
        String message = "encountered \u005c"" + next.image + "\u005c". Was expecting one of \u005c";\u005c"";
        for(int term : acceptedTerminators){
            message += ", " + tokenImage[term];
        }
        ParseException e = new ParseException(message);
        throw e;
    }
  }

  final public void includeDirectiveBlockContents() throws ParseException {
    jj_consume_token(LBRACE);
    label_134:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[192] = jj_gen;
        break label_134;
      }
      jj_consume_token(S);
    }
    label_135:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case TO:
      case FROM:
      case DEBUG_SYM:
      case WARN_SYM:
      case IDENT:
      case PERCENTAGE:
      case HASH:
        ;
        break;
      default:
        jj_la1[193] = jj_gen;
        break label_135;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case SIBLING:
      case LBRACKET:
      case ANY:
      case PARENT:
      case DOT:
      case COLON:
      case INTERPOLATION:
      case DEBUG_SYM:
      case WARN_SYM:
      case IDENT:
      case HASH:
        styleRuleOrDeclarationOrNestedProperties();
        break;
      case TO:
      case FROM:
      case PERCENTAGE:
        keyframeSelector();
        break;
      default:
        jj_la1[194] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
    label_136:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[195] = jj_gen;
        break label_136;
      }
      jj_consume_token(S);
    }
  }

  final public String interpolation() throws ParseException {
  Token n;
    n = jj_consume_token(INTERPOLATION);
    {if (true) return n.image;}
    throw new Error("Missing return statement in function");
  }

  final public void debuggingDirective() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEBUG_SYM:
      debugDirective();
      break;
    case WARN_SYM:
      warnDirective();
      break;
    default:
      jj_la1[196] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void debugDirective() throws ParseException {
    jj_consume_token(DEBUG_SYM);
    String content = skipStatementUntil(new int[] {SEMICOLON,RBRACE,EOF});
    // TODO should evaluate the content expression, call documentHandler.debugDirective() etc.
    Logger.getLogger(Parser.class.getName()).log(Level.INFO, content);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_137:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[197] = jj_gen;
          break label_137;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[198] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  final public void warnDirective() throws ParseException {
    jj_consume_token(WARN_SYM);
    String content = skipStatementUntil(new int[] {SEMICOLON,RBRACE,EOF});
    // TODO should evaluate the content expression, call documentHandler.warnDirective() etc.
    Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, content);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_138:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[199] = jj_gen;
          break label_138;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[200] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
  }

  final public Node forDirective() throws ParseException {
    String var;
    String from;
    String to;
    boolean exclusive;
    String body;
    Token tok;
    var = variableName();
        int[] toThrough = {TO, THROUGH};
        from = skipStatementUntil(toThrough);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TO:
      tok = jj_consume_token(TO);
                 exclusive = true;
      break;
    case THROUGH:
      tok = jj_consume_token(THROUGH);
                       exclusive = false;
      break;
    default:
      jj_la1[201] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    to = skipStatementUntilLeftBrace();
    label_139:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[202] = jj_gen;
        break label_139;
      }
      jj_consume_token(S);
    }
    body = skipStatement();
     {if (true) return documentHandler.forDirective(var, from, to, exclusive, body);}
    throw new Error("Missing return statement in function");
  }

  final public Node whileDirective() throws ParseException {
    String condition;
    String body;
    condition = skipStatementUntilLeftBrace();
    body = skipStatement();
        {if (true) return documentHandler.whileDirective(condition, body);}
    throw new Error("Missing return statement in function");
  }

  final public void extendDirective() throws ParseException {
 ArrayList<String> list;
    jj_consume_token(EXTEND_SYM);
    label_140:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[203] = jj_gen;
        break label_140;
      }
      jj_consume_token(S);
    }
    list = selectorList();
     documentHandler.extendDirective(list);
    semicolonTerminator();
  }

  final public void contentDirective() throws ParseException {
    jj_consume_token(CONTENT_SYM);
    label_141:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[204] = jj_gen;
        break label_141;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      label_142:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[205] = jj_gen;
          break label_142;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[206] = jj_gen;
      acceptMissingSemicolon(RBRACE, EOF);
    }
     documentHandler.contentDirective();
  }

  Node importDirective() throws ParseException {
    return null;
  }

  Node charsetDirective() throws ParseException {
    return null;
  }

  Node mozDocumentDirective() throws ParseException {
    return null;
  }

  Node supportsDirective() throws ParseException {
    return null;
  }

  final public void nestedProperties() throws ParseException {
 String name;
LexicalUnit exp;
    name = property();
    jj_consume_token(COLON);
    label_143:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[207] = jj_gen;
        break label_143;
      }
      jj_consume_token(S);
    }
    jj_consume_token(LBRACE);
    label_144:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[208] = jj_gen;
        break label_144;
      }
      jj_consume_token(S);
    }
      documentHandler.startNestedProperties(name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERPOLATION:
    case IDENT:
      declaration();
      break;
    default:
      jj_la1[209] = jj_gen;
      ;
    }
    label_145:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[210] = jj_gen;
        break label_145;
      }
      jj_consume_token(SEMICOLON);
      label_146:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[211] = jj_gen;
          break label_146;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[212] = jj_gen;
        ;
      }
    }
    jj_consume_token(RBRACE);
      documentHandler.endNestedProperties(name);
    label_147:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[213] = jj_gen;
        break label_147;
      }
      jj_consume_token(S);
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void styleRuleOrDeclarationOrNestedProperties() throws ParseException {
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEBUG_SYM:
      case WARN_SYM:
        debuggingDirective();
        break;
      default:
        jj_la1[214] = jj_gen;
        if (jj_2_5(2147483647)) {
          styleRule();
        } else if (jj_2_6(3)) {
          declarationOrNestedProperties();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PLUS:
          case PRECEDES:
          case SIBLING:
          case LBRACKET:
          case ANY:
          case PARENT:
          case DOT:
          case COLON:
          case INTERPOLATION:
          case IDENT:
          case HASH:
            styleRule();
            break;
          default:
            jj_la1[215] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
         LocatorImpl loc = (LocatorImpl) getLocator();
         loc.column--;
         reportWarningSkipText(loc, skipAfterExpression());
         */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void declarationOrNestedProperties() throws ParseException {
  boolean important = false;
  String name;
  SassListItem exp;
  Token save;
  String comment = null;
    try {
      name = property();
       save = token;
      jj_consume_token(COLON);
      label_148:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[216] = jj_gen;
          break label_148;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
      case DOT:
      case TO:
      case THROUGH:
      case FROM:
      case STRING:
      case IDENT:
      case NUMBER:
      case URL:
      case VARIABLE:
      case PERCENTAGE:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case LEM:
      case REM:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case FUNCTION:
        exp = expressionList();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IMPORTANT_SYM:
          important = prio();
          break;
        default:
          jj_la1[217] = jj_gen;
          ;
        }
         exp = ((SassList) exp).flatten();
         Token next = getToken(1);
         if(next.kind == SEMICOLON || next.kind == RBRACE){
             while(next.kind == SEMICOLON){
                 skipStatement();
                 next = getToken(1);
             }
             //only add special token kept for sprites '/**'
             if(token.specialToken!=null && token.specialToken!=null && token.specialToken.image.startsWith("/**")){
                 documentHandler.property(name, exp, important, token.specialToken.image);
             }else{
                 documentHandler.property(name, exp, important, null);
             }
         }
        break;
      case LBRACE:
        jj_consume_token(LBRACE);
        label_149:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[218] = jj_gen;
            break label_149;
          }
          jj_consume_token(S);
        }
         documentHandler.startNestedProperties(name);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTERPOLATION:
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[219] = jj_gen;
          ;
        }
        label_150:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[220] = jj_gen;
            break label_150;
          }
          jj_consume_token(SEMICOLON);
          label_151:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[221] = jj_gen;
              break label_151;
            }
            jj_consume_token(S);
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTERPOLATION:
          case IDENT:
            declaration();
            break;
          default:
            jj_la1[222] = jj_gen;
            ;
          }
        }
        jj_consume_token(RBRACE);
        label_152:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[223] = jj_gen;
            break label_152;
          }
          jj_consume_token(S);
        }
         documentHandler.endNestedProperties(name);
        break;
      default:
        jj_la1[224] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (NumberFormatException e) {
     if (errorHandler != null) {
         errorHandler.error(new CSSParseException("Invalid number "
                                                  + e.getMessage(),
                                                  getLocator(),
                                                  e));
     }
     reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
         LocatorImpl loc = (LocatorImpl) getLocator();
         loc.column--;
         reportWarningSkipText(loc, skipAfterExpression());
         */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void declaration() throws ParseException {
  boolean important = false;
  String name;
  SassListItem exp;
  Token save;
    try {
      name = property();
       save = token;
      jj_consume_token(COLON);
      label_153:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[225] = jj_gen;
          break label_153;
        }
        jj_consume_token(S);
      }
      exp = expressionList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORTANT_SYM:
        important = prio();
        break;
      default:
        jj_la1[226] = jj_gen;
        ;
      }
        exp = ((SassList) exp).flatten();
        documentHandler.property(name, exp, important);
    } catch (JumpException e) {
     skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (NumberFormatException e) {
     if (errorHandler != null) {
         errorHandler.error(new CSSParseException("Invalid number "
                                                  + e.getMessage(),
                                                  getLocator(),
                                                  e));
     }
     reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
     if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
	 LocatorImpl loc = (LocatorImpl) getLocator();
	 loc.column--;
	 reportWarningSkipText(loc, skipAfterExpression());
	 */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_154:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[227] = jj_gen;
        break label_154;
      }
      jj_consume_token(S);
    }
                             {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public boolean guarded() throws ParseException {
    jj_consume_token(GUARDED_SYM);
    label_155:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[228] = jj_gen;
        break label_155;
      }
      jj_consume_token(S);
    }
                          {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl operator(LexicalUnitImpl prev) throws ParseException {
 Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      /* (comments copied from basic_arithmetics.scss)
      *supports:
      * 1. standard arithmetic operations (+, -, *, /, %)
      * 2. / is treated as css operator, unless one of its operands is variable or there is another binary arithmetic operator
      *limits:
      * 1. cannot mix arithmetic and css operations, e.g. "margin: 1px + 3px 2px" will fail
      * 2. space between add and minus operator and their following operand is mandatory. e.g. "1 + 2" is valid, "1+2" is not
      * 3. parenthesis is not supported now.  
      */
      n = jj_consume_token(COMMA);
      label_156:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[229] = jj_gen;
          break label_156;
        }
        jj_consume_token(S);
      }
                 {if (true) return LexicalUnitImpl.createComma(n.beginLine,
            n.beginColumn,
            prev);}
      break;
    case DIV:
      n = jj_consume_token(DIV);
      label_157:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[230] = jj_gen;
          break label_157;
        }
        jj_consume_token(S);
      }
                  {if (true) return LexicalUnitImpl.createSlash(n.beginLine,
            n.beginColumn,
            prev);}
      break;
    case ANY:
      n = jj_consume_token(ANY);
      label_158:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[231] = jj_gen;
          break label_158;
        }
        jj_consume_token(S);
      }
                   {if (true) return LexicalUnitImpl.createMultiply(n.beginLine,
            n.beginColumn,
            prev);}
      break;
    case MOD:
      n = jj_consume_token(MOD);
      label_159:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[232] = jj_gen;
          break label_159;
        }
        jj_consume_token(S);
      }
                   {if (true) return LexicalUnitImpl.createModulo(n.beginLine,
            n.beginColumn,
            prev);}
      break;
    case PLUS:
      n = jj_consume_token(PLUS);
      label_160:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[233] = jj_gen;
          break label_160;
        }
      }
                  {if (true) return LexicalUnitImpl.createAdd(n.beginLine,
        n.beginColumn,
        prev);}
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      label_161:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[234] = jj_gen;
          break label_161;
        }
      }
                  {if (true) return LexicalUnitImpl.createMinus(n.beginLine,
        n.beginColumn,
        prev);}
      break;
    default:
      jj_la1[235] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl nonCommaOperator(LexicalUnitImpl prev) throws ParseException {
 Token n;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIV:
      /* (comments copied from basic_arithmetics.scss)
           *supports:
           * 1. standard arithmetic operations (+, -, *, /, %)
           * 2. / is treated as css operator, unless one of its operands is variable or there is another binary arithmetic operator
           *limits:
           * 1. space between add and minus operator and their following operand is mandatory. e.g. "1 + 2" is valid, "1+2" is not
           * 2. parenthesis is not supported now.
           */
          n = jj_consume_token(DIV);
      label_162:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[236] = jj_gen;
          break label_162;
        }
        jj_consume_token(S);
      }
                     {if (true) return LexicalUnitImpl.createSlash(n.beginLine, n.beginColumn, prev);}
      break;
    case ANY:
      n = jj_consume_token(ANY);
      label_163:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[237] = jj_gen;
          break label_163;
        }
        jj_consume_token(S);
      }
                       {if (true) return LexicalUnitImpl.createMultiply(n.beginLine, n.beginColumn, prev);}
      break;
    case MOD:
      n = jj_consume_token(MOD);
      label_164:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[238] = jj_gen;
          break label_164;
        }
        jj_consume_token(S);
      }
                       {if (true) return LexicalUnitImpl.createModulo(n.beginLine, n.beginColumn, prev);}
      break;
    case PLUS:
      n = jj_consume_token(PLUS);
      label_165:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[239] = jj_gen;
          break label_165;
        }
      }
                      {if (true) return LexicalUnitImpl.createAdd(n.beginLine, n.beginColumn, prev);}
      break;
    case MINUS:
      n = jj_consume_token(MINUS);
      label_166:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[240] = jj_gen;
          break label_166;
        }
      }
                      {if (true) return LexicalUnitImpl.createMinus(n.beginLine, n.beginColumn, prev);}
      break;
    default:
      jj_la1[241] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl expr() throws ParseException {
    LexicalUnitImpl first, res;
    char op;
    first = term(null);
                      res = first;
    label_167:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_167;
      }
      if (jj_2_8(2)) {
        res = operator(res);
      } else {
        ;
      }
      res = term(res);
    }
    {if (true) return first;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
        {if (true) return '-';}
      break;
    case PLUS:
      jj_consume_token(PLUS);
        {if (true) return '+';}
      break;
    default:
      jj_la1[242] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl term(LexicalUnitImpl prev) throws ParseException {
  LexicalUnitImpl result = null;
  Token n = null;
  char op = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DOT:
    case TO:
    case THROUGH:
    case FROM:
    case STRING:
    case IDENT:
    case NUMBER:
    case URL:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case FUNCTION:
      result = nonVariableTerm(prev);
      break;
    case VARIABLE:
      result = variableTerm(prev);
      break;
    default:
      jj_la1[243] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl variableTerm(LexicalUnitImpl prev) throws ParseException {
  LexicalUnitImpl result = null;
  String varName = "";
    varName = variableName();
          result = LexicalUnitImpl.createVariable(token.beginLine, token.beginColumn,
                 prev, varName); {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl nonVariableTerm(LexicalUnitImpl prev) throws ParseException {
LexicalUnitImpl result = null;
  Token n = null;
  char op = ' ';
  String varName;
  String s = "";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case NUMBER:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case FUNCTION:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        op = unaryOperator();
        break;
      default:
        jj_la1[244] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        n = jj_consume_token(NUMBER);
          result = LexicalUnitImpl.createNumber(n.beginLine, n.beginColumn,
                                                prev, number(op, n, 0));
        break;
      case PERCENTAGE:
        n = jj_consume_token(PERCENTAGE);
          result = LexicalUnitImpl.createPercentage(n.beginLine, n.beginColumn,
                                                    prev, number(op, n, 1));
        break;
      case PT:
        n = jj_consume_token(PT);
          result = LexicalUnitImpl.createPT(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case CM:
        n = jj_consume_token(CM);
          result = LexicalUnitImpl.createCM(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case MM:
        n = jj_consume_token(MM);
          result = LexicalUnitImpl.createMM(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case PC:
        n = jj_consume_token(PC);
          result = LexicalUnitImpl.createPC(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case IN:
        n = jj_consume_token(IN);
          result = LexicalUnitImpl.createIN(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case PX:
        n = jj_consume_token(PX);
          result = LexicalUnitImpl.createPX(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case EMS:
        n = jj_consume_token(EMS);
          result = LexicalUnitImpl.createEMS(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 2));
        break;
      case LEM:
        n = jj_consume_token(LEM);
          result = LexicalUnitImpl.createLEM(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
      case REM:
        n = jj_consume_token(REM);
          result = LexicalUnitImpl.createREM(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
      case EXS:
        n = jj_consume_token(EXS);
          result = LexicalUnitImpl.createEXS(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 2));
        break;
      case DEG:
        n = jj_consume_token(DEG);
          result = LexicalUnitImpl.createDEG(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
      case RAD:
        n = jj_consume_token(RAD);
          result = LexicalUnitImpl.createRAD(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
      case GRAD:
        n = jj_consume_token(GRAD);
          result = LexicalUnitImpl.createGRAD(n.beginLine, n.beginColumn,
                                              prev, number(op, n, 3));
        break;
      case SECOND:
        n = jj_consume_token(SECOND);
          result = LexicalUnitImpl.createS(n.beginLine, n.beginColumn,
                                           prev, number(op, n, 1));
        break;
      case MS:
        n = jj_consume_token(MS);
          result = LexicalUnitImpl.createMS(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case HZ:
        n = jj_consume_token(HZ);
          result = LexicalUnitImpl.createHZ(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
      case KHZ:
        n = jj_consume_token(KHZ);
          result = LexicalUnitImpl.createKHZ(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
      case DIMEN:
        n = jj_consume_token(DIMEN);
            s = n.image;
            int i = 0;
            while (i < s.length()
                   && (Character.isDigit(s.charAt(i)) || (s.charAt(i) == '.'))) {
                i++;
            }

            result = LexicalUnitImpl.createDimen(n.beginLine, n.beginColumn, prev,
                                                 number(op,n,s.length()-i),
                                                 s.substring(i));
        break;
      case FUNCTION:
        result = function(op, prev);
        break;
      default:
        jj_la1[245] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case DOT:
    case TO:
    case THROUGH:
    case FROM:
    case STRING:
    case IDENT:
    case URL:
    case HASH:
    case UNICODERANGE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
        n = jj_consume_token(STRING);
          result =
          LexicalUnitImpl.createString(n.beginLine, n.beginColumn, prev,
                                       convertStringIndex(n.image, 1,
                                                          n.image.length() -1));
        break;
      case DOT:
      case TO:
      case THROUGH:
      case FROM:
      case IDENT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          jj_consume_token(DOT);
              s+=".";
          break;
        default:
          jj_la1[246] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          n = jj_consume_token(IDENT);
          break;
        case TO:
          n = jj_consume_token(TO);
          break;
        case THROUGH:
          n = jj_consume_token(THROUGH);
          break;
        case FROM:
          n = jj_consume_token(FROM);
          break;
        default:
          jj_la1[247] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        s += convertIdent(n.image);
        if ("inherit".equals(s)) {
            result = LexicalUnitImpl.createInherit(n.beginLine, n.beginColumn,
                                               prev);
        } else {
            result = LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn,
                                               prev, convertIdent(n.image));
        }

          /* /
         Auto correction code used in the CSS Validator but must not
          be used by a conformant CSS2 parser.
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 *
	Token t = getToken(1);
	Token semicolon = new Token();
	semicolon.kind = SEMICOLON;
	semicolon.image = ";";
	if (t.kind == COLON) {
	    // @@SEEME. (generate a warning?)
	    // @@SEEME if expression is a single ident, 
	       generate an error ?
	    rejectToken(semicolon);
	    
	    result = prev;
	}
	/ */

        break;
      case HASH:
        result = hexcolor(prev);
        break;
      case URL:
        result = url(prev);
        break;
      case UNICODERANGE:
        result = unicode(prev);
        break;
      default:
        jj_la1[248] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[249] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_168:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[250] = jj_gen;
        break label_168;
      }
      jj_consume_token(S);
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * Handle all CSS2 functions.
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl function(char operator, LexicalUnitImpl prev) throws ParseException {
 Token n;
 SassList params = new SassList(SassList.Separator.COMMA);
    n = jj_consume_token(FUNCTION);
    label_169:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[251] = jj_gen;
        break label_169;
      }
      jj_consume_token(S);
    }
        String fname = convertIdent(n.image);
        if("alpha(".equals(fname) || "expression(".equals(fname)){
            String body = skipStatementUntilSemiColon();
            {if (true) return LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn,
                 null, fname+body);}
        }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
    case DOT:
    case TO:
    case THROUGH:
    case FROM:
    case STRING:
    case IDENT:
    case NUMBER:
    case URL:
    case VARIABLE:
    case PERCENTAGE:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case LEM:
    case REM:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case FUNCTION:
      params = expressionList();
        SassListItem item = params.flatten();
        if (item instanceof SassList) {
            params = (SassList) item;
        } else {
            params = new SassList(SassList.Separator.COMMA, item);
        }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                     params = new VariableArgumentList(params);
        label_170:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[252] = jj_gen;
            break label_170;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[253] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[254] = jj_gen;
      ;
    }
    jj_consume_token(RPARAN);
        if (operator != ' ') {
        {if (true) throw new CSSParseException("invalid operator before a function.",
                    getLocator());}
        }
        String f = convertIdent(n.image);
        // f contains the opening parenthesis of the function call
        {if (true) return LexicalUnitImpl.createFunction(n.beginLine, n.beginColumn, prev, f.substring(0, f.length() -1), params);}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl unicode(LexicalUnitImpl prev) throws ParseException {
  Token n;
    n = jj_consume_token(UNICODERANGE);
     LexicalUnitImpl params = null;
     String s = n.image.substring(2);
     int index = s.indexOf('-');
     if (index == -1) {
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s, 16));
     } else {
         String s1 = s.substring(0, index);
         String s2 = s.substring(index);

         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s1, 16));
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s2, 16));
     }

     {if (true) return LexicalUnitImpl.createUnicodeRange(n.beginLine, n.beginColumn,
                                               prev, params);}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl url(LexicalUnitImpl prev) throws ParseException {
  Token n;
    n = jj_consume_token(URL);
   String urlname = n.image.substring(4, n.image.length()-1).trim();
   {if (true) return LexicalUnitImpl.createURL(n.beginLine, n.beginColumn, prev, urlname);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl hexcolor(LexicalUnitImpl prev) throws ParseException {
 Token n;
    n = jj_consume_token(HASH);
     int r;
     LexicalUnitImpl first, params = null;
     String s = n.image.substring(1);

     if(s.length()!=3 && s.length()!=6) {
         first = null;
         {if (true) throw new CSSParseException("invalid hexadecimal notation for RGB: " + s,
                                     getLocator());}
     }
     {if (true) return LexicalUnitImpl.createIdent(n.beginLine, n.beginColumn,
             prev, n.image);}
    throw new Error("Missing return statement in function");
  }

  float number(char operator, Token n, int lengthUnit) throws ParseException {
    String image  = n.image;
    float f = 0;

    if (lengthUnit != 0) {
        image = image.substring(0, image.length() - lengthUnit);
    }
    f = Float.valueOf(image).floatValue();
    return (operator == '-')? -f: f;
  }

  String skipStatementUntilSemiColon() throws ParseException {
    int[] semicolon = {SEMICOLON};
    return skipStatementUntil(semicolon);
  }

  String skipStatementUntilLeftBrace() throws ParseException {
    int[] lBrace = {LBRACE};
    return skipStatementUntil(lBrace);
  }

  String skipStatementUntilMatchingRightParan() throws ParseException {
    int[] leftTokens = {LPARAN, FUNCTION}; // a FUNCTION also contains "("
    int[] rightTokens = {RPARAN};
    StringBuffer s = new StringBuffer();
    int difference = 1;
    Token tok;
    while(difference != 0){
        tok = getToken(1);
        if(tok.kind == EOF) {
            return null;
        }
        for(int sym : leftTokens){
            if(tok.kind == sym){
                difference++;
            }
        }
        for(int sym : rightTokens){
            if(tok.kind == sym){
                difference--;
            }
        }
        if(difference != 0){
            if (tok.image != null) {
                s.append(tok.image);
            }
            getNextToken();
        }
    }
    return s.toString().trim();
  }

  String skipStatementUntil(int[] symbols) throws ParseException {
    StringBuffer s = new StringBuffer();
    boolean found = false;
    Token tok;
    while(!found){
        tok = getToken(1);
        for(int sym : symbols){
            if(tok.kind == sym){
                found = true;
                break;
            }
        }
        if(tok.kind == EOF) {
            break;
        }
        if(!found){
            if (tok.image != null) {
                s.append(tok.image);
            }
            getNextToken();
        }
    }
    return found ? s.toString().trim() : null;
  }

  String skipStatement() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token tok = getToken(0);
    if (tok.image != null) {
        s.append(tok.image);
    }
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            return null;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            getNextToken();
            s.append(skip_to_matching_brace());
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == RBRACE) {
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == SEMICOLON) {
            getNextToken();
            tok = getToken(1);
            break;
        }
        getNextToken();
    }

    // skip white space
    while (true) {
        if (tok.kind != S) {
            break;
        }
        tok = getNextToken();
        tok = getToken(1);
    }

    return s.toString().trim();
  }

  String skip_to_matching_brace() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token tok;
    int nesting = 1;
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                break;
            }
        }
        getNextToken();
    }
    return s.toString();
  }

  String convertStringIndex(String s, int start, int len) throws ParseException {
    StringBuffer buf = new StringBuffer(len);
    int index = start;

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\u005c\u005c') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    buf.append('\u005c\u005c');
                    while (index < len) {
                        buf.append(s.charAt(index++));
                    }
                    break;
                case '\u005cn':
                case '\u005cf':
                    break;
                case '\u005cr':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\u005cn') {
                            index ++;
                        }
                    }
                    break;
                default:
                    buf.append(c);
                }
            } else {
                throw new CSSParseException("invalid string " + s, getLocator());
            }
        } else {
            buf.append(c);
        }
        index++;
    }

    return buf.toString();
  }

  String convertIdent(String s) throws ParseException {
    return convertStringIndex(s, 0, s.length());
  }

  String convertString(String s) throws ParseException {
    return convertStringIndex(s, 0, s.length());
  }

  void comments() throws ParseException {
        /*keeps only the multiple line comments, single line comments are skipped*/
    if (token.specialToken != null && token.specialToken.image!=null && token.specialToken.image.startsWith("/*")){
        Token tmp_t = token.specialToken;
        while (tmp_t.specialToken != null) tmp_t = tmp_t.specialToken;
        while (tmp_t != null) {
            documentHandler.comment(tmp_t.image);
            tmp_t = tmp_t.next;
        }
    }
  }

  void rejectToken(Token t) throws ParseException {
    Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  String skipAfterExpression() throws ParseException {
    Token t = getToken(1);
    StringBuffer s = new StringBuffer();
    s.append(getToken(0).image);

    while ((t.kind != RBRACE) && (t.kind != SEMICOLON) && (t.kind != EOF)) {
        s.append(t.image);
        getNextToken();
        t = getToken(1);
    }

    return s.toString();
  }

/**
 * The following functions are useful for a DOM CSS implementation only and are
 * not part of the general CSS2 parser.
 */
// TODO required by original parser but not used by Vaadin?
  final public void _parseRule() throws ParseException {
 String ret = null;
    label_171:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[255] = jj_gen;
        break label_171;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPORT_SYM:
      importDeclaration();
      break;
    case DEBUG_SYM:
    case WARN_SYM:
      debuggingDirective();
      break;
    case PLUS:
    case PRECEDES:
    case SIBLING:
    case LBRACKET:
    case ANY:
    case PARENT:
    case DOT:
    case COLON:
    case INTERPOLATION:
    case IDENT:
    case HASH:
      styleRule();
      break;
    case MEDIA_SYM:
      media();
      break;
    case PAGE_SYM:
      page();
      break;
    case FONT_FACE_SYM:
      fontFace();
      break;
    default:
      jj_la1[256] = jj_gen;
      ret = skipStatement();
                    if ((ret == null) || (ret.length() == 0)) {
                        {if (true) return;}
                    }
                    if (ret.charAt(0) == '@') {
                        documentHandler.unrecognizedRule(ret);
                    } else {
                        {if (true) throw new CSSParseException("unrecognize rule: " + ret,
                                                    getLocator());}
                    }
    }
  }

  final public void _parseImportRule() throws ParseException {
    label_172:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[257] = jj_gen;
        break label_172;
      }
      jj_consume_token(S);
    }
    importDeclaration();
  }

  final public void _parseMediaRule() throws ParseException {
    label_173:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[258] = jj_gen;
        break label_173;
      }
      jj_consume_token(S);
    }
    media();
  }

  final public void _parseDeclarationBlock() throws ParseException {
    label_174:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[259] = jj_gen;
        break label_174;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTERPOLATION:
    case IDENT:
      declaration();
      break;
    default:
      jj_la1[260] = jj_gen;
      ;
    }
    label_175:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[261] = jj_gen;
        break label_175;
      }
      jj_consume_token(SEMICOLON);
      label_176:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[262] = jj_gen;
          break label_176;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTERPOLATION:
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[263] = jj_gen;
        ;
      }
    }
  }

  final public ArrayList<String> _parseSelectors() throws ParseException {
  ArrayList<String> p = null;
    try {
      label_177:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[264] = jj_gen;
          break label_177;
        }
        jj_consume_token(S);
      }
      p = selectorList();
          {if (true) return p;}
    } catch (ThrowedParseException e) {
        {if (true) throw (ParseException) e.e.fillInStackTrace();}
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_280() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    if (jj_3R_280()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_280()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_scan_token(MINUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_208() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_3R_236()) return true;
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(MOD)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_234()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_210() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_260() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_268()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_205() {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_267()) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_187() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_3R_208()) {
    jj_scanpos = xsp;
    if (jj_3R_209()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_228() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_178() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_3R_235()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_183()) return true;
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_184()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_272() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) {
    jj_scanpos = xsp;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_scan_token(DIMEN)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    Token xsp;
    if (jj_3R_213()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_213()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_scan_token(KHZ)) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_212()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_272()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(HZ)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) return true;
    }
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_scan_token(MS)) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_210()) return true;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_scan_token(SECOND)) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(GRAD)) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_scan_token(RAD)) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(DEG)) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (true) { jj_la = 0; jj_scanpos = jj_lastpos; return false;}
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(EXS)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(LEM)) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(EMS)) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(PX)) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(PC)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_178()) return true;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(MM)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(CM)) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_282()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) return true;
    }
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(PT)) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3R_199() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_1()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(PERCENTAGE)) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_3R_266()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_237()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_214() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(URL)) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_199()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_200()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_3R_214()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_186()) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(UNICODERANGE)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(STARMATCH)) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_scan_token(DOLLARMATCH)) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_scan_token(CARETMATCH)) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(DASHMATCH)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_scan_token(INCLUDES)) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(INTERPOLATION)) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_266() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    }
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(INTERPOLATION)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) return true;
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_181()) return true;
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) jj_scanpos = xsp;
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_3R_182()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENT)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_281()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(INTERPOLATION)) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(VARIABLE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_180()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_scan_token(MINUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(PARENT)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    Token xsp;
    if (jj_3_2()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(FUNCTION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_279()) jj_scanpos = xsp;
    if (jj_scan_token(RPARAN)) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_218() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) return true;
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_185()) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    Token xsp;
    if (jj_3R_218()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(MOD)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_232() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_212() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_220() {
    Token xsp;
    if (jj_3R_232()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_232()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_3R_201()) return true;
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) return true;
    }
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_181() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_3R_182()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[265];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x302,0x302,0x0,0x300,0x2,0x2,0x2,0x200000,0xd4c40000,0x300,0x2,0x300,0x2,0x0,0x2,0x200000,0x2,0x2,0x0,0x0,0x2,0x2,0x0,0x0,0x2,0x0,0x2,0x100000,0x2,0x0,0x2,0x2,0xd4c40000,0xd4c40000,0x2,0x2,0x2,0xd4fd1500,0x2,0xd4fd1500,0x2,0x2,0x0,0x0,0x2,0x0,0x200000,0x2,0x0,0x2,0x2,0x2,0x2,0x0,0x200000,0x2,0x0,0x2,0x391500,0xc40000,0xc40002,0xc40000,0x2,0x2,0x80120002,0x80120002,0x2,0x0,0x0,0x2,0x2,0x2,0x2,0xd4c40000,0xd4c40000,0x2,0x100000,0x2,0xd4c40000,0x2,0x84000000,0x84000000,0x84000000,0x84000000,0xd4000000,0x0,0x0,0x0,0x0,0x50000000,0x2,0x2,0x3f000,0x2,0x0,0x2,0x3f000,0x0,0x2,0x0,0x2,0x0,0x100000,0x2,0x0,0xd4c40000,0x134e0002,0x2,0xd4c40000,0xd4c40000,0x2,0x0,0x2,0x134e0002,0x0,0x2,0xd4c40000,0xd4c40000,0x2,0x134e0002,0x2,0x2,0x2,0x0,0x2,0xd4c40000,0x2,0x2,0x100000,0x2,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0xd4c40000,0xd4c40000,0x2,0x2,0x2,0x0,0x2,0x2,0x0,0x2,0x0,0x0,0x134e0002,0x2,0x0,0x2,0x0,0x2,0x134e0002,0x0,0x2,0x0,0x2,0x2,0x2,0x2,0x0,0x2,0x0,0x2,0x100000,0x2,0x0,0x2,0x800c0000,0x0,0x0,0x100000,0x2,0x800c0000,0x2,0x800c0000,0x800c0000,0x800c0000,0x2,0x2,0x2,0x0,0x2,0x0,0x400,0x2,0x200000,0x200000,0x2,0xd4c40000,0xd4c40000,0x2,0x0,0x2,0x200000,0x2,0x200000,0x0,0x2,0x2,0x2,0x2,0x200000,0x2,0x2,0x0,0x200000,0x2,0x0,0x2,0x0,0xd4c40000,0x2,0x0,0x2,0x0,0x200000,0x2,0x0,0x2,0x800c0400,0x2,0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x321c0000,0x2,0x2,0x2,0x2,0x2,0x320c0000,0xc0000,0x800c0000,0xc0000,0x0,0x80000000,0x0,0x80000000,0x800c0000,0x2,0x2,0x2,0x0,0x800c0000,0x2,0xd4c40000,0x2,0x2,0x2,0x0,0x200000,0x2,0x0,0x2,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xadc00180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x100,0x0,0x0,0x240000,0x240000,0x0,0x240000,0x0,0x0,0x0,0x240000,0x0,0x0,0xac800180,0xac800180,0x0,0x0,0x0,0xc000380,0x0,0xc000380,0x0,0x0,0x0,0x80,0x0,0x100,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x184,0x184,0x0,0x100,0x100,0x0,0x0,0x0,0x0,0xac800180,0xac800180,0x0,0x0,0x0,0x180,0x0,0x80,0x80,0x80,0x80,0x180,0x100,0x100,0x100,0x100,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0xa0000000,0xac800180,0x7e,0x0,0xac800180,0xac800180,0x0,0x0,0x0,0x7e,0x0,0x0,0xac800180,0xac800180,0x0,0x7e,0x0,0x0,0x0,0x0,0x0,0xac800180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x100,0x0,0xac800180,0xac800180,0x0,0x0,0x0,0x1,0x0,0x0,0xa2000000,0x0,0xa2000000,0xa0000000,0x7e,0x0,0xa2000000,0x0,0x0,0x0,0x7e,0x0,0x0,0xa2000000,0x0,0x0,0x0,0x0,0x0,0x0,0xa2000000,0x0,0x0,0x0,0x0,0x0,0x2c0000,0x80,0x80,0x0,0x0,0x2c0000,0x0,0x2c0000,0x2c0000,0x2c0000,0x0,0x0,0x0,0x1,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0xc240180,0xc240180,0x0,0xc000000,0x0,0x0,0x0,0x0,0xc0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0xc000000,0x180,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,0x2c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2c0000,0x0,0x0,0x0,0x2c0000,0x2c0000,0x2c0000,0x0,0x0,0x0,0x1,0x2c0000,0x0,0xc000180,0x0,0x0,0x0,0x100,0x0,0x0,0x100,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2200,0x0,0x0,0x0,0x0,0x1100,0x0,0x0,0x0,0x0,0x200,0x200,0x0,0x0,0x4010,0x4010,0x0,0x4000,0x0,0x0,0x0,0x4000,0x0,0x0,0x2232,0x2232,0x0,0x0,0x0,0x5710,0x0,0x5710,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x5500,0x0,0x0,0x0,0x0,0x0,0x700,0x700,0x0,0x200,0x200,0x0,0x0,0x0,0x0,0x2232,0x2232,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x200,0x200,0x200,0x200,0x200,0x200,0x0,0x0,0x0,0x0,0x300,0x0,0x0,0x0,0x0,0x200,0x0,0x80,0x0,0x0,0x0,0x2212,0x2600,0x0,0x2212,0x2212,0x0,0x1,0x0,0x2600,0x40,0x0,0x2212,0x2212,0x0,0x2600,0x0,0x0,0x0,0x2200,0x0,0x2212,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x2212,0x2212,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x2000,0x0,0x2600,0x0,0x2000,0x0,0x1,0x0,0x2600,0x40,0x0,0x2000,0x0,0x0,0x0,0x0,0x2200,0x0,0x2000,0x0,0x0,0x0,0x2000,0x0,0xffffd700,0x2000,0x2000,0x0,0x0,0xfffff700,0x0,0xfffff700,0xfffff700,0xfffff700,0x0,0x0,0x0,0x0,0x0,0x2200,0x0,0x0,0x0,0x0,0x0,0x4200,0x4200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,0xfffff700,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xfffff700,0x0,0xffffc400,0x0,0x200,0x1300,0xffffd700,0x0,0x0,0x0,0x0,0xfffff700,0x0,0x200,0x0,0x0,0x0,0x200,0x0,0x0,0x200,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x10,0x100,0x100,0x4,0x100,0x0,0x0,0x0,0x0,0xea,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18a,0x18a,0x0,0x0,0x0,0x38037e,0x0,0x38037e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x38037c,0x0,0x0,0x0,0x0,0x0,0x100000,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18e,0x18e,0x0,0x0,0x0,0x2,0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x18a,0x0,0x0,0x1ca,0x1ca,0x0,0x0,0x0,0x0,0x0,0x0,0x1ca,0x1ca,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18a,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x1ea,0x1ea,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180003,0x0,0x0,0x0,0x0,0x180003,0x0,0x180003,0x180003,0x180003,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x2,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x180003,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180003,0x0,0x100001,0x0,0x0,0x80002,0x180003,0x0,0x0,0x0,0x0,0x180003,0x0,0x6e,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[8];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public Parser(CharStream stream) {
    token_source = new ParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 265; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 265; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 265; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 265; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[118];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 265; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 118; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 8; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
