/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_3D {
    private int slices;
    private int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private double[] t;
    private DoubleDST_1D dstSlices;
    private DoubleDST_1D dstRows;
    private DoubleDST_1D dstColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 4;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (columns == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
        }
        this.dstSlices = new DoubleDST_1D(slices);
        this.dstRows = slices == rows ? this.dstSlices : new DoubleDST_1D(rows);
        this.dstColumns = slices == columns ? this.dstSlices : (rows == columns ? this.dstRows : new DoubleDST_1D(columns));
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDST_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx1 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDST_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDST_3D.this.rowStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void forward(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                DoubleDST_3D.this.dstRows.forward(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                DoubleDST_3D.this.dstSlices.forward(temp, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a[s][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dstRows.forward(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dstSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDST_3D.this.sliceStride;
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx1 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleDST_3D.this.sliceStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * DoubleDST_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * DoubleDST_3D.this.rowStride;
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx3 = s * DoubleDST_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a, idx12 + r * this.rowStride, scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new double[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                DoubleDST_3D.this.dstRows.inverse(temp, scale);
                                for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleDST_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(temp, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a[s][r], scale);
                }
            }
            double[] temp = new double[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dstRows.inverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new double[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dstSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = this.t[r2];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = this.t[r3];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, double[][][] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.forward(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[s][r2][c];
                            this.t[idx2] = a[s][r2][c + 1];
                            this.t[idx2 + this.rows] = a[s][r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = this.t[r2];
                            a[s][r2][c + 1] = this.t[idx2];
                            a[s][r2][c + 2] = this.t[idx2 + this.rows];
                            a[s][r2][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dstColumns.inverse(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[s][r3][c];
                            this.t[idx2] = a[s][r3][c + 1];
                            this.t[idx2 + this.rows] = a[s][r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = this.t[r3];
                            a[s][r3][c + 1] = this.t[idx2];
                            a[s][r3][c + 2] = this.t[idx2 + this.rows];
                            a[s][r3][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                this.t[s] = a[idx1];
                                this.t[idx2] = a[idx1 + 1];
                                this.t[idx2 + this.slices] = a[idx1 + 2];
                                this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dstSlices.forward(this.t, 0, scale);
                            this.dstSlices.forward(this.t, this.slices, scale);
                            this.dstSlices.forward(this.t, 2 * this.slices, scale);
                            this.dstSlices.forward(this.t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = this.t[s];
                                a[idx1 + 1] = this.t[idx2];
                                a[idx1 + 2] = this.t[idx2 + this.slices];
                                a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dstSlices.forward(this.t, 0, scale);
                    this.dstSlices.forward(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            this.t[s] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.slices] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dstSlices.inverse(this.t, 0, scale);
                        this.dstSlices.inverse(this.t, this.slices, scale);
                        this.dstSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dstSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = this.t[s];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.slices];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dstSlices.inverse(this.t, 0, scale);
                    this.dstSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, double[][][] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                this.t[s] = a[s][r][c];
                                this.t[idx2] = a[s][r][c + 1];
                                this.t[idx2 + this.slices] = a[s][r][c + 2];
                                this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            }
                            this.dstSlices.forward(this.t, 0, scale);
                            this.dstSlices.forward(this.t, this.slices, scale);
                            this.dstSlices.forward(this.t, 2 * this.slices, scale);
                            this.dstSlices.forward(this.t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a[s][r][c] = this.t[s];
                                a[s][r][c + 1] = this.t[idx2];
                                a[s][r][c + 2] = this.t[idx2 + this.slices];
                                a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dstSlices.forward(this.t, 0, scale);
                    this.dstSlices.forward(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            this.t[s] = a[s][r][c];
                            this.t[idx2] = a[s][r][c + 1];
                            this.t[idx2 + this.slices] = a[s][r][c + 2];
                            this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                        }
                        this.dstSlices.inverse(this.t, 0, scale);
                        this.dstSlices.inverse(this.t, this.slices, scale);
                        this.dstSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dstSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a[s][r][c] = this.t[s];
                            a[s][r][c + 1] = this.t[idx2];
                            a[s][r][c + 2] = this.t[idx2 + this.slices];
                            a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dstSlices.inverse(this.t, 0, scale);
                    this.dstSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDST_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDST_3D.this.sliceStride;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a, idx0 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDST_3D.this.rows + r2;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r2] = a[idx1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDST_3D.this.rows + r2;
                                        a[idx1] = DoubleDST_3D.this.t[startt + r2];
                                        a[idx1 + 1] = DoubleDST_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.rows];
                                        a[idx1 + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r] = a[idx1];
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt, scale);
                            DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                a[idx1] = DoubleDST_3D.this.t[startt + r];
                                a[idx1 + 1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDST_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * DoubleDST_3D.this.sliceStride;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a, idx0 + r * DoubleDST_3D.this.rowStride, scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDST_3D.this.rows + r3;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r3] = a[idx1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleDST_3D.this.rowStride + c;
                                        idx2 = startt + DoubleDST_3D.this.rows + r3;
                                        a[idx1] = DoubleDST_3D.this.t[startt + r3];
                                        a[idx1 + 1] = DoubleDST_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.rows];
                                        a[idx1 + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r] = a[idx1];
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[idx1 + 1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt, scale);
                            DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleDST_3D.this.rowStride;
                                a[idx1] = DoubleDST_3D.this.t[startt + r];
                                a[idx1 + 1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3da_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleDST_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.forward(a[s][r], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx2 = startt + DoubleDST_3D.this.rows + r2;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r2] = a[s][r2][c];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[s][r2][c + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s][r2][c + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s][r2][c + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.rows, scale);
                                    for (r2 = 0; r2 < DoubleDST_3D.this.rows; ++r2) {
                                        idx2 = startt + DoubleDST_3D.this.rows + r2;
                                        a[s][r2][c] = DoubleDST_3D.this.t[startt + r2];
                                        a[s][r2][c + 1] = DoubleDST_3D.this.t[idx2];
                                        a[s][r2][c + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.rows];
                                        a[s][r2][c + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r] = a[s][r][0];
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[s][r][1];
                            }
                            DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt, scale);
                            DoubleDST_3D.this.dstRows.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                a[s][r][0] = DoubleDST_3D.this.t[startt + r];
                                a[s][r][1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleDST_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                DoubleDST_3D.this.dstColumns.inverse(a[s][r], scale);
                            }
                            if (DoubleDST_3D.this.columns > 2) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = startt + DoubleDST_3D.this.rows + r3;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r3] = a[s][r3][c];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[s][r3][c + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s][r3][c + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).rows] = a[s][r3][c + 3];
                                    }
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.rows, scale);
                                    DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleDST_3D.this.rows; ++r3) {
                                        idx2 = startt + DoubleDST_3D.this.rows + r3;
                                        a[s][r3][c] = DoubleDST_3D.this.t[startt + r3];
                                        a[s][r3][c + 1] = DoubleDST_3D.this.t[idx2];
                                        a[s][r3][c + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.rows];
                                        a[s][r3][c + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDST_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + r] = a[s][r][0];
                                ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).rows + r] = a[s][r][1];
                            }
                            DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt, scale);
                            DoubleDST_3D.this.dstRows.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.rows, scale);
                            for (r = 0; r < DoubleDST_3D.this.rows; ++r) {
                                a[s][r][0] = DoubleDST_3D.this.t[startt + r];
                                a[s][r][1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                    int idx0 = r * DoubleDST_3D.this.rowStride;
                                    for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDST_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + DoubleDST_3D.this.slices + s;
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[idx1];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[idx1 + 1];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 2];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.slices, scale);
                                        for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                            idx1 = s * DoubleDST_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + DoubleDST_3D.this.slices + s;
                                            a[idx1] = DoubleDST_3D.this.t[startt + s];
                                            a[idx1 + 1] = DoubleDST_3D.this.t[idx2];
                                            a[idx1 + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.slices];
                                            a[idx1 + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDST_3D.this.sliceStride + idx0;
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[idx1];
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).slices + s] = a[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt, scale);
                                DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDST_3D.this.sliceStride + idx0;
                                    a[idx1] = DoubleDST_3D.this.t[startt + s];
                                    a[idx1 + 1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDST_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + DoubleDST_3D.this.slices + s;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[idx1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[idx1 + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[idx1 + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                        idx1 = s * DoubleDST_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + DoubleDST_3D.this.slices + s;
                                        a[idx1] = DoubleDST_3D.this.t[startt + s];
                                        a[idx1 + 1] = DoubleDST_3D.this.t[idx2];
                                        a[idx1 + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.slices];
                                        a[idx1 + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * DoubleDST_3D.this.rowStride;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDST_3D.this.sliceStride + idx0;
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[idx1];
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).slices + s] = a[idx1 + 1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt, scale);
                                DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    idx1 = s * DoubleDST_3D.this.sliceStride + idx0;
                                    a[idx1] = DoubleDST_3D.this.t[startt + s];
                                    a[idx1 + 1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (DoubleDST_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                            idx2 = startt + DoubleDST_3D.this.slices + s;
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[s][r][c];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[s][r][c + 1];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s][r][c + 2];
                                            ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s][r][c + 3];
                                        }
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.slices, scale);
                                        DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.slices, scale);
                                        for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                            idx2 = startt + DoubleDST_3D.this.slices + s;
                                            a[s][r][c] = DoubleDST_3D.this.t[startt + s];
                                            a[s][r][c + 1] = DoubleDST_3D.this.t[idx2];
                                            a[s][r][c + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.slices];
                                            a[s][r][c + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDST_3D.this.columns != 2) break block19;
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[s][r][0];
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).slices + s] = a[s][r][1];
                                }
                                DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt, scale);
                                DoubleDST_3D.this.dstSlices.forward(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    a[s][r][0] = DoubleDST_3D.this.t[startt + s];
                                    a[s][r][1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDST_3D.this.columns > 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleDST_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                        idx2 = startt + DoubleDST_3D.this.slices + s;
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[s][r][c];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2] = a[s][r][c + 1];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s][r][c + 2];
                                        ((DoubleDST_3D)DoubleDST_3D.this).t[idx2 + 2 * ((DoubleDST_3D)DoubleDST_3D.this).slices] = a[s][r][c + 3];
                                    }
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + 2 * DoubleDST_3D.this.slices, scale);
                                    DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + 3 * DoubleDST_3D.this.slices, scale);
                                    for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                        idx2 = startt + DoubleDST_3D.this.slices + s;
                                        a[s][r][c] = DoubleDST_3D.this.t[startt + s];
                                        a[s][r][c + 1] = DoubleDST_3D.this.t[idx2];
                                        a[s][r][c + 2] = DoubleDST_3D.this.t[idx2 + DoubleDST_3D.this.slices];
                                        a[s][r][c + 3] = DoubleDST_3D.this.t[idx2 + 2 * DoubleDST_3D.this.slices];
                                    }
                                }
                            }
                        } else if (DoubleDST_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleDST_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + s] = a[s][r][0];
                                    ((DoubleDST_3D)DoubleDST_3D.this).t[startt + ((DoubleDST_3D)DoubleDST_3D.this).slices + s] = a[s][r][1];
                                }
                                DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt, scale);
                                DoubleDST_3D.this.dstSlices.inverse(DoubleDST_3D.this.t, startt + DoubleDST_3D.this.slices, scale);
                                for (s = 0; s < DoubleDST_3D.this.slices; ++s) {
                                    a[s][r][0] = DoubleDST_3D.this.t[startt + s];
                                    a[s][r][1] = DoubleDST_3D.this.t[startt + DoubleDST_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }
}

