/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config;

import io.activej.common.Checks;
import io.activej.common.Utils;
import io.activej.config.EffectiveConfig;
import io.activej.config.converter.ConfigConverter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Config {
    public static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final Config EMPTY = new Config(){

        @Override
        @Nullable
        public String getValue(@Nullable String defaultValue) {
            return defaultValue;
        }

        @Override
        public String getValue() throws NoSuchElementException {
            throw new NoSuchElementException("No value at empty config node");
        }

        @Override
        public Map<String, Config> getChildren() {
            return Collections.emptyMap();
        }
    };
    public static final String THIS = "";
    public static final String DELIMITER = ".";
    public static final Pattern DELIMITER_PATTERN = Pattern.compile(Pattern.quote("."));
    public static final Pattern PATH_PATTERN = Pattern.compile("([0-9a-zA-Z_-]+(\\.[0-9a-zA-Z_-]+)*)?");

    public static String concatPath(String prefix, String suffix) {
        return prefix.isEmpty() || suffix.isEmpty() ? prefix + suffix : prefix + DELIMITER + suffix;
    }

    public static void checkPath(String path) {
        Checks.checkArgument((boolean)PATH_PATTERN.matcher(path).matches(), (String)"Invalid path %s", (Object[])new Object[]{path});
    }

    default public String getValue(@Nullable String defaultValue) {
        return this.get(THIS, defaultValue);
    }

    default public String getValue() throws NoSuchElementException {
        return this.get(THIS);
    }

    public Map<String, Config> getChildren();

    default public boolean hasValue() {
        return this.getValue(null) != null;
    }

    default public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    default public boolean hasChild(String path) {
        Config.checkPath(path);
        Config config = this;
        for (String key : DELIMITER_PATTERN.split(path)) {
            if (key.isEmpty()) continue;
            Map<String, Config> children = config.getChildren();
            if (!children.containsKey(key)) {
                return false;
            }
            config = children.get(key);
        }
        return true;
    }

    default public boolean isEmpty() {
        return !this.hasValue() && !this.hasChildren();
    }

    default public String get(String path) throws NoSuchElementException {
        Config.checkPath(path);
        return this.getChild(path).getValue();
    }

    default public String get(String path, @Nullable String defaultValue) {
        Config.checkPath(path);
        return this.getChild(path).getValue(defaultValue);
    }

    default public <T> T get(ConfigConverter<T> converter, String path) throws NoSuchElementException {
        return converter.get(this.getChild(path));
    }

    default public <T> T get(ConfigConverter<T> converter, String path, @Nullable T defaultValue) {
        return converter.get(this.getChild(path), defaultValue);
    }

    default public Config getChild(String path) {
        Config.checkPath(path);
        Config config = this;
        for (String key : path.split(Pattern.quote(DELIMITER))) {
            if (key.isEmpty()) continue;
            Map<String, Config> children = config.getChildren();
            config = children.containsKey(key) ? children.get(key) : config.provideNoKeyChild(key);
        }
        return config;
    }

    default public Config provideNoKeyChild(String key) {
        Checks.checkArgument((!this.getChildren().containsKey(key) ? 1 : 0) != 0, (String)"Children already contain key '%s'", (Object[])new Object[]{key});
        return EMPTY;
    }

    default public <T> void apply(ConfigConverter<T> converter, String path, Consumer<T> setter) {
        Config.checkPath(path);
        T value = this.get(converter, path);
        setter.accept(value);
    }

    default public <T> void apply(ConfigConverter<T> converter, String path, T defaultValue, Consumer<T> setter) {
        this.apply(converter, path, defaultValue, (T value, T $) -> setter.accept(value));
    }

    default public <T> void apply(ConfigConverter<T> converter, String path, T defaultValue, BiConsumer<T, T> setter) {
        Config.checkPath(path);
        T value = this.get(converter, path, defaultValue);
        setter.accept(value, defaultValue);
    }

    public static <T> BiConsumer<T, T> ifNotDefault(Consumer<T> setter) {
        return (value, defaultValue) -> {
            if (!Objects.equals(value, defaultValue)) {
                setter.accept(value);
            }
        };
    }

    public static <T> Consumer<T> ifNotNull(Consumer<T> setter) {
        return value -> {
            if (value != null) {
                setter.accept(value);
            }
        };
    }

    public static <T> Consumer<T> ifNotDefault(T defaultValue, Consumer<T> setter) {
        return value -> {
            if (!Objects.equals(value, defaultValue)) {
                setter.accept(value);
            }
        };
    }

    public static Config create() {
        return EMPTY;
    }

    public static Config ofSystemProperties() {
        return Config.ofProperties(System.getProperties());
    }

    public static Config ofSystemProperties(String prefix) {
        return Config.ofMap(System.getProperties().entrySet().stream().map(e -> e).filter(entry -> ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).length() == prefix.length() ? THIS : ((String)e.getKey()).substring(prefix.length() + 1), Map.Entry::getValue)));
    }

    public static Config ofProperties(Properties properties) {
        return Config.ofMap(properties);
    }

    public static Config ofProperties(String fileName) {
        return Config.ofProperties(fileName, false);
    }

    public static Config ofProperties(String fileName, boolean optional) {
        return Config.ofProperties(Paths.get(fileName, new String[0]), optional);
    }

    public static Config ofClassPathProperties(String fileName) {
        return Config.ofClassPathProperties(fileName, Thread.currentThread().getContextClassLoader(), false);
    }

    public static Config ofClassPathProperties(String fileName, ClassLoader classLoader) {
        return Config.ofClassPathProperties(fileName, classLoader, false);
    }

    public static Config ofClassPathProperties(String fileName, boolean optional) {
        return Config.ofClassPathProperties(fileName, Thread.currentThread().getContextClassLoader(), optional);
    }

    public static Config ofClassPathProperties(String fileName, ClassLoader classLoader, boolean optional) {
        Properties props = new Properties();
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        try (InputStream resource = classLoader.getResourceAsStream(fileName);){
            if (resource == null) {
                throw new FileNotFoundException(fileName);
            }
            props.load(resource);
        }
        catch (IOException e) {
            if (optional) {
                logger.warn("Can't load properties file: {}", (Object)fileName);
            }
            throw new IllegalArgumentException("Failed to load required properties: " + fileName, e);
        }
        return Config.ofProperties(props);
    }

    public static Config ofProperties(Path file, boolean optional) {
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            props.load(is);
        }
        catch (IOException e) {
            if (optional) {
                logger.warn("Can't load properties file: {}", (Object)file);
            }
            throw new IllegalArgumentException("Failed to load required properties: " + file, e);
        }
        return Config.ofProperties(props);
    }

    public static Config ofMap(Map<String, String> map) {
        Config config = Config.create();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            config = config.with(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public static Config ofConfigs(Map<String, Config> map) {
        Config config = Config.create();
        for (Map.Entry<String, Config> entry : map.entrySet()) {
            config = config.with(entry.getKey(), entry.getValue());
        }
        return config;
    }

    public static Config ofValue(String value) {
        return Config.create().with(THIS, value);
    }

    public static <T> Config ofValue(ConfigConverter<T> configConverter, T value) {
        EffectiveConfig effectiveConfig = EffectiveConfig.wrap(Config.create());
        configConverter.get(effectiveConfig, value);
        return Config.ofMap(effectiveConfig.getEffectiveDefaults());
    }

    public static Config lazyConfig(final Supplier<Config> configSupplier) {
        return new Config(){
            private volatile Config actualConfig;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Config ensureConfig() {
                if (this.actualConfig == null) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.actualConfig == null) {
                            this.actualConfig = (Config)configSupplier.get();
                        }
                    }
                }
                return this.actualConfig;
            }

            @Override
            public String getValue(@Nullable String defaultValue) {
                return this.ensureConfig().getValue(defaultValue);
            }

            @Override
            public String getValue() throws NoSuchElementException {
                return this.ensureConfig().getValue();
            }

            @Override
            public Map<String, Config> getChildren() {
                return this.ensureConfig().getChildren();
            }
        };
    }

    default public Config with(@NotNull String path, final @NotNull String value) {
        Config.checkPath(path);
        return this.with(path, new Config(){

            @Override
            public String getValue(@Nullable String defaultValue) {
                return value;
            }

            @Override
            public String getValue() throws NoSuchElementException {
                return value;
            }

            @Override
            public Map<String, Config> getChildren() {
                return Collections.emptyMap();
            }
        });
    }

    default public Config with(@NotNull String path, @NotNull Config config) {
        Config.checkPath(path);
        String[] keys = path.split(Pattern.quote(DELIMITER));
        for (int i = keys.length - 1; i >= 0; --i) {
            String key = keys[i];
            if (key.isEmpty()) continue;
            final Map<String, Config> map = Collections.singletonMap(key, config);
            config = new Config(){

                @Override
                @Nullable
                public String getValue(@Nullable String defaultValue) {
                    return defaultValue;
                }

                @Override
                public String getValue() throws NoSuchElementException {
                    throw new NoSuchElementException("No value at intermediate config node");
                }

                @Override
                public Map<String, Config> getChildren() {
                    return map;
                }
            };
        }
        return this.overrideWith(config);
    }

    default public Config overrideWith(Config other) {
        String otherValue = other.getValue(null);
        Map<String, Config> otherChildren = other.getChildren();
        if (otherValue == null && otherChildren.isEmpty()) {
            return this;
        }
        final String value = otherValue != null ? otherValue : this.getValue(null);
        LinkedHashMap<String, Config> children = new LinkedHashMap<String, Config>(this.getChildren());
        otherChildren.forEach((key, otherChild) -> children.merge((String)key, (Config)otherChild, Config::overrideWith));
        final Map<String, Config> finalChildren = Collections.unmodifiableMap(children);
        return new Config(){

            @Override
            @Nullable
            public String getValue(@Nullable String defaultValue) {
                return (String)Utils.nonNullElse((Object)value, (Object)defaultValue);
            }

            @Override
            public String getValue() throws NoSuchElementException {
                return (String)Utils.nonNullOrException((Object)value, () -> new NoSuchElementException("No value at config node"));
            }

            @Override
            public Map<String, Config> getChildren() {
                return finalChildren;
            }
        };
    }

    default public Config combineWith(Config other) {
        String thisValue = this.getValue(null);
        String otherValue = other.getValue(null);
        if (thisValue != null && otherValue != null) {
            throw new IllegalArgumentException("Duplicate values\n" + this.toMap() + "\n" + other.toMap());
        }
        LinkedHashMap<String, Config> children = new LinkedHashMap<String, Config>(this.getChildren());
        other.getChildren().forEach((key, otherChild) -> children.merge((String)key, (Config)otherChild, Config::combineWith));
        return EMPTY.overrideWith(thisValue != null ? Config.ofValue(thisValue) : EMPTY).overrideWith(otherValue != null ? Config.ofValue(otherValue) : EMPTY).overrideWith(Config.ofConfigs(children));
    }

    default public Map<String, String> toMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.hasValue()) {
            result.put(THIS, this.getValue());
        }
        Map<String, Config> children = this.getChildren();
        for (Map.Entry<String, Config> entry : children.entrySet()) {
            Map<String, String> childMap = entry.getValue().toMap();
            result.putAll(childMap.entrySet().stream().collect(Collectors.toMap(e -> Config.concatPath((String)entry.getKey(), (String)e.getKey()), Map.Entry::getValue)));
        }
        return result;
    }

    default public Properties toProperties() {
        Properties properties = new Properties();
        this.toMap().forEach(properties::setProperty);
        return properties;
    }
}

