/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config;

import io.activej.common.Checks;
import io.activej.common.initializer.WithInitializer;
import io.activej.config.Config;
import io.activej.config.ConfigWithFullPath;
import io.activej.config.EffectiveConfig;
import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.module.AbstractModule;
import io.activej.launcher.annotation.OnStart;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigModule
extends AbstractModule
implements WithInitializer<ConfigModule> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigModule.class);
    private Path effectiveConfigPath;
    private Consumer<String> effectiveConfigConsumer;

    public static ConfigModule create() {
        return new ConfigModule();
    }

    public ConfigModule saveEffectiveConfigTo(String file) {
        return this.saveEffectiveConfigTo(Paths.get(file, new String[0]));
    }

    public ConfigModule saveEffectiveConfigTo(Path file) {
        this.effectiveConfigPath = file;
        return this;
    }

    public ConfigModule withEffectiveConfigConsumer(Consumer<String> consumer) {
        this.effectiveConfigConsumer = consumer;
        return this;
    }

    public ConfigModule withEffectiveConfigLogger(Writer writer) {
        return this.withEffectiveConfigConsumer(effectiveConfig -> {
            try {
                writer.write((String)effectiveConfig);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ConfigModule withEffectiveConfigLogger(PrintStream writer) {
        return this.withEffectiveConfigConsumer(writer::print);
    }

    public ConfigModule withEffectiveConfigLogger() {
        return this.withEffectiveConfigConsumer(effectiveConfig -> logger.info("Effective Config:\n\n{}", effectiveConfig));
    }

    protected void configure() {
        this.transform(KeyPattern.of(Config.class, null), (bindings, scope, key, binding) -> {
            Key<CompletionStage<Void>> completionStageKey = new Key<CompletionStage<Void>>(OnStart.class){};
            return binding.addDependencies(new Key[]{completionStageKey}).mapInstance(Collections.singletonList(completionStageKey), (args, config) -> {
                CompletionStage onStart = (CompletionStage)args[0];
                AtomicBoolean started = new AtomicBoolean();
                ProtectedConfig protectedConfig = new ProtectedConfig(ConfigWithFullPath.wrap(config), started);
                EffectiveConfig effectiveConfig = EffectiveConfig.wrap(protectedConfig);
                onStart.thenRun(() -> this.save(effectiveConfig, started));
                return effectiveConfig;
            });
        });
    }

    private void save(EffectiveConfig effectiveConfig, AtomicBoolean started) {
        started.set(true);
        if (this.effectiveConfigPath != null) {
            logger.info("Saving effective config to {}", (Object)this.effectiveConfigPath);
            effectiveConfig.saveEffectiveConfigTo(this.effectiveConfigPath);
        }
        if (this.effectiveConfigConsumer != null) {
            this.effectiveConfigConsumer.accept(effectiveConfig.renderEffectiveConfig());
        }
    }

    static final class ProtectedConfig
    implements Config {
        private final Config config;
        private final Map<String, Config> children;
        private final AtomicBoolean started;

        ProtectedConfig(Config config, AtomicBoolean started) {
            this.config = config;
            this.started = started;
            this.children = new LinkedHashMap<String, Config>();
            config.getChildren().forEach((key, value) -> this.children.put((String)key, new ProtectedConfig((Config)value, started)));
        }

        @Override
        public String getValue(String defaultValue) {
            Checks.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"Config must be used during application start-up time only");
            return this.config.getValue(defaultValue);
        }

        @Override
        public String getValue() throws NoSuchElementException {
            Checks.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"Config must be used during application start-up time only");
            return this.config.getValue();
        }

        @Override
        public Map<String, Config> getChildren() {
            return this.children;
        }

        @Override
        public Config provideNoKeyChild(String key) {
            Checks.checkArgument((!this.children.containsKey(key) ? 1 : 0) != 0, (String)"Children already contain key '%s'", (Object[])new Object[]{key});
            return new ProtectedConfig(this.config.provideNoKeyChild(key), this.started);
        }
    }
}

