/*
 * Decompiled with CFR 0.152.
 */
package io.activej.config;

import io.activej.common.Checks;
import io.activej.config.Config;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public final class EffectiveConfig
implements Config {
    private final Config config;
    private final Map<String, Config> children;
    private final String path;
    private final CallsRegistry callsRegistry;

    private EffectiveConfig(String path, Config config, CallsRegistry callsRegistry) {
        this.config = config;
        this.path = path;
        this.callsRegistry = callsRegistry;
        this.children = new LinkedHashMap<String, Config>();
        for (Map.Entry<String, Config> entry : config.getChildren().entrySet()) {
            this.children.put(entry.getKey(), new EffectiveConfig(Config.concatPath(this.path, entry.getKey()), entry.getValue(), this.callsRegistry));
        }
    }

    public static EffectiveConfig wrap(Config config) {
        LinkedHashMap<String, String> allProperties = new LinkedHashMap<String, String>();
        EffectiveConfig.fetchAllConfigs(config, "", allProperties);
        CallsRegistry callsRegistry = new CallsRegistry(allProperties);
        return new EffectiveConfig("", config, callsRegistry);
    }

    private static void fetchAllConfigs(Config config, String prefix, Map<String, String> container) {
        if (config.isEmpty()) {
            return;
        }
        if (config.hasValue()) {
            container.put(prefix, config.getValue());
            return;
        }
        for (String childName : config.getChildren().keySet()) {
            EffectiveConfig.fetchAllConfigs(config.getChild(childName), Config.concatPath(prefix, childName), container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(@Nullable String defaultValue) {
        String value = this.config.getValue(defaultValue);
        EffectiveConfig effectiveConfig = this;
        synchronized (effectiveConfig) {
            this.callsRegistry.registerCall(this.path, value);
            if (defaultValue != null) {
                this.callsRegistry.registerDefaultCall(this.path, value, defaultValue);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue() {
        String value = this.config.getValue();
        EffectiveConfig effectiveConfig = this;
        synchronized (effectiveConfig) {
            this.callsRegistry.registerCall(this.path, value);
        }
        return value;
    }

    @Override
    public Map<String, Config> getChildren() {
        return this.children;
    }

    @Override
    public Config provideNoKeyChild(String key) {
        Checks.checkArgument((!this.children.containsKey(key) ? 1 : 0) != 0, (String)"Children already contain key '%s'", (Object[])new Object[]{key});
        return new EffectiveConfig(Config.concatPath(this.path, key), this.config.provideNoKeyChild(key), this.callsRegistry);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public boolean equals(Object obj) {
        return this.config.equals(obj);
    }

    public String toString() {
        return this.config.toString();
    }

    public void saveEffectiveConfigTo(Path outputPath) {
        try {
            String renderedConfig = this.renderEffectiveConfig();
            Files.write(outputPath, renderedConfig.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize effective config as properties file", e);
        }
    }

    public synchronized String renderEffectiveConfig() {
        CallsRegistry register = this.callsRegistry;
        StringBuilder sb = new StringBuilder();
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(register.calls.keySet());
        keys.addAll(register.all.keySet());
        String lastKey = "";
        for (String key : keys) {
            if (!lastKey.isEmpty() && EffectiveConfig.commonDots(lastKey, key) == 0) {
                sb.append("\n");
            }
            lastKey = key;
            String used = register.calls.get(key);
            String value = register.all.get(key);
            String defaultValue = register.defaultCalls.get(key);
            if (!register.calls.containsKey(key)) {
                sb.append("## ");
                EffectiveConfig.writeProperty(sb, key, value);
                continue;
            }
            if (Objects.equals(used, defaultValue)) {
                sb.append("# ");
            }
            EffectiveConfig.writeProperty(sb, key, Objects.toString(used, ""));
        }
        return sb.toString();
    }

    private static int commonDots(String key1, String key2) {
        int commonDots = 0;
        for (int i = 0; i < Math.min(key1.length(), key2.length()) && key2.charAt(i) == key1.charAt(i); ++i) {
            if (key2.charAt(i) != '.') continue;
            ++commonDots;
        }
        return commonDots;
    }

    private static void writeProperty(StringBuilder sb, String key, String value) {
        sb.append(EffectiveConfig.encodeForPropertiesFile(key, true));
        sb.append(" = ");
        sb.append(EffectiveConfig.encodeForPropertiesFile(value, false));
        sb.append("\n");
    }

    private static String encodeForPropertiesFile(String string, boolean escapeKey) {
        StringBuilder sb = new StringBuilder(string.length() * 2);
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case ' ': {
                    if (i == 0 || escapeKey) {
                        sb.append('\\');
                    }
                    sb.append(' ');
                    continue block9;
                }
                case '\t': {
                    sb.append('\\');
                    sb.append('t');
                    continue block9;
                }
                case '\n': {
                    sb.append('\\');
                    sb.append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\');
                    sb.append('r');
                    continue block9;
                }
                case '\f': {
                    sb.append('\\');
                    sb.append('f');
                    continue block9;
                }
                case ':': 
                case '=': {
                    if (escapeKey) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '!': 
                case '#': {
                    if (escapeKey && i == 0) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public Map<String, String> getEffectiveDefaults() {
        return this.callsRegistry.defaultCalls;
    }

    public Map<String, String> getEffectiveCalls() {
        return this.callsRegistry.calls;
    }

    private static final class CallsRegistry {
        final Map<String, String> calls = new HashMap<String, String>();
        final Map<String, String> defaultCalls = new HashMap<String, String>();
        final Map<String, String> all;

        CallsRegistry(Map<String, String> all) {
            this.all = all;
        }

        void registerCall(String path, String value) {
            this.calls.put(path, value);
        }

        void registerDefaultCall(String path, String value, String defaultValue) {
            this.calls.put(path, value);
            this.defaultCalls.put(path, defaultValue);
        }
    }
}

