/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.discovery.client.CachingServiceSelector;
import io.airlift.discovery.client.ServiceDescriptors;
import io.airlift.discovery.client.ServiceSelector;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;

@Beta
public class ServiceSelectorManager {
    private final Set<ServiceSelector> serviceSelectors;

    @Inject
    public ServiceSelectorManager(Set<ServiceSelector> serviceSelectors) {
        Preconditions.checkNotNull(serviceSelectors, (Object)"serviceSelectors is null");
        this.serviceSelectors = ImmutableSet.copyOf(serviceSelectors);
    }

    public Set<ServiceSelector> getServiceSelectors() {
        return this.serviceSelectors;
    }

    public void forceRefresh() {
        for (ListenableFuture<ServiceDescriptors> future : this.initiateRefresh()) {
            Futures.getUnchecked(future);
        }
    }

    public void attemptRefresh() {
        try {
            Futures.successfulAsList(this.initiateRefresh()).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private List<ListenableFuture<ServiceDescriptors>> initiateRefresh() {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (ServiceSelector selector : this.serviceSelectors) {
            if (!(selector instanceof CachingServiceSelector)) continue;
            futures.add(((CachingServiceSelector)selector).refresh());
        }
        return futures.build();
    }
}

