/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.inject.ConfigurationException;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import io.airlift.jmx.GuiceInjectorIterator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class GuiceDependencyIterator
implements Iterator<Class<?>>,
Iterable<Class<?>> {
    private final Set<Key<?>> visited;
    private final Iterator<Dependency<?>> currentDependencyIterator;
    private final TypeLiteral<?> creationTypeLiteral;
    private final Class<?> creationClass;
    private Class<?> currentClass = null;

    public GuiceDependencyIterator(TypeLiteral<?> typeLiteral) {
        this(null, typeLiteral, new HashSet());
    }

    public GuiceDependencyIterator(Class<?> clazz) {
        this(clazz, null, new HashSet());
    }

    public boolean hasInjectionPoint() {
        return this.currentDependencyIterator != null;
    }

    public GuiceDependencyIterator substituteVisitedSet(Set<Key<?>> visited) {
        return new GuiceDependencyIterator(this.creationClass, this.creationTypeLiteral, visited);
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new GuiceDependencyIterator(this.creationClass, this.creationTypeLiteral, this.visited);
    }

    @Override
    public boolean hasNext() {
        if (this.currentDependencyIterator != null) {
            while (this.currentClass == null && this.currentDependencyIterator.hasNext()) {
                this.currentClass = GuiceInjectorIterator.parseKey(this.visited, this.currentDependencyIterator.next().getKey());
            }
        }
        return this.currentClass != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class<?> localClass = this.currentClass;
        this.currentClass = null;
        return localClass;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private GuiceDependencyIterator(Class<?> clazz, TypeLiteral<?> typeLiteral, Set<Key<?>> visited) {
        this.creationClass = clazz;
        this.creationTypeLiteral = typeLiteral;
        this.visited = visited;
        this.currentDependencyIterator = this.initInjectionPoint();
    }

    private Iterator<Dependency<?>> initInjectionPoint() {
        try {
            InjectionPoint injectionPoint = this.creationTypeLiteral != null ? InjectionPoint.forConstructorOf(this.creationTypeLiteral) : InjectionPoint.forConstructorOf(this.creationClass);
            return injectionPoint.getDependencies().iterator();
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

