/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.YAMLException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationParsingException;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.ConfigurationValidationException;
import io.dropwizard.configuration.FileConfigurationSourceProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.Validator;

public class ConfigurationFactory<T> {
    private final Class<T> klass;
    private final String propertyPrefix;
    private final ObjectMapper mapper;
    private final Validator validator;
    private final YAMLFactory yamlFactory;

    public ConfigurationFactory(Class<T> klass, Validator validator, ObjectMapper objectMapper, String propertyPrefix) {
        this.klass = klass;
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + '.';
        this.mapper = objectMapper.copy();
        this.mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.validator = validator;
        this.yamlFactory = new YAMLFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T build(ConfigurationSourceProvider provider, String path) throws IOException, ConfigurationException {
        try (InputStream input = provider.open((String)Preconditions.checkNotNull((Object)path));){
            JsonNode node = (JsonNode)this.mapper.readTree((JsonParser)this.yamlFactory.createParser(input));
            T t = this.build(node, path);
            return t;
        }
        catch (YAMLException e) {
            ConfigurationParsingException.Builder builder = ConfigurationParsingException.builder("Malformed YAML").setCause((Exception)((Object)e)).setDetail(e.getMessage());
            if (!(e instanceof MarkedYAMLException)) throw builder.build(path);
            builder.setLocation(((MarkedYAMLException)e).getProblemMark());
            throw builder.build(path);
        }
    }

    public T build(File file) throws IOException, ConfigurationException {
        return this.build(new FileConfigurationSourceProvider(), file.toString());
    }

    public T build() throws IOException, ConfigurationException {
        return this.build((JsonNode)JsonNodeFactory.instance.objectNode(), "default configuration");
    }

    private T build(JsonNode node, String path) throws IOException, ConfigurationException {
        for (Map.Entry<Object, Object> pref : System.getProperties().entrySet()) {
            String prefName = (String)pref.getKey();
            if (!prefName.startsWith(this.propertyPrefix)) continue;
            String configName = prefName.substring(this.propertyPrefix.length());
            this.addOverride(node, configName, System.getProperty(prefName));
        }
        try {
            Object config = this.mapper.readValue((JsonParser)new TreeTraversingParser(node), this.klass);
            this.validate(path, config);
            return (T)config;
        }
        catch (UnrecognizedPropertyException e) {
            Collection knownProperties = e.getKnownPropertyIds();
            ArrayList<String> properties = new ArrayList<String>(knownProperties.size());
            for (Object property : knownProperties) {
                properties.add(property.toString());
            }
            throw ConfigurationParsingException.builder("Unrecognized field").setFieldPath(e.getPath()).setLocation(e.getLocation()).addSuggestions(properties).setSuggestionBase(e.getPropertyName()).setCause((Exception)((Object)e)).build(path);
        }
        catch (InvalidFormatException e) {
            String sourceType = e.getValue().getClass().getSimpleName();
            String targetType = e.getTargetType().getSimpleName();
            throw ConfigurationParsingException.builder("Incorrect type of value").setDetail("is of type: " + sourceType + ", expected: " + targetType).setLocation(e.getLocation()).setFieldPath(e.getPath()).setCause((Exception)((Object)e)).build(path);
        }
        catch (JsonMappingException e) {
            throw ConfigurationParsingException.builder("Failed to parse configuration").setDetail(e.getMessage()).setFieldPath(e.getPath()).setLocation(e.getLocation()).setCause((Exception)((Object)e)).build(path);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addOverride(JsonNode root, String name, String value) {
        JsonNode node = root;
        Iterable split = Splitter.on((char)'.').trimResults().split((CharSequence)name);
        String[] parts = (String[])Iterables.toArray((Iterable)split, String.class);
        int i = 0;
        while (i < parts.length) {
            JsonNode child;
            boolean moreParts;
            String key = parts[i];
            if (!(node instanceof ObjectNode)) {
                throw new IllegalArgumentException("Unable to override " + name + "; it's not a valid path.");
            }
            ObjectNode obj = (ObjectNode)node;
            String remainingPath = Joiner.on((char)'.').join((Object[])Arrays.copyOfRange(parts, i, parts.length));
            if (obj.has(remainingPath) && !remainingPath.equals(key) && obj.get(remainingPath).isValueNode()) {
                obj.put(remainingPath, value);
                return;
            }
            boolean bl = moreParts = i < parts.length - 1;
            if (key.matches(".+\\[\\d+\\]$")) {
                int s = key.indexOf(91);
                int index = Integer.parseInt(key.substring(s + 1, key.length() - 1));
                child = obj.get(key = key.substring(0, s));
                if (child == null) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index not found.");
                }
                if (!child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; node with index is not an array.");
                }
                if (index >= child.size()) {
                    throw new ArrayIndexOutOfBoundsException("Unable to override " + name + "; index is greater than size of array.");
                }
                if (!moreParts) {
                    ArrayNode array = (ArrayNode)child;
                    array.set(index, (JsonNode)TextNode.valueOf((String)value));
                    return;
                }
                node = child = child.get(index);
            } else if (moreParts) {
                child = obj.get(key);
                if (child == null) {
                    child = obj.objectNode();
                    obj.set(key, child);
                }
                if (child.isArray()) {
                    throw new IllegalArgumentException("Unable to override " + name + "; target is an array but no index specified");
                }
                node = child;
            }
            if (!moreParts) {
                if (node.get(key) != null && node.get(key).isArray()) {
                    ArrayNode arrayNode = (ArrayNode)obj.get(key);
                    arrayNode.removeAll();
                    Pattern escapedComma = Pattern.compile("\\\\,");
                    for (String val : Splitter.on((Pattern)Pattern.compile("(?<!\\\\),")).trimResults().split((CharSequence)value)) {
                        arrayNode.add(escapedComma.matcher(val).replaceAll(","));
                    }
                } else {
                    obj.put(key, value);
                }
            }
            ++i;
        }
        return;
    }

    private void validate(String path, T config) throws ConfigurationValidationException {
        Set violations = this.validator.validate(config, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConfigurationValidationException(path, violations);
        }
    }
}

