/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.ContextualRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

class ListContextualRegistry
implements ContextualRegistry {
    private final ContextualRegistry parent;
    private final ConcurrentHashMap<Object, ClassifiedRegistry> classifiers = new ConcurrentHashMap();
    private final ClassifiedRegistry registry = new ClassifiedRegistry();

    ListContextualRegistry(ContextualRegistry parent) {
        this.parent = parent;
    }

    ListContextualRegistry() {
        this(null);
    }

    @Override
    public <T> void register(T instance) {
        this.registry.register(instance);
    }

    @Override
    public <T> void supply(Class<T> type, Supplier<T> supplier) {
        this.registry.supply(type, supplier);
    }

    @Override
    public <T> Optional<T> get(Class<T> type) {
        T result = this.registry.get(type);
        if (result == null) {
            if (this.parent == null) {
                return Optional.empty();
            }
            return this.parent.get(type);
        }
        return Optional.of(result);
    }

    @Override
    public <T> void register(Object classifier, T instance) {
        Objects.requireNonNull(classifier, "Parameter 'classifier' is null!");
        ClassifiedRegistry cr = this.classifiers.computeIfAbsent(classifier, k -> new ClassifiedRegistry());
        cr.register(instance);
    }

    @Override
    public <T> void supply(Object classifier, Class<T> type, Supplier<T> supplier) {
        Objects.requireNonNull(classifier, "Parameter 'classifier' is null!");
        ClassifiedRegistry cr = this.classifiers.computeIfAbsent(classifier, k -> new ClassifiedRegistry());
        cr.supply(type, supplier);
    }

    @Override
    public <T> Optional<T> get(Object classifier, Class<T> type) {
        Objects.requireNonNull(classifier, "Parameter 'classifier' is null!");
        ClassifiedRegistry cr = this.classifiers.get(classifier);
        if (cr != null) {
            T result = cr.get(type);
            if (result == null && this.parent != null) {
                return this.parent.get(classifier, type);
            }
            return Optional.ofNullable(result);
        }
        if (this.parent != null) {
            return this.parent.get(classifier, type);
        }
        return Optional.empty();
    }

    private static class RegisteredInstance<T>
    implements RegisteredItem<T> {
        private final T instance;

        RegisteredInstance(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        @Override
        public Class<T> getType() {
            return this.instance.getClass();
        }
    }

    private static class RegisteredSupplier<T>
    implements RegisteredItem<T> {
        private final Class<T> type;
        private final Supplier<T> supplier;
        private volatile boolean supplied = false;
        private volatile T instance;

        RegisteredSupplier(Class<T> type, Supplier<T> supplier) {
            this.type = type;
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.supplied) {
                RegisteredSupplier registeredSupplier = this;
                synchronized (registeredSupplier) {
                    if (!this.supplied) {
                        this.supplied = true;
                        this.instance = this.supplier.get();
                    }
                }
            }
            return this.instance;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }
    }

    private static class ClassifiedRegistry {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final List<RegisteredItem> content = new ArrayList<RegisteredItem>();

        private ClassifiedRegistry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerItem(RegisteredItem item) {
            Lock l = this.lock.writeLock();
            try {
                Class c = item.getType();
                l.lock();
                for (int i = 0; i < this.content.size(); ++i) {
                    RegisteredItem reg = this.content.get(i);
                    if (c != reg.getType()) continue;
                    this.content.remove(i);
                    break;
                }
                this.content.add(item);
            }
            finally {
                l.unlock();
            }
        }

        <T> void register(T instance) {
            Objects.requireNonNull(instance, "Parameter 'instance' is null!");
            this.registerItem(new RegisteredInstance<T>(instance));
        }

        <T> void supply(Class<T> type, Supplier<T> supplier) {
            Objects.requireNonNull(type, "Parameter 'type' is null!");
            Objects.requireNonNull(supplier, "Parameter 'supplier' is null!");
            this.registerItem(new RegisteredSupplier<T>(type, supplier));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T get(Class<T> type) {
            Objects.requireNonNull(type, "Parameter 'type' is null!");
            Lock l = this.lock.readLock();
            try {
                l.lock();
                for (int i = this.content.size() - 1; i >= 0; --i) {
                    RegisteredItem item = this.content.get(i);
                    if (!type.isAssignableFrom(item.getType())) continue;
                    T t = type.cast(item.get());
                    return t;
                }
            }
            finally {
                l.unlock();
            }
            return null;
        }
    }

    private static interface RegisteredItem<T> {
        public T get();

        public Class<T> getType();
    }
}

