/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.AcceptPredicate;
import io.helidon.common.http.Ascii;
import io.helidon.common.http.CharMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MediaType
implements AcceptPredicate<MediaType> {
    private static final Map<MediaType, MediaType> KNOWN_TYPES = new HashMap<MediaType, MediaType>();
    public static final String CHARSET_PARAMETER = "charset";
    public static final MediaType WILDCARD = MediaType.createMediaType();
    public static final MediaType APPLICATION_XML = MediaType.createMediaType("application", "xml");
    public static final MediaType APPLICATION_ATOM_XML = MediaType.createMediaType("application", "atom+xml");
    public static final MediaType APPLICATION_XHTML_XML = MediaType.createMediaType("application", "xhtml+xml");
    public static final MediaType APPLICATION_SVG_XML = MediaType.createMediaType("application", "svg+xml");
    public static final MediaType APPLICATION_JSON = MediaType.createMediaType("application", "json");
    public static final MediaType APPLICATION_FORM_URLENCODED = MediaType.createMediaType("application", "x-www-form-urlencoded");
    public static final MediaType MULTIPART_FORM_DATA = MediaType.createMediaType("multipart", "form-data");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.createMediaType("application", "octet-stream");
    public static final MediaType TEXT_PLAIN = MediaType.createMediaType("text", "plain");
    public static final MediaType TEXT_XML = MediaType.createMediaType("text", "xml");
    public static final MediaType TEXT_HTML = MediaType.createMediaType("text", "html");
    private static final MediaType APPLICATION_JAVASCRIPT = MediaType.createMediaType("application", "javascript");
    public static final Predicate<MediaType> XML_PREDICATE = APPLICATION_XML.or(TEXT_XML).or(mt -> mt.hasSuffix("xml"));
    public static final Predicate<MediaType> JSON_PREDICATE = APPLICATION_JSON.or(APPLICATION_JAVASCRIPT).or(mt -> mt.hasSuffix("json"));
    private static final CharMatcher TOKEN_MATCHER = CharMatcher.ascii().and(CharMatcher.javaIsoControl().negate()).and(CharMatcher.isNot(' ')).and(CharMatcher.noneOf("()<>@,;:\\\"/[]?="));
    private static final CharMatcher QUOTED_TEXT_MATCHER = CharMatcher.ascii().and(CharMatcher.noneOf("\"\\\r"));
    private static final CharMatcher LINEAR_WHITE_SPACE = CharMatcher.anyOf(" \t\r\n");
    private static final String CHARSET_ATTRIBUTE = "charset";
    private String type;
    private String subtype;
    private Map<String, String> parameters;

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this(type, subtype, null, MediaType.createParametersMap(parameters));
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null, null);
    }

    public MediaType(String type, String subtype, String charset) {
        this(type, subtype, charset, null);
    }

    public MediaType() {
        this("*", "*", null, null);
    }

    private MediaType(String type, String subtype, String charset, Map<String, String> parameterMap) {
        this.type = type == null ? "*" : type;
        String string = this.subtype = subtype == null ? "*" : subtype;
        if (parameterMap == null) {
            parameterMap = new TreeMap<String, String>(String::compareToIgnoreCase);
        }
        if (charset != null && !charset.isEmpty()) {
            parameterMap.put("charset", charset);
        }
        this.parameters = Collections.unmodifiableMap(parameterMap);
    }

    private static MediaType createMediaType() {
        MediaType mediaType = new MediaType();
        KNOWN_TYPES.put(mediaType, mediaType);
        return mediaType;
    }

    private static MediaType createMediaType(String type, String subtype) {
        MediaType mediaType = new MediaType(type, subtype);
        KNOWN_TYPES.put(mediaType, mediaType);
        return mediaType;
    }

    private static TreeMap<String, String> createParametersMap(Map<String, String> initialValues) {
        TreeMap<String, String> map = new TreeMap<String, String>(String::compareToIgnoreCase);
        if (initialValues != null) {
            for (Map.Entry<String, String> e : initialValues.entrySet()) {
                map.put(e.getKey().toLowerCase(), e.getValue());
            }
        }
        return map;
    }

    public static MediaType parse(String input) {
        Objects.requireNonNull(input, "Parameter 'input' is null!");
        Tokenizer tokenizer = new Tokenizer(input);
        try {
            String type = tokenizer.consumeToken(TOKEN_MATCHER);
            tokenizer.consumeCharacter('/');
            String subtype = tokenizer.consumeToken(TOKEN_MATCHER);
            HashMap<String, String> parameters = new HashMap<String, String>();
            while (tokenizer.hasMore()) {
                String value;
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                tokenizer.consumeCharacter(';');
                tokenizer.consumeTokenIfPresent(LINEAR_WHITE_SPACE);
                String attribute = tokenizer.consumeToken(TOKEN_MATCHER);
                tokenizer.consumeCharacter('=');
                if ('\"' == tokenizer.previewChar()) {
                    tokenizer.consumeCharacter('\"');
                    StringBuilder valueBuilder = new StringBuilder();
                    while ('\"' != tokenizer.previewChar()) {
                        if ('\\' == tokenizer.previewChar()) {
                            tokenizer.consumeCharacter('\\');
                            valueBuilder.append(tokenizer.consumeCharacter(CharMatcher.ascii()));
                            continue;
                        }
                        valueBuilder.append(tokenizer.consumeToken(QUOTED_TEXT_MATCHER));
                    }
                    value = valueBuilder.toString();
                    tokenizer.consumeCharacter('\"');
                } else {
                    value = tokenizer.consumeToken(TOKEN_MATCHER);
                }
                parameters.put(attribute, value);
            }
            return MediaType.create(type, subtype, parameters);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Could not parse '" + input + "'", e);
        }
    }

    static void checkState(boolean expression, String message) {
        MediaType.checkState(expression, () -> message);
    }

    static void checkState(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(messageSupplier.get());
        }
    }

    private static MediaType create(String type, String subtype, Map<String, String> parameters) {
        Objects.requireNonNull(type, "Parameter 'type' is null!");
        Objects.requireNonNull(subtype, "Parameter 'subtype' is null!");
        Objects.requireNonNull(parameters, "Parameter 'parameters' is null!");
        String normalizedType = MediaType.normalizeToken(type);
        String normalizedSubtype = MediaType.normalizeToken(subtype);
        MediaType.checkState(!MediaType.WILDCARD.type.equals(normalizedType) || MediaType.WILDCARD.type.equals(normalizedSubtype), "A wildcard type cannot be used with a non-wildcard subtype");
        HashMap<String, String> builder = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String attribute = MediaType.normalizeToken(entry.getKey());
            builder.put(attribute, MediaType.normalizeParameterValue(attribute, entry.getValue()));
        }
        MediaType mediaType = new MediaType(normalizedType, normalizedSubtype, builder);
        return Optional.ofNullable(KNOWN_TYPES.get(mediaType)).orElse(mediaType);
    }

    private static String normalizeToken(String token) {
        MediaType.checkState(TOKEN_MATCHER.matchesAllOf(token), () -> String.format("Parameter '%s' doesn't match token matcher: %s", token, TOKEN_MATCHER));
        return Ascii.toLowerCase(token);
    }

    private static String normalizeParameterValue(String attribute, String value) {
        return "charset".equals(attribute) ? Ascii.toLowerCase(value) : value;
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals("*");
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals("*");
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MediaType withCharset(String charset) {
        return new MediaType(this.type, this.subtype, charset, MediaType.createParametersMap(this.parameters));
    }

    public Optional<String> getCharset() {
        return Optional.ofNullable(this.parameters.get("charset"));
    }

    @Override
    public double qualityFactor() {
        String q = this.parameters.get("q");
        return q == null ? 1.0 : Double.valueOf(q);
    }

    @Override
    public boolean test(MediaType other) {
        return other != null && (this.type.equals("*") || other.type.equals("*") || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals("*") || other.subtype.equals("*")) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type).append('/').append(this.subtype);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result.append(';').append(entry.getKey()).append('=').append(entry.getValue());
        }
        return result.toString();
    }

    public boolean hasSuffix(String suffix) {
        if (suffix != null && !suffix.isEmpty()) {
            if (suffix.charAt(0) != '+') {
                suffix = "+" + suffix;
            }
            return this.subtype.endsWith(suffix);
        }
        return this.subtype.indexOf(43) >= 0;
    }

    private static final class Tokenizer {
        final String input;
        int position = 0;

        Tokenizer(String input) {
            this.input = input;
        }

        String consumeTokenIfPresent(CharMatcher matcher) {
            MediaType.checkState(this.hasMore(), "No more elements!");
            int startPosition = this.position;
            this.position = matcher.negate().indexIn(this.input, startPosition);
            return this.hasMore() ? this.input.substring(startPosition, this.position) : this.input.substring(startPosition);
        }

        String consumeToken(CharMatcher matcher) {
            int startPosition = this.position;
            String token = this.consumeTokenIfPresent(matcher);
            MediaType.checkState(this.position != startPosition, () -> String.format("Position '%d' should not be '%d'!", this.position, startPosition));
            return token;
        }

        char consumeCharacter(CharMatcher matcher) {
            MediaType.checkState(this.hasMore(), "No more elements!");
            char c = this.previewChar();
            MediaType.checkState(matcher.matches(c), "Unexpected character matched: " + c);
            ++this.position;
            return c;
        }

        char consumeCharacter(char c) {
            MediaType.checkState(this.hasMore(), "No more elements!");
            MediaType.checkState(this.previewChar() == c, () -> "Unexpected character: " + c);
            ++this.position;
            return c;
        }

        char previewChar() {
            MediaType.checkState(this.hasMore(), "No more elements!");
            return this.input.charAt(this.position);
        }

        boolean hasMore() {
            return this.position >= 0 && this.position < this.input.length();
        }
    }
}

