/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.GenericConfigMapper;
import io.helidon.config.GenericConfigMapperUtils;
import io.helidon.config.MissingValueException;
import java.lang.invoke.MethodHandle;
import java.util.Collection;

class BuilderConfigMapper<T>
implements ConfigMapper<T> {
    private final Class<T> type;
    private final BuilderAccessor<T> builderAccessor;

    BuilderConfigMapper(Class<T> type, BuilderAccessor<T> builderAccessor) {
        this.type = type;
        this.builderAccessor = builderAccessor;
    }

    @Override
    public T apply(Config config) throws ConfigMappingException, MissingValueException {
        return this.builderAccessor.create(config);
    }

    static class BuilderAccessor<T> {
        private final Class<?> builderType;
        private final MethodHandle builderHandler;
        private final Class<T> buildType;
        private final MethodHandle buildHandler;
        private final Collection<GenericConfigMapper.PropertyAccessor> builderAccessors;

        BuilderAccessor(ConfigMapperManager mapperManager, Class<?> builderType, MethodHandle builderHandler, Class<T> buildType, MethodHandle buildHandler) {
            this.builderType = builderType;
            this.builderHandler = builderHandler;
            this.buildType = buildType;
            this.buildHandler = buildHandler;
            this.builderAccessors = GenericConfigMapperUtils.getBeanProperties(mapperManager, builderType);
        }

        public T create(Config config) {
            try {
                Object builder = this.builderType.cast(this.builderHandler.invoke());
                for (GenericConfigMapper.PropertyAccessor builderAccessor : this.builderAccessors) {
                    builderAccessor.set(builder, config.get(builderAccessor.getName()));
                }
                return this.buildType.cast(this.buildHandler.invoke(builder));
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.buildType, "Builder java bean initialization has failed with an exception.", ex);
            }
        }
    }
}

