/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigSources;
import io.helidon.config.OverrideSources;
import io.helidon.config.ProviderImpl;
import io.helidon.config.UseFirstAvailableConfigSource;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class BuilderImpl
implements Config.Builder {
    static final Executor DEFAULT_CHANGES_EXECUTOR = Executors.newCachedThreadPool(new ConfigThreadFactory("config"));
    private List<ConfigSource> sources = null;
    private final Map<Class<?>, ConfigMapper<?>> mappers;
    private boolean mapperServicesEnabled = true;
    private List<ConfigParser> parsers;
    private boolean parserServicesEnabled = true;
    private List<Function<Config, ConfigFilter>> filterProviders;
    private boolean filterServicesEnabled = true;
    private boolean cachingEnabled = true;
    private Executor changesExecutor;
    private int changesMaxBuffer;
    private boolean keyResolving = true;
    private boolean systemPropertiesSourceEnabled = true;
    private boolean environmentVariablesSourceEnabled = true;
    private OverrideSource overrideSource = OverrideSources.empty();

    BuilderImpl() {
        this.mappers = new HashMap();
        this.parsers = new ArrayList<ConfigParser>();
        this.filterProviders = new ArrayList<Function<Config, ConfigFilter>>();
        this.changesExecutor = DEFAULT_CHANGES_EXECUTOR;
        this.changesMaxBuffer = Flow.defaultBufferSize();
    }

    @Override
    public Config.Builder sources(List<Supplier<ConfigSource>> sourceSuppliers) {
        this.sources = new ArrayList<ConfigSource>(sourceSuppliers.size());
        sourceSuppliers.stream().map(Supplier::get).forEach(this.sources::add);
        return this;
    }

    @Override
    public Config.Builder overrides(Supplier<OverrideSource> overridingSource) {
        this.overrideSource = overridingSource.get();
        return this;
    }

    @Override
    public Config.Builder disableMapperServices() {
        this.mapperServicesEnabled = false;
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(Class<T> type, ConfigMapper<T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        this.mappers.put(type, mapper);
        return this;
    }

    @Override
    public <T> Config.Builder addMapper(Class<T> type, Function<String, T> mapper) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(mapper);
        this.mappers.put(type, ConfigMappers.wrap(mapper));
        return this;
    }

    @Override
    public Config.Builder addMapper(ConfigMapperProvider mapperProvider) {
        Objects.requireNonNull(mapperProvider);
        mapperProvider.getMappers().forEach(this.mappers::put);
        return this;
    }

    @Override
    public Config.Builder addParser(ConfigParser configParser) {
        Objects.requireNonNull(configParser);
        this.parsers.add(configParser);
        return this;
    }

    @Override
    public Config.Builder disableParserServices() {
        this.parserServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder addFilter(ConfigFilter configFilter) {
        Objects.requireNonNull(configFilter);
        this.filterProviders.add(config -> configFilter);
        return this;
    }

    @Override
    public Config.Builder addFilter(Function<Config, ConfigFilter> configFilterProvider) {
        Objects.requireNonNull(configFilterProvider);
        this.filterProviders.add(configFilterProvider);
        return this;
    }

    @Override
    public Config.Builder addFilter(Supplier<Function<Config, ConfigFilter>> configFilterSupplier) {
        Objects.requireNonNull(configFilterSupplier);
        this.filterProviders.add(configFilterSupplier.get());
        return this;
    }

    @Override
    public Config.Builder disableFilterServices() {
        this.filterServicesEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableCaching() {
        this.cachingEnabled = false;
        return this;
    }

    @Override
    public Config.Builder changesExecutor(Executor changesExecutor) {
        Objects.requireNonNull(changesExecutor);
        this.changesExecutor = changesExecutor;
        return this;
    }

    @Override
    public Config.Builder changesMaxBuffer(int changesMaxBuffer) {
        this.changesMaxBuffer = changesMaxBuffer;
        return this;
    }

    @Override
    public Config.Builder disableKeyResolving() {
        this.keyResolving = false;
        return this;
    }

    @Override
    public Config.Builder disableValueResolving() {
        return this;
    }

    @Override
    public Config.Builder disableEnvironmentVariablesSource() {
        this.environmentVariablesSourceEnabled = false;
        return this;
    }

    @Override
    public Config.Builder disableSystemPropertiesSource() {
        this.systemPropertiesSourceEnabled = false;
        return this;
    }

    @Override
    public Config build() {
        return this.buildProvider().newConfig();
    }

    private ProviderImpl buildProvider() {
        ConfigContextImpl context = new ConfigContextImpl(BuilderImpl.buildParsers(this.parserServicesEnabled, this.parsers));
        ConfigSource targetConfigSource = this.targetConfigSource(context);
        ConfigMapperManager configMapperManager = BuilderImpl.buildMappers(this.mapperServicesEnabled, this.mappers);
        if (this.filterServicesEnabled) {
            this.addAutoLoadedFilters();
        }
        return this.createProvider(configMapperManager, targetConfigSource, this.overrideSource, this.filterProviders, this.cachingEnabled, this.changesExecutor, this.changesMaxBuffer, this.keyResolving);
    }

    private ConfigSource targetConfigSource(ConfigContext context) {
        LinkedList<ConfigSource> targetSources = new LinkedList<ConfigSource>();
        if (this.environmentVariablesSourceEnabled) {
            targetSources.add(ConfigSources.environmentVariables());
        }
        if (this.systemPropertiesSourceEnabled) {
            targetSources.add(ConfigSources.systemProperties());
        }
        if (this.sources != null) {
            targetSources.addAll(this.sources);
        } else {
            targetSources.add(BuilderImpl.defaultConfigSource());
        }
        ConfigSource targetConfigSource = targetSources.size() == 1 ? (ConfigSource)targetSources.get(0) : ConfigSources.from(targetSources.toArray(new ConfigSource[0])).build();
        targetConfigSource.init(context);
        return targetConfigSource;
    }

    ProviderImpl createProvider(ConfigMapperManager configMapperManager, ConfigSource targetConfigSource, OverrideSource overrideSource, List<Function<Config, ConfigFilter>> filterProviders, boolean cachingEnabled, Executor changesExecutor, int changesMaxBuffer, boolean keyResolving) {
        return new ProviderImpl(configMapperManager, targetConfigSource, overrideSource, filterProviders, cachingEnabled, changesExecutor, changesMaxBuffer, keyResolving);
    }

    static ConfigSource defaultConfigSource() {
        return ConfigSources.from(new UseFirstAvailableConfigSource(ConfigSources.load(new UseFirstAvailableConfigSource((ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("meta-config.yaml").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("meta-config.conf").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("meta-config.json").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("meta-config.properties").optional()).build())).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("application.yaml").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("application.conf").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("application.json").optional()).build(), (ConfigSource)((AbstractParsableConfigSource.Builder)ConfigSources.classpath("application.properties").optional()).build())).build();
    }

    static List<ConfigParser> buildParsers(boolean servicesEnabled, List<ConfigParser> userDefinedParsers) {
        LinkedList<ConfigParser> parsers = new LinkedList<ConfigParser>();
        parsers.addAll(userDefinedParsers);
        if (servicesEnabled) {
            parsers.addAll(BuilderImpl.loadParserServices());
        }
        return parsers;
    }

    static ConfigMapperManager buildMappers(boolean servicesEnabled, Map<Class<?>, ConfigMapper<?>> userDefinedMappers) {
        HashMap mappers = new HashMap();
        mappers.putAll(ConfigMappers.essentialMappers());
        mappers.putAll(ConfigMappers.builtInMappers());
        if (servicesEnabled) {
            mappers.putAll(BuilderImpl.loadMapperServices());
        }
        mappers.putAll(userDefinedMappers);
        return new ConfigMapperManager(mappers);
    }

    private static Map<Class<?>, ConfigMapper<?>> loadMapperServices() {
        HashMap loadedMappers = new HashMap();
        List<ConfigMapperProvider> loadedProviders = ConfigUtils.asPrioritizedStream(ServiceLoader.load(ConfigMapperProvider.class), 100).collect(Collectors.toList());
        Collections.reverse(loadedProviders);
        loadedProviders.forEach(provider -> loadedMappers.putAll(provider.getMappers()));
        return loadedMappers;
    }

    private static List<ConfigParser> loadParserServices() {
        return BuilderImpl.loadPrioritizedServices(ConfigParser.class, 100);
    }

    private void addAutoLoadedFilters() {
        ConfigUtils.asStream(ServiceLoader.load(ConfigFilter.class).iterator()).map(filter -> t -> filter).forEach(this::addFilter);
    }

    private static <T> List<T> loadPrioritizedServices(Class<T> serviceClass, int priority) {
        return ConfigUtils.asPrioritizedStream(ServiceLoader.load(serviceClass), priority).collect(Collectors.toList());
    }

    static final class EmptyConfigHolder {
        static final Config EMPTY = new BuilderImpl().sources(ConfigSources.empty()).overrides(OverrideSources.empty()).disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableMapperServices().disableParserServices().disableFilterServices().build();

        private EmptyConfigHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    static class ConfigContextImpl
    implements ConfigContext {
        private final List<ConfigParser> configParsers;

        ConfigContextImpl(List<ConfigParser> configParsers) {
            this.configParsers = configParsers;
        }

        @Override
        public Optional<ConfigParser> findParser(String mediaType) {
            if (mediaType == null) {
                throw new NullPointerException("Unknown media type of resource.");
            }
            return this.configParsers.stream().filter(parser -> parser.getSupportedMediaTypes().contains(mediaType)).findFirst();
        }
    }
}

