/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.SubmissionPublisher;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigSources;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.internal.ObjectNodeImpl;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.Source;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class CompositeConfigSource
implements ConfigSource {
    static final ScheduledExecutorService DEFAULT_CHANGES_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(0, new ConfigThreadFactory("composite-source"));
    private static final Logger LOGGER = Logger.getLogger(CompositeConfigSource.class.getName());
    private final Map<ConfigSource, Optional<ConfigNode.ObjectNode>> lastObjectNodes;
    private final ConfigSources.MergingStrategy mergingStrategy;
    private final String description;
    private final SubmissionPublisher<Optional<ConfigNode.ObjectNode>> changesSubmitter;
    private final Flow.Publisher<Optional<ConfigNode.ObjectNode>> changesPublisher;
    private final ConfigUtils.ScheduledTask reloadTask;
    private Optional<ConfigNode.ObjectNode> lastObjectNode;
    private List<ConfigSourceChangeEventSubscriber> compositeConfigSourcesSubscribers;

    CompositeConfigSource(List<ConfigSource> configSources, ConfigSources.MergingStrategy mergingStrategy, ScheduledExecutorService reloadExecutorService, Duration debounceTimeout, int changesMaxBuffer) {
        this.mergingStrategy = mergingStrategy;
        this.description = configSources.stream().map(Source::description).collect(Collectors.joining("->"));
        this.changesSubmitter = new SubmissionPublisher(Runnable::run, changesMaxBuffer);
        this.changesPublisher = ConfigHelper.suspendablePublisher(this.changesSubmitter, this::subscribeConfigSourceChangesSubscriptions, this::cancelConfigSourceChangesSubscriptions);
        this.lastObjectNodes = new LinkedHashMap<ConfigSource, Optional<ConfigNode.ObjectNode>>(configSources.size());
        configSources.forEach(source -> this.lastObjectNodes.put((ConfigSource)source, Optional.empty()));
        this.reloadTask = new ConfigUtils.ScheduledTask(reloadExecutorService, this::reload, debounceTimeout);
    }

    private void subscribeConfigSourceChangesSubscriptions() {
        this.compositeConfigSourcesSubscribers = new LinkedList<ConfigSourceChangeEventSubscriber>();
        for (ConfigSource source : this.lastObjectNodes.keySet()) {
            ConfigSourceChangeEventSubscriber subscriber = new ConfigSourceChangeEventSubscriber(source);
            source.changes().subscribe((Flow.Subscriber)subscriber);
            this.compositeConfigSourcesSubscribers.add(subscriber);
        }
    }

    private void cancelConfigSourceChangesSubscriptions() {
        this.compositeConfigSourcesSubscribers.forEach(rec$ -> ((ConfigSourceChangeEventSubscriber)rec$).cancelSubscription());
        this.compositeConfigSourcesSubscribers = null;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public void init(ConfigContext context) {
        for (ConfigSource configSource : this.lastObjectNodes.keySet()) {
            configSource.init(context);
        }
    }

    @Override
    public Optional<ConfigNode.ObjectNode> load() {
        for (ConfigSource configSource : this.lastObjectNodes.keySet()) {
            Optional<ConfigNode.ObjectNode> loadedNode = configSource.load().map(ObjectNodeImpl::wrap).map(objectNode -> objectNode.initDescription(configSource.description()));
            this.lastObjectNodes.put(configSource, loadedNode);
        }
        this.lastObjectNode = this.mergeLoaded();
        return this.lastObjectNode;
    }

    Optional<ConfigNode.ObjectNode> getLastObjectNode() {
        return this.lastObjectNode;
    }

    List<ConfigSourceChangeEventSubscriber> getCompositeConfigSourcesSubscribers() {
        return this.compositeConfigSourcesSubscribers;
    }

    private Optional<ConfigNode.ObjectNode> mergeLoaded() {
        List<ConfigNode.ObjectNode> rootNodes = this.lastObjectNodes.values().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (rootNodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.mergingStrategy.merge(rootNodes));
    }

    private void scheduleReload(ConfigSource source, Optional<ConfigNode.ObjectNode> changedObjectNode) {
        Optional<ConfigNode.ObjectNode> originalObjectNode = this.lastObjectNodes.get(source);
        if (!Objects.equals(originalObjectNode, changedObjectNode)) {
            this.lastObjectNodes.put(source, changedObjectNode);
            this.reloadTask.schedule();
        } else {
            LOGGER.log(Level.FINE, String.format("Source data has not changed. Will not try to reload from config source %s.", source.description()));
        }
    }

    private void reload() {
        try {
            Optional<ConfigNode.ObjectNode> newObjectNode = this.mergeLoaded();
            if (!Objects.equals(this.lastObjectNode, newObjectNode)) {
                LOGGER.log(Level.FINER, String.format("Config source %s has been reloaded.", this.description()));
                this.lastObjectNode = newObjectNode;
                this.fireChangeEvent();
            } else {
                LOGGER.log(Level.FINE, String.format("Source data has not changed. Will not try to reload from config source %s.", this.description()));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, String.format("Error merging of loaded config sources %s. New configuration has not been used. Maybe later.", this.description()));
            LOGGER.log(Level.CONFIG, String.format("Failing reload of '%s' cause.", this.description()), ex);
        }
    }

    private void fireChangeEvent() {
        this.changesSubmitter.offer(this.lastObjectNode, (subscriber, objectNode) -> {
            LOGGER.log(Level.FINER, String.format("Object node %s has not been delivered to %s.", objectNode, subscriber));
            return false;
        });
    }

    @Override
    public Flow.Publisher<Optional<ConfigNode.ObjectNode>> changes() {
        return this.changesPublisher;
    }

    private class ConfigSourceChangeEventSubscriber
    implements Flow.Subscriber<Optional<ConfigNode.ObjectNode>> {
        private final ConfigSource configSource;
        private Flow.Subscription subscription;

        private ConfigSourceChangeEventSubscriber(ConfigSource configSource) {
            this.configSource = configSource;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        public void onNext(Optional<ConfigNode.ObjectNode> objectNode) {
            LOGGER.fine(String.format("'%s' config source has changed: %s", this.configSource, objectNode));
            CompositeConfigSource.this.scheduleReload(this.configSource, objectNode);
            this.subscription.request(1L);
        }

        public void onError(Throwable throwable) {
            CompositeConfigSource.this.changesSubmitter.closeExceptionally((Throwable)new ConfigException(String.format("'%s' config source changes support has failed. %s", this.configSource.description(), throwable.getLocalizedMessage()), throwable));
        }

        public void onComplete() {
            LOGGER.fine(String.format("'%s' config source changes support has completed.", this.configSource.description()));
        }

        private void cancelSubscription() {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }
    }
}

