/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.OptionalHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.config.BuilderImpl;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigSources;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.OverrideSource;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Config {
    public static Config empty() {
        return BuilderImpl.EmptyConfigHolder.EMPTY;
    }

    public static Config create() {
        return Config.builder().build();
    }

    @SafeVarargs
    public static Config from(Supplier<ConfigSource> ... configSources) {
        return Config.withSources(configSources).build();
    }

    @SafeVarargs
    public static Config loadSourcesFrom(Supplier<ConfigSource> ... metaSources) {
        return Config.loadSources(metaSources).build();
    }

    @SafeVarargs
    public static Builder withSources(Supplier<ConfigSource> ... configSources) {
        return Config.builder().sources(CollectionsHelper.listOf((Object[])configSources));
    }

    @SafeVarargs
    public static Builder loadSources(Supplier<ConfigSource> ... metaSources) {
        return Config.withSources(ConfigSources.load(metaSources)).disableSystemPropertiesSource().disableEnvironmentVariablesSource();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    default public Context context() {
        return new Context(){

            @Override
            public Instant timestamp() {
                return Config.this.timestamp();
            }

            @Override
            public Config last() {
                return Config.this;
            }

            @Override
            public Config reload() {
                return Config.this;
            }
        };
    }

    public Instant timestamp();

    public Key key();

    default public String name() {
        return this.key().name();
    }

    default public Config get(String key) {
        Objects.requireNonNull(key, "Key argument is null.");
        return this.get(ConfigKeyImpl.of(key));
    }

    public Config get(Key var1);

    public Config detach();

    public Type type();

    default public boolean exists() {
        return this.type().exists();
    }

    default public boolean isLeaf() {
        return this.type().isLeaf();
    }

    public boolean hasValue();

    default public void ifExists(Consumer<Config> action) {
        this.node().ifPresent(action);
    }

    default public void ifExistsOrElse(Consumer<Config> action, Runnable missingAction) {
        OptionalHelper.from(this.node()).ifPresentOrElse(action, missingAction);
    }

    default public Stream<Config> traverse() {
        return this.traverse(node -> true);
    }

    public Stream<Config> traverse(Predicate<Config> var1);

    public Optional<String> value() throws ConfigMappingException;

    default public Optional<String> asOptionalString() throws ConfigMappingException {
        return this.value();
    }

    default public Supplier<Optional<String>> asOptionalStringSupplier() {
        return () -> this.context().last().asOptionalString();
    }

    default public Optional<Config> node() {
        if (this.exists()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    default public Supplier<Optional<Config>> nodeSupplier() {
        return () -> this.context().last().node();
    }

    public Optional<List<Config>> nodeList() throws ConfigMappingException;

    default public Optional<List<Config>> asOptionalNodeList() throws ConfigMappingException {
        return this.nodeList();
    }

    default public Supplier<Optional<List<Config>>> asOptionalNodeListSupplier() {
        return () -> this.context().last().asOptionalNodeList();
    }

    public Optional<Map<String, String>> asOptionalMap();

    default public Supplier<Optional<Map<String, String>>> asOptionalMapSupplier() {
        return () -> this.context().last().asOptionalMap();
    }

    public <T> Optional<T> asOptional(Class<? extends T> var1) throws ConfigMappingException;

    default public <T> Supplier<Optional<T>> asOptionalSupplier(Class<? extends T> type) {
        return () -> this.context().last().asOptional(type);
    }

    public <T> Optional<List<T>> asOptionalList(Class<? extends T> var1) throws ConfigMappingException;

    default public <T> Supplier<Optional<List<T>>> asOptionalListSupplier(Class<? extends T> type) {
        return () -> this.context().last().asOptionalList(type);
    }

    default public Optional<List<String>> asOptionalStringList() throws ConfigMappingException {
        return this.asOptionalList(String.class);
    }

    default public Supplier<Optional<List<String>>> asOptionalStringListSupplier() {
        return () -> this.context().last().asOptionalStringList();
    }

    default public <T> Optional<T> mapOptional(Function<String, ? extends T> mapper) throws ConfigMappingException {
        return this.mapOptional(ConfigMappers.wrap(mapper));
    }

    default public <T> Supplier<Optional<T>> mapOptionalSupplier(Function<String, ? extends T> mapper) {
        return () -> this.context().last().mapOptional(mapper);
    }

    default public <T> Optional<T> mapOptional(ConfigMapper<? extends T> mapper) throws ConfigMappingException {
        return this.type() == Type.MISSING ? Optional.empty() : Optional.of(mapper.apply(this));
    }

    default public <T> Supplier<Optional<T>> mapOptionalSupplier(ConfigMapper<? extends T> mapper) {
        return () -> this.context().last().mapOptional(mapper);
    }

    default public Optional<Boolean> asOptionalBoolean() throws ConfigMappingException {
        return this.asOptional(Boolean.class);
    }

    default public Supplier<Optional<Boolean>> asOptionalBooleanSupplier() {
        return () -> this.context().last().asOptionalBoolean();
    }

    default public OptionalInt asOptionalInt() throws ConfigMappingException {
        return this.asOptional(Integer.class).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public Supplier<OptionalInt> asOptionalIntSupplier() {
        return () -> this.context().last().asOptionalInt();
    }

    default public OptionalLong asOptionalLong() throws ConfigMappingException {
        return this.asOptional(Long.class).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public Supplier<OptionalLong> asOptionalLongSupplier() {
        return () -> this.context().last().asOptionalLong();
    }

    default public OptionalDouble asOptionalDouble() throws ConfigMappingException {
        return this.asOptional(Double.class).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    default public Supplier<OptionalDouble> asOptionalDoubleSupplier() {
        return () -> this.context().last().asOptionalDouble();
    }

    default public <T> Optional<List<T>> mapOptionalList(Function<String, ? extends T> mapper) throws ConfigMappingException {
        try {
            return this.asOptionalList(Config.class).map((? super T configList) -> configList.stream().map((? super T config) -> config.map(mapper)).collect(Collectors.toList()));
        }
        catch (MissingValueException ex) {
            throw new ConfigMappingException(this.key(), "Error to map list element from config node. " + ex.getLocalizedMessage(), ex);
        }
    }

    default public <T> Supplier<Optional<List<T>>> mapOptionalListSupplier(Function<String, ? extends T> mapper) {
        return () -> this.context().last().mapOptionalList(mapper);
    }

    default public <T> Optional<List<T>> mapOptionalList(ConfigMapper<? extends T> mapper) throws ConfigMappingException {
        try {
            return this.asOptionalList(Config.class).map((? super T configList) -> configList.stream().map(mapper::apply).collect(Collectors.toList()));
        }
        catch (MissingValueException ex) {
            throw new ConfigMappingException(this.key(), "Error to map list element from config node. " + ex.getLocalizedMessage(), ex);
        }
    }

    default public <T> Supplier<Optional<List<T>>> mapOptionalListSupplier(ConfigMapper<? extends T> mapper) {
        return () -> this.context().last().mapOptionalList(mapper);
    }

    default public <T> T as(Class<? extends T> type) throws MissingValueException, ConfigMappingException {
        return this.asOptional(type).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<T> asSupplier(Class<? extends T> type) {
        return () -> this.context().last().as(type);
    }

    default public <T> T as(Class<? extends T> type, T defaultValue) throws ConfigMappingException {
        return this.asOptional(type).orElse(defaultValue);
    }

    default public <T> Supplier<T> asSupplier(Class<T> type, T defaultValue) {
        return () -> this.context().last().asOptional(type).orElse(defaultValue);
    }

    default public <T> T map(Function<String, ? extends T> mapper) throws MissingValueException, ConfigMappingException {
        return this.mapOptional(mapper).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<T> mapSupplier(Function<String, ? extends T> mapper) {
        return () -> this.context().last().map(mapper);
    }

    default public <T> T map(ConfigMapper<? extends T> mapper) throws MissingValueException, ConfigMappingException {
        return this.mapOptional(mapper).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<T> mapSupplier(ConfigMapper<? extends T> mapper) {
        return () -> this.context().last().map(mapper);
    }

    default public <T> T map(Function<String, ? extends T> mapper, T defaultValue) throws ConfigMappingException {
        return this.mapOptional(mapper).orElse(defaultValue);
    }

    default public <T> Supplier<T> mapSupplier(Function<String, ? extends T> mapper, T defaultValue) {
        return () -> this.context().last().map(mapper, defaultValue);
    }

    default public <T> T map(ConfigMapper<? extends T> mapper, T defaultValue) throws ConfigMappingException {
        return this.mapOptional(mapper).orElse(defaultValue);
    }

    default public <T> Supplier<T> mapSupplier(ConfigMapper<? extends T> mapper, T defaultValue) {
        return () -> this.context().last().map(mapper, defaultValue);
    }

    default public <T> List<T> asList(Class<? extends T> type) throws MissingValueException, ConfigMappingException {
        return this.asOptionalList(type).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<List<T>> asListSupplier(Class<? extends T> type) {
        return () -> this.context().last().asList(type);
    }

    default public <T> List<T> asList(Class<? extends T> type, List<T> defaultValue) throws ConfigMappingException {
        return this.asOptionalList(type).orElse(defaultValue);
    }

    default public <T> Supplier<List<T>> asListSupplier(Class<? extends T> type, List<T> defaultValue) {
        return () -> this.context().last().asList(type, defaultValue);
    }

    default public <T> List<T> mapList(ConfigMapper<? extends T> mapper) throws MissingValueException, ConfigMappingException {
        return this.mapOptionalList(mapper).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<List<T>> mapListSupplier(ConfigMapper<? extends T> mapper) {
        return () -> this.context().last().mapList(mapper);
    }

    default public <T> List<T> mapList(ConfigMapper<? extends T> mapper, List<T> defaultValue) throws ConfigMappingException {
        return this.mapOptionalList(mapper).orElse(defaultValue);
    }

    default public <T> Supplier<List<T>> mapListSupplier(ConfigMapper<? extends T> mapper, List<T> defaultValue) {
        return () -> this.context().last().mapList(mapper, defaultValue);
    }

    default public <T> List<T> mapList(Function<String, ? extends T> mapper) throws MissingValueException, ConfigMappingException {
        return this.mapOptionalList(mapper).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public <T> Supplier<List<T>> mapListSupplier(Function<String, ? extends T> mapper) {
        return () -> this.context().last().mapList(mapper);
    }

    default public <T> List<T> mapList(Function<String, ? extends T> mapper, List<T> defaultValue) throws ConfigMappingException {
        return this.mapOptionalList(mapper).orElse(defaultValue);
    }

    default public <T> Supplier<List<T>> mapListSupplier(Function<String, ? extends T> mapper, List<T> defaultValue) {
        return () -> this.context().last().mapList(mapper, defaultValue);
    }

    default public String asString() throws MissingValueException, ConfigMappingException {
        return this.value().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<String> asStringSupplier() {
        return () -> this.context().last().asString();
    }

    default public String asString(String defaultValue) throws ConfigMappingException {
        return this.value().orElse(defaultValue);
    }

    default public Supplier<String> asStringSupplier(String defaultValue) {
        return () -> this.context().last().asString(defaultValue);
    }

    default public boolean asBoolean() throws MissingValueException, ConfigMappingException {
        return this.asOptional(Boolean.class).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<Boolean> asBooleanSupplier() {
        return () -> this.context().last().asBoolean();
    }

    default public boolean asBoolean(boolean defaultValue) throws ConfigMappingException {
        return this.asOptional(Boolean.class).orElse(defaultValue);
    }

    default public Supplier<Boolean> asBooleanSupplier(boolean defaultValue) {
        return () -> this.context().last().asBoolean(defaultValue);
    }

    default public int asInt() throws MissingValueException, ConfigMappingException {
        return this.asOptionalInt().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<Integer> asIntSupplier() {
        return () -> this.context().last().asInt();
    }

    default public int asInt(int defaultValue) throws ConfigMappingException {
        return this.asOptionalInt().orElse(defaultValue);
    }

    default public Supplier<Integer> asIntSupplier(int defaultValue) {
        return () -> this.context().last().asInt(defaultValue);
    }

    default public long asLong() throws MissingValueException, ConfigMappingException {
        return this.asOptionalLong().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<Long> asLongSupplier() {
        return () -> this.context().last().asLong();
    }

    default public long asLong(long defaultValue) throws ConfigMappingException {
        return this.asOptionalLong().orElse(defaultValue);
    }

    default public Supplier<Long> asLongSupplier(long defaultValue) {
        return () -> this.context().last().asLong(defaultValue);
    }

    default public double asDouble() throws MissingValueException, ConfigMappingException {
        return this.asOptionalDouble().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<Double> asDoubleSupplier() {
        return () -> this.context().last().asDouble();
    }

    default public double asDouble(double defaultValue) throws ConfigMappingException {
        return this.asOptionalDouble().orElse(defaultValue);
    }

    default public Supplier<Double> asDoubleSupplier(double defaultValue) {
        return () -> this.context().last().asDouble(defaultValue);
    }

    default public List<String> asStringList() throws MissingValueException, ConfigMappingException {
        return this.asOptionalList(String.class).orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<List<String>> asStringListSupplier() {
        return () -> this.context().last().asStringList();
    }

    default public List<String> asStringList(List<String> defaultValue) throws ConfigMappingException {
        return this.asOptionalList(String.class).orElse(defaultValue);
    }

    default public Supplier<List<String>> asStringListSupplier(List<String> defaultValue) {
        return () -> this.context().last().asStringList(defaultValue);
    }

    default public List<Config> asNodeList() throws MissingValueException, ConfigMappingException {
        return this.nodeList().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<List<Config>> asNodeListSupplier() {
        return () -> this.context().last().asNodeList();
    }

    default public List<Config> asNodeList(List<Config> defaultValue) throws ConfigMappingException {
        return this.nodeList().orElse(defaultValue);
    }

    default public Supplier<List<Config>> asNodeListSupplier(List<Config> defaultValue) {
        return () -> this.context().last().asNodeList(defaultValue);
    }

    default public Map<String, String> asMap() throws MissingValueException {
        return this.asOptionalMap().orElseThrow(MissingValueException.supplierForKey(this.key()));
    }

    default public Supplier<Map<String, String>> asMapSupplier() {
        return () -> this.context().last().asMap();
    }

    default public Map<String, String> asMap(Map<String, String> defaultValue) {
        return this.asOptionalMap().orElse(defaultValue);
    }

    default public Supplier<Map<String, String>> asMapSupplier(Map<String, String> defaultValue) {
        return () -> this.context().last().asMap(defaultValue);
    }

    @Deprecated
    default public Flow.Publisher<Config> changes() {
        return Flow.Subscriber::onComplete;
    }

    default public void onChange(Function<Config, Boolean> onNextFunction) {
        this.changes().subscribe(ConfigHelper.subscriber(onNextFunction));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.CONSTRUCTOR})
    public static @interface Transient {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface Value {
        public String key() default "";

        public String withDefault() default "io.helidon.config:default=null";

        public Class<? extends Supplier> withDefaultSupplier() default None.class;

        public static interface None
        extends Supplier {
            public static final String VALUE = "io.helidon.config:default=null";

            default public Object get() {
                return null;
            }
        }
    }

    public static interface Context {
        public Instant timestamp();

        public Config last();

        public Config reload();
    }

    public static interface Builder {
        public Builder sources(List<Supplier<ConfigSource>> var1);

        default public Builder sources(Supplier<ConfigSource> configSource) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource}));
            return this;
        }

        default public Builder sources(Supplier<ConfigSource> configSource, Supplier<ConfigSource> configSource2) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource, configSource2}));
            return this;
        }

        default public Builder sources(Supplier<ConfigSource> configSource, Supplier<ConfigSource> configSource2, Supplier<ConfigSource> configSource3) {
            this.sources(CollectionsHelper.listOf((Object[])new Supplier[]{configSource, configSource2, configSource3}));
            return this;
        }

        public Builder overrides(Supplier<OverrideSource> var1);

        public Builder disableKeyResolving();

        public Builder disableValueResolving();

        public Builder disableEnvironmentVariablesSource();

        public Builder disableSystemPropertiesSource();

        public <T> Builder addMapper(Class<T> var1, ConfigMapper<T> var2);

        public <T> Builder addMapper(Class<T> var1, Function<String, T> var2);

        public Builder addMapper(ConfigMapperProvider var1);

        public Builder disableMapperServices();

        public Builder addParser(ConfigParser var1);

        public Builder disableParserServices();

        public Builder addFilter(ConfigFilter var1);

        public Builder addFilter(Function<Config, ConfigFilter> var1);

        public Builder addFilter(Supplier<Function<Config, ConfigFilter>> var1);

        public Builder disableFilterServices();

        public Builder disableCaching();

        public Builder changesExecutor(Executor var1);

        public Builder changesMaxBuffer(int var1);

        public Config build();
    }

    public static enum Type {
        OBJECT(true, false),
        LIST(true, false),
        VALUE(true, true),
        MISSING(false, false);

        private boolean exists;
        private boolean isLeaf;

        private Type(boolean exists, boolean isLeaf) {
            this.exists = exists;
            this.isLeaf = isLeaf;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }
    }

    public static interface Key
    extends Comparable<Key> {
        public Key parent();

        default public boolean isRoot() {
            return this.parent() == null;
        }

        public String name();

        public String toString();

        public static Key of(String key) {
            return ConfigKeyImpl.of(key);
        }

        public static String escapeName(String name) {
            if (!name.contains("~") && !name.contains(".")) {
                return name;
            }
            StringBuilder sb = new StringBuilder();
            char[] chars = name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch == '~') {
                    sb.append("~0");
                    continue;
                }
                if (ch == '.') {
                    sb.append("~1");
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public static String unescapeName(String escapedName) {
            return escapedName.replaceAll("~1", ".").replaceAll("~0", "~");
        }
    }
}

