/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigExistingImpl;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class ConfigComplexImpl<N extends ConfigNode>
extends ConfigExistingImpl<N> {
    ConfigComplexImpl(Config.Type type, ConfigKeyImpl prefix, ConfigKeyImpl key, N node, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(type, prefix, key, node, filter, factory, mapperManager);
    }

    @Override
    public final <T> Optional<List<T>> asOptionalList(Class<? extends T> type) throws ConfigMappingException {
        try {
            return this.nodeList().map((? super T list) -> list.stream().map((? super T config) -> config.as(type)).collect(Collectors.toList()));
        }
        catch (ConfigMappingException | MissingValueException ex) {
            throw new ConfigMappingException((Config.Key)this.key(), "Error to map complex node item to list. " + ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public final Stream<Config> traverse(Predicate<Config> predicate) {
        return this.asNodeList().stream().filter(predicate).map((? super T node) -> ConfigComplexImpl.traverseSubNodes(node, predicate)).reduce(Stream.empty(), Stream::concat);
    }

    private static Stream<Config> traverseSubNodes(Config config, Predicate<Config> predicate) {
        if (config.type().isLeaf()) {
            return Stream.of(config);
        }
        return config.asNodeList().stream().filter(predicate).map((? super T node) -> ConfigComplexImpl.traverseSubNodes(node, predicate)).reduce(Stream.of(config), Stream::concat);
    }
}

