/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigImpl;
import io.helidon.config.Config;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class ConfigExistingImpl<N extends ConfigNode>
extends AbstractConfigImpl {
    private final N node;
    private final ConfigMapperManager mapperManager;
    private final ConfigFilter filter;

    ConfigExistingImpl(Config.Type type, ConfigKeyImpl prefix, ConfigKeyImpl key, N node, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(type, prefix, key, factory);
        this.filter = filter;
        Objects.requireNonNull(node, "node argument is null.");
        Objects.requireNonNull(mapperManager, "mapperManager argument is null.");
        this.node = node;
        this.mapperManager = mapperManager;
    }

    @Override
    public final Optional<String> value() throws ConfigMappingException {
        String value = (String)this.getNode().get();
        if (null != value) {
            return Optional.ofNullable(this.filter.apply(this.realKey(), value));
        }
        return Optional.empty();
    }

    @Override
    public boolean hasValue() {
        return null != this.getNode().get();
    }

    @Override
    public final <T> Optional<T> asOptional(Class<? extends T> type) throws ConfigMappingException {
        try {
            return Optional.ofNullable(this.mapperManager.map(type, this));
        }
        catch (MissingValueException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public final Optional<Map<String, String>> asOptionalMap() {
        Map map = this.mapperManager.map(Map.class, this);
        if (map instanceof ConfigMappers.StringMap) {
            return Optional.of((ConfigMappers.StringMap)map);
        }
        return Optional.of(new ConfigMappers.StringMap(map));
    }

    protected final N getNode() {
        return this.node;
    }
}

