/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.BuilderConfigMapper;
import io.helidon.config.Config;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.FactoryMethodConfigMapper;
import io.helidon.config.GenericConfigMapper;
import io.helidon.config.MissingValueException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConfigMapperManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigMapperManager.class.getName());
    private static final String METHOD_FROM = "from";
    private static final String METHOD_VALUE_OF = "valueOf";
    private static final String METHOD_FROM_CONFIG = "fromConfig";
    private static final String METHOD_FROM_STRING = "fromString";
    private static final String METHOD_BUILDER = "builder";
    private static final String METHOD_BUILD = "build";
    private static final String METHOD_PARSE = "parse";
    private static final String METHOD_CREATE = "create";
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final Map<Class<?>, ConfigMapper<?>> mappers;

    ConfigMapperManager(Map<Class<?>, ConfigMapper<?>> mappers) {
        this.mappers = new HashMap(mappers);
    }

    public <T> T map(Class<T> type, Config config) throws MissingValueException, ConfigMappingException {
        type = ConfigMapperManager.supportedType(type);
        ConfigMapper converter = this.mappers.computeIfAbsent(type, this::fallbackConfigMapper);
        return ConfigMapperManager.cast(type, converter.apply(config), config.key());
    }

    public static <T> T cast(Class<T> type, Object instance, Config.Key key) throws ConfigMappingException {
        try {
            return type.cast(instance);
        }
        catch (ClassCastException ex) {
            throw new ConfigMappingException(key, type, "Created instance is not assignable to the type.", (Throwable)ex);
        }
    }

    static <T> Class<T> supportedType(Class<T> type) {
        return REPLACED_TYPES.getOrDefault(type, type);
    }

    private <T> ConfigMapper<T> fallbackConfigMapper(Class<T> type) {
        Optional<ConfigMapper> configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_FROM, Config.class).map(methodHandle -> new ConfigMethodHandleConfigMapper(type, "from(Config) method", (MethodHandle)methodHandle));
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findConstructor(type, Config.class).map(methodHandle -> new ConfigMethodHandleConfigMapper(type, "Config constructor", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_VALUE_OF, Config.class).map(methodHandle -> new ConfigMethodHandleConfigMapper(type, "valueOf(Config) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_FROM_CONFIG, Config.class).map(methodHandle -> new ConfigMethodHandleConfigMapper(type, "fromConfig(Config) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_FROM, String.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "from(String) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_CREATE, Config.class).map(methodHandle -> new ConfigMethodHandleConfigMapper(type, "create(Config) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_PARSE, String.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "parse(String) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_PARSE, CharSequence.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "parse(CharSequence) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findConstructor(type, String.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "String constructor", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_VALUE_OF, String.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "valueOf(String) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findStaticMethod(type, METHOD_FROM_STRING, String.class).map(methodHandle -> new StringMethodHandleConfigMapper(type, "fromString(String) method", (MethodHandle)methodHandle));
        }
        if (!configMapper.isPresent()) {
            configMapper = this.findBuilderMethod(type).map(builderAccessor -> new BuilderConfigMapper(type, builderAccessor));
        }
        if (!configMapper.isPresent()) {
            configMapper = this.findStaticMethodWithParameters(type, METHOD_FROM).map(factoryAccessor -> new FactoryMethodConfigMapper(type, factoryAccessor));
        }
        if (!configMapper.isPresent()) {
            configMapper = this.findConstructorWithParameters(type).map(factoryAccessor -> new FactoryMethodConfigMapper(type, factoryAccessor));
        }
        if (!configMapper.isPresent()) {
            configMapper = ConfigMapperManager.findConstructor(type, new Class[0]).map(methodHandle -> new GenericConfigMapper(type, (MethodHandle)methodHandle, this));
        }
        return configMapper.orElseGet(() -> new UnsupportedTypeConfigMapper(type));
    }

    private static Optional<MethodHandle> findConstructor(Class<?> type, Class<?> ... parameterTypes) {
        try {
            Constructor<?> constructor = type.getConstructor(parameterTypes);
            if (ConfigMapperManager.checkConstructor(constructor, parameterTypes.length > 0)) {
                return Optional.of(MethodHandles.publicLookup().unreflectConstructor(constructor));
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " constructor with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a constructor with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINER, ex, () -> "Access checking fails on " + type.getName() + " class, constructor with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    private <T> Optional<FactoryMethodConfigMapper.FactoryAccessor<T>> findConstructorWithParameters(Class<T> type) {
        AtomicReference foundConstructor = new AtomicReference();
        for (Constructor<?> constructor : type.getConstructors()) {
            if (!ConfigMapperManager.checkConstructor(constructor, true)) continue;
            if (foundConstructor.get() != null) {
                LOGGER.log(Level.WARNING, () -> "Class " + type.getName() + " contains more than one constructor with parameters. Any will be used to initialize the type.");
                return Optional.empty();
            }
            foundConstructor.set(constructor);
        }
        if (foundConstructor.get() == null) {
            return Optional.empty();
        }
        return ConfigMapperManager.findConstructor(type, ((Constructor)foundConstructor.get()).getParameterTypes()).map(handle -> new FactoryMethodConfigMapper.FactoryAccessor(this, type, (MethodHandle)handle, ((Constructor)foundConstructor.get()).getParameters()));
    }

    private static Optional<MethodHandle> findStaticMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = type.getMethod(methodName, parameterTypes);
            if (ConfigMapperManager.checkMethod(method, true, type, methodName, parameterTypes.length > 0)) {
                return ConfigMapperManager.unreflect(method);
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " method '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a method named '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    private static Optional<Method> findMethod(Class<?> type, String methodName, boolean isStatic, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            Method method = type.getMethod(methodName, parameterTypes);
            if (ConfigMapperManager.checkMethod(method, isStatic, returnType, methodName, parameterTypes.length > 0)) {
                return Optional.of(method);
            }
            LOGGER.log(Level.FINEST, () -> "Class " + type.getName() + " method '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + " cannot be used.");
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.FINEST, ex, () -> "Class " + type.getName() + " does not have a method named '" + methodName + "' with parameters " + Arrays.toString(parameterTypes) + ".");
        }
        return Optional.empty();
    }

    private static Optional<MethodHandle> unreflect(Method method) {
        try {
            return Optional.of(MethodHandles.publicLookup().unreflect(method));
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.FINER, ex, () -> "Access checking fails on " + method.getDeclaringClass() + " class, method '" + method.getName() + "' with parameters " + Arrays.asList(method.getParameters()) + ".");
            return Optional.empty();
        }
    }

    private static boolean checkConstructor(Constructor constructor, boolean hasParams) {
        return Modifier.isPublic(constructor.getModifiers()) && !constructor.isAnnotationPresent(Config.Transient.class) && constructor.getParameterCount() > 0 == hasParams;
    }

    private static boolean checkMethod(Method method, boolean isStatic, Class<?> returnType, String name, boolean hasParams) {
        return Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) == isStatic && !method.isAnnotationPresent(Config.Transient.class) && method.getName().equals(name) && (returnType == null || returnType.isAssignableFrom(method.getReturnType())) && method.getParameterCount() > 0 == hasParams;
    }

    public static <T> Optional<MethodHandle> findBuilderBuildHandler(Class<T> type, Class<?> builderType) {
        return ConfigMapperManager.findMethod(builderType, METHOD_BUILD, false, type, new Class[0]).map(ConfigMapperManager::unreflect).flatMap(methodHandle -> methodHandle);
    }

    private <T> Optional<BuilderConfigMapper.BuilderAccessor<T>> findBuilderMethod(Class<T> type) {
        return ConfigMapperManager.findMethod(type, METHOD_BUILDER, true, null, new Class[0]).map(builderMethod -> ConfigMapperManager.unreflect(builderMethod).map(builderHandler -> ConfigMapperManager.findBuilderBuildHandler(type, builderMethod.getReturnType()).map(buildHandler -> new BuilderConfigMapper.BuilderAccessor(this, builderMethod.getReturnType(), (MethodHandle)builderHandler, type, (MethodHandle)buildHandler))).flatMap(builderAccessor -> builderAccessor)).flatMap(builderAccessor -> builderAccessor);
    }

    private <T> Optional<FactoryMethodConfigMapper.FactoryAccessor<T>> findStaticMethodWithParameters(Class<T> type, String methodName) {
        AtomicReference<Method> foundMethod = new AtomicReference<Method>();
        for (Method method : type.getMethods()) {
            if (!ConfigMapperManager.checkMethod(method, true, type, methodName, true)) continue;
            if (foundMethod.get() != null) {
                LOGGER.log(Level.WARNING, () -> "Class " + type.getName() + " contains more than one static factory method '" + methodName + "' with parameters. Any will be used to initialize the type.");
                return Optional.empty();
            }
            foundMethod.set(method);
        }
        if (foundMethod.get() == null) {
            return Optional.empty();
        }
        return ConfigMapperManager.findStaticMethod(type, methodName, ((Method)foundMethod.get()).getParameterTypes()).map(handle -> new FactoryMethodConfigMapper.FactoryAccessor(this, type, (MethodHandle)handle, ((Method)foundMethod.get()).getParameters()));
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    private static class UnsupportedTypeConfigMapper<T>
    implements ConfigMapper<T> {
        private final Class<T> type;

        private UnsupportedTypeConfigMapper(Class<T> type) {
            this.type = type;
        }

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            throw new ConfigMappingException(config.key(), this.type, "Unsupported Java type, no compatible config value mapper found.");
        }
    }

    private static class StringMethodHandleConfigMapper<T>
    extends MethodHandleConfigMapper<T, String> {
        private StringMethodHandleConfigMapper(Class<T> type, String methodName, MethodHandle methodHandle) {
            super(type, methodName, methodHandle);
        }

        @Override
        protected String invokeParameter(Config config) {
            return config.asString();
        }
    }

    private static class ConfigMethodHandleConfigMapper<T>
    extends MethodHandleConfigMapper<T, Config> {
        private ConfigMethodHandleConfigMapper(Class<T> type, String methodName, MethodHandle methodHandle) {
            super(type, methodName, methodHandle);
        }

        @Override
        protected Config invokeParameter(Config config) {
            return config;
        }
    }

    private static abstract class MethodHandleConfigMapper<T, P>
    implements ConfigMapper<T> {
        private final Class<T> type;
        private final String methodName;
        private final MethodHandle methodHandle;

        private MethodHandleConfigMapper(Class<T> type, String methodName, MethodHandle methodHandle) {
            this.type = type;
            this.methodName = methodName;
            this.methodHandle = methodHandle;
        }

        protected abstract P invokeParameter(Config var1);

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            try {
                return this.type.cast(this.methodHandle.invoke(this.invokeParameter(config)));
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.type, "Invocation of " + this.methodName + " has failed with an exception.", ex);
            }
        }
    }
}

