/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParsePosition;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ConfigMappers {
    private static final Map<Class<?>, ConfigMapper<?>> ESSENTIAL_MAPPERS = ConfigMappers.initEssentialMappers();
    static final Map<Class<?>, ConfigMapper<?>> BUILT_IN_MAPPERS = ConfigMappers.initBuiltInMappers();

    private ConfigMappers() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    private static Map<Class<?>, ConfigMapper<?>> initEssentialMappers() {
        HashMap<Class<OptionalDouble>, ConfigMapper<Object>> essentials = new HashMap<Class<OptionalDouble>, ConfigMapper<Object>>();
        essentials.put(Config.class, node -> node);
        essentials.put(String.class, ConfigMappers.wrap(value -> value));
        essentials.put(OptionalInt.class, node -> {
            if (!node.exists()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(ConfigMappers.wrap(Integer::parseInt).apply(node));
        });
        essentials.put(OptionalLong.class, node -> {
            if (!node.exists()) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(ConfigMappers.wrap(Long::parseLong).apply(node));
        });
        essentials.put(OptionalDouble.class, node -> {
            if (!node.exists()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(ConfigMappers.wrap(Double::parseDouble).apply(node));
        });
        return Collections.unmodifiableMap(essentials);
    }

    static Map<Class<?>, ConfigMapper<?>> essentialMappers() {
        return ESSENTIAL_MAPPERS;
    }

    private static Map<Class<?>, ConfigMapper<?>> initBuiltInMappers() {
        HashMap<Class, ConfigMapper<Object>> builtIns = new HashMap<Class, ConfigMapper<Object>>();
        builtIns.put(Byte.class, ConfigMappers.wrap(ConfigMappers::toByte));
        builtIns.put(Short.class, ConfigMappers.wrap(ConfigMappers::toShort));
        builtIns.put(Integer.class, ConfigMappers.wrap(ConfigMappers::toInt));
        builtIns.put(Long.class, ConfigMappers.wrap(ConfigMappers::toLong));
        builtIns.put(Float.class, ConfigMappers.wrap(ConfigMappers::toFloat));
        builtIns.put(Double.class, ConfigMappers.wrap(ConfigMappers::toDouble));
        builtIns.put(Boolean.class, ConfigMappers.wrap(ConfigMappers::toBoolean));
        builtIns.put(Character.class, ConfigMappers.wrap(ConfigMappers::toChar));
        builtIns.put(Class.class, ConfigMappers.wrap(ConfigMappers::toClass));
        builtIns.put(BigDecimal.class, ConfigMappers.wrap(ConfigMappers::toBigDecimal));
        builtIns.put(BigInteger.class, ConfigMappers.wrap(ConfigMappers::toBigInteger));
        builtIns.put(Duration.class, ConfigMappers.wrap(ConfigMappers::toDuration));
        builtIns.put(Period.class, ConfigMappers.wrap(ConfigMappers::toPeriod));
        builtIns.put(LocalDate.class, ConfigMappers.wrap(ConfigMappers::toLocalDate));
        builtIns.put(LocalDateTime.class, ConfigMappers.wrap(ConfigMappers::toLocalDateTime));
        builtIns.put(LocalTime.class, ConfigMappers.wrap(ConfigMappers::toLocalTime));
        builtIns.put(ZonedDateTime.class, ConfigMappers.wrap(ConfigMappers::toZonedDateTime));
        builtIns.put(ZoneId.class, ConfigMappers.wrap(ConfigMappers::toZoneId));
        builtIns.put(ZoneOffset.class, ConfigMappers.wrap(ConfigMappers::toZoneOffset));
        builtIns.put(Instant.class, ConfigMappers.wrap(ConfigMappers::toInstant));
        builtIns.put(OffsetTime.class, ConfigMappers.wrap(ConfigMappers::toOffsetTime));
        builtIns.put(OffsetDateTime.class, ConfigMappers.wrap(ConfigMappers::toOffsetDateTime));
        builtIns.put(File.class, ConfigMappers.wrap(ConfigMappers::toFile));
        builtIns.put(Path.class, ConfigMappers.wrap(ConfigMappers::toPath));
        builtIns.put(Charset.class, ConfigMappers.wrap(ConfigMappers::toCharset));
        builtIns.put(URI.class, ConfigMappers.wrap(ConfigMappers::toUri));
        builtIns.put(URL.class, ConfigMappers.wrap(ConfigMappers::toUrl));
        builtIns.put(Pattern.class, ConfigMappers.wrap(ConfigMappers::toPattern));
        builtIns.put(UUID.class, ConfigMappers.wrap(ConfigMappers::toUUID));
        builtIns.put(Map.class, ConfigMappers.wrapMapper(ConfigMappers::toMap));
        builtIns.put(Properties.class, ConfigMappers.wrapMapper(ConfigMappers::toProperties));
        builtIns.put(Date.class, ConfigMappers.wrap(ConfigMappers::toDate));
        builtIns.put(Calendar.class, ConfigMappers.wrap(ConfigMappers::toCalendar));
        builtIns.put(GregorianCalendar.class, ConfigMappers.wrap(ConfigMappers::toGregorianCalendar));
        builtIns.put(TimeZone.class, ConfigMappers.wrap(ConfigMappers::toTimeZone));
        builtIns.put(SimpleTimeZone.class, ConfigMappers.wrap(ConfigMappers::toSimpleTimeZone));
        return Collections.unmodifiableMap(builtIns);
    }

    static Map<Class<?>, ConfigMapper<?>> builtInMappers() {
        return BUILT_IN_MAPPERS;
    }

    public static Byte toByte(String stringValue) {
        return Byte.parseByte(stringValue);
    }

    public static Short toShort(String stringValue) {
        return Short.parseShort(stringValue);
    }

    public static Integer toInt(String stringValue) {
        return Integer.parseInt(stringValue);
    }

    public static Long toLong(String stringValue) {
        return Long.parseLong(stringValue);
    }

    public static Float toFloat(String stringValue) {
        return Float.valueOf(Float.parseFloat(stringValue));
    }

    public static Double toDouble(String stringValue) {
        return Double.parseDouble(stringValue);
    }

    public static Boolean toBoolean(String stringValue) {
        return Boolean.parseBoolean(stringValue);
    }

    public static Character toChar(String stringValue) {
        if (stringValue.length() != 1) {
            throw new IllegalArgumentException("Cannot convert to 'char'. The value must be just single character, but was '" + stringValue + "'.");
        }
        return Character.valueOf(stringValue.charAt(0));
    }

    public static Class<?> toClass(String stringValue) {
        try {
            return Class.forName(stringValue);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static UUID toUUID(String stringValue) {
        return UUID.fromString(stringValue);
    }

    public static BigDecimal toBigDecimal(String stringValue) {
        return new BigDecimal(stringValue);
    }

    public static BigInteger toBigInteger(String stringValue) {
        return new BigInteger(stringValue);
    }

    public static File toFile(String stringValue) {
        return new File(stringValue);
    }

    public static Path toPath(String stringValue) {
        return Paths.get(stringValue, new String[0]);
    }

    public static Charset toCharset(String stringValue) {
        return Charset.forName(stringValue);
    }

    public static Pattern toPattern(String stringValue) {
        return Pattern.compile(stringValue);
    }

    public static URI toUri(String stringValue) {
        return URI.create(stringValue);
    }

    public static URL toUrl(String stringValue) {
        try {
            return new URL(stringValue);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static Date toDate(String stringValue) {
        try {
            return new Date(Instant.from(ConfigMappers.buildDateTimeFormatter(stringValue).parse(stringValue)).toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static DateTimeFormatter buildDateTimeFormatter(String stringValue) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        ParsePosition pp = new ParsePosition(0);
        TemporalAccessor accessor = formatter.parseUnresolved(stringValue, pp);
        if (!accessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            formatter = formatter.withZone(ZoneId.of("UTC"));
        }
        return formatter;
    }

    public static Calendar toCalendar(String stringValue) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(ConfigMappers.toDate(stringValue));
        return calendar;
    }

    public static GregorianCalendar toGregorianCalendar(String stringValue) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ConfigMappers.toDate(stringValue));
        return calendar;
    }

    public static LocalDate toLocalDate(String stringValue) {
        return LocalDate.parse(stringValue);
    }

    public static LocalTime toLocalTime(String stringValue) {
        return LocalTime.parse(stringValue);
    }

    public static LocalDateTime toLocalDateTime(String stringValue) {
        return LocalDateTime.parse(stringValue);
    }

    public static ZonedDateTime toZonedDateTime(String stringValue) {
        return ZonedDateTime.parse(stringValue);
    }

    public static ZoneId toZoneId(String stringValue) {
        return ZoneId.of(stringValue);
    }

    public static ZoneOffset toZoneOffset(String stringValue) {
        return ZoneOffset.of(stringValue);
    }

    public static TimeZone toTimeZone(String stringValue) {
        ZoneId zoneId = ConfigMappers.toZoneId(stringValue);
        return TimeZone.getTimeZone(zoneId);
    }

    public static SimpleTimeZone toSimpleTimeZone(String stringValue) {
        return new SimpleTimeZone(ConfigMappers.toTimeZone(stringValue).getRawOffset(), stringValue);
    }

    public static Instant toInstant(String stringValue) {
        return Instant.parse(stringValue);
    }

    public static OffsetDateTime toOffsetDateTime(String stringValue) {
        return OffsetDateTime.parse(stringValue);
    }

    public static OffsetTime toOffsetTime(String stringValue) {
        return OffsetTime.parse(stringValue);
    }

    public static Duration toDuration(String stringValue) {
        return Duration.parse(stringValue);
    }

    public static Period toPeriod(String stringValue) {
        return Period.parse(stringValue);
    }

    public static Map<String, String> toMap(Config config) {
        if (config.isLeaf()) {
            return new StringMap(config.key().toString(), config.asString());
        }
        return new StringMap(config.traverse().filter(Config::isLeaf).map(node -> new AbstractMap.SimpleEntry<String, String>(node.key().toString(), node.asString())).collect(Collectors.toSet()));
    }

    public static Properties toProperties(Config config) {
        Properties properties = new Properties();
        ConfigMappers.toMap(config).forEach(properties::setProperty);
        return properties;
    }

    public static <T> ConfigMapper<T> from(Class<T> type, Class<?> builderType) throws ConfigException {
        MethodHandle buildHandle = ConfigMapperManager.findBuilderBuildHandler(type, builderType).orElseThrow(() -> new ConfigException("Builder " + builderType.getName() + " does not provide accessible 'build()' method to build " + type.getName() + " instance."));
        return new ExternalBuilderConfigMapper(type, builderType, buildHandle);
    }

    private static <T> ConfigMapper<T> wrapMapper(ConfigMapper<T> mapper) throws MissingValueException, ConfigMappingException {
        return node -> {
            try {
                return mapper.apply(node);
            }
            catch (ConfigMappingException | MissingValueException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new ConfigMappingException(node.key(), "Invocation of mapper '" + mapper + "' has failed with an exception.", ex);
            }
        };
    }

    static <T> ConfigMapper<T> wrap(Function<String, T> mapper) {
        return node -> {
            Optional<String> nodeValue = node.value();
            return nodeValue.map(value -> ConfigMappers.safeMap(node.key(), value, mapper)).orElseThrow(MissingValueException.supplierForKey(node.key()));
        };
    }

    private static <T> T safeMap(Config.Key key, String value, Function<String, T> mapper) throws ConfigMappingException {
        try {
            return mapper.apply(value);
        }
        catch (ConfigMappingException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new ConfigMappingException(key, value, "Invocation of mapper '" + mapper + "' has failed with an exception.", (Throwable)ex);
        }
    }

    private static class ExternalBuilderConfigMapper<T>
    implements ConfigMapper<T> {
        private final Class<T> type;
        private final Class<?> builderType;
        private final MethodHandle buildHandle;

        private ExternalBuilderConfigMapper(Class<T> type, Class<?> builderType, MethodHandle buildHandle) {
            this.type = type;
            this.builderType = builderType;
            this.buildHandle = buildHandle;
        }

        @Override
        public T apply(Config config) throws ConfigMappingException, MissingValueException {
            Object builder = config.as(this.builderType);
            try {
                return ConfigMapperManager.cast(this.type, this.buildHandle.invoke(builder), config.key());
            }
            catch (ConfigMappingException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new ConfigMappingException(config.key(), this.type, "Build method invocation failed with an exception.", ex);
            }
        }
    }

    static class StringMap
    extends AbstractMap<String, String>
    implements Map<String, String> {
        private final Set<Map.Entry<String, String>> entrySet;

        StringMap(Set<Map.Entry<String, String>> entrySet) {
            this.entrySet = entrySet;
        }

        StringMap(String key, String value) {
            this(CollectionsHelper.setOf((Object[])new Map.Entry[]{CollectionsHelper.mapEntry((Object)key, (Object)value)}));
        }

        StringMap(Map<?, ?> unknownMap) {
            this(StringMap.wrap(unknownMap.entrySet()));
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.entrySet;
        }

        private static Set<Map.Entry<String, String>> wrap(Set<? extends Map.Entry<?, ?>> unknownEntrySet) {
            return unknownEntrySet.stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()))).collect(Collectors.toSet());
        }
    }
}

