/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigExistingImpl;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.internal.ConfigKeyImpl;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class ConfigValueImpl
extends ConfigExistingImpl<ConfigNode.ValueNode> {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private final ConfigMapperManager mapperManager;

    ConfigValueImpl(ConfigKeyImpl prefix, ConfigKeyImpl key, ConfigNode.ValueNode valueNode, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(Config.Type.VALUE, prefix, key, valueNode, filter, factory, mapperManager);
        this.mapperManager = mapperManager;
        Objects.requireNonNull(filter, "filter argument is null.");
    }

    @Override
    public Optional<List<Config>> nodeList() {
        throw new ConfigMappingException(this.key(), "The Config node represents single value.");
    }

    @Override
    public final <T> Optional<List<T>> asOptionalList(Class<? extends T> type) throws ConfigMappingException {
        if (type == Config.class) {
            throw new ConfigMappingException(this.key(), "The Config node represents single value.");
        }
        Optional<String> value = this.value();
        if (!value.isPresent()) {
            return Optional.empty();
        }
        String stringValue = value.get();
        if (stringValue.contains(",")) {
            String[] parts = ConfigValueImpl.toArray(stringValue);
            LinkedList<T> result = new LinkedList<T>();
            for (String part : parts) {
                result.add(this.mapperManager.map(type, this.createConfig(this, part)));
            }
            return Optional.of(result);
        }
        return Optional.of(CollectionsHelper.listOf((Object[])new Object[]{this.mapperManager.map(type, this.createConfig(this, stringValue))}));
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = value.replace("\\,", ",");
        }
        return values;
    }

    private Config createConfig(final ConfigValueImpl configValue, final String stringValue) {
        return new Config(){

            @Override
            public Instant timestamp() {
                return null;
            }

            @Override
            public Config.Key key() {
                return configValue.key();
            }

            @Override
            public Config get(Config.Key key) {
                return null;
            }

            @Override
            public Config detach() {
                return null;
            }

            @Override
            public Config.Type type() {
                return Config.Type.VALUE;
            }

            @Override
            public boolean hasValue() {
                return true;
            }

            @Override
            public Stream<Config> traverse(Predicate<Config> predicate) {
                return null;
            }

            @Override
            public Optional<String> value() throws ConfigMappingException {
                return Optional.of(stringValue);
            }

            @Override
            public Optional<List<Config>> nodeList() throws ConfigMappingException {
                return Optional.empty();
            }

            @Override
            public Optional<Map<String, String>> asOptionalMap() {
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> asOptional(Class<? extends T> type) throws ConfigMappingException {
                return Optional.empty();
            }

            @Override
            public <T> Optional<List<T>> asOptionalList(Class<? extends T> type) throws ConfigMappingException {
                return Optional.empty();
            }
        };
    }

    @Override
    public Stream<Config> traverse(Predicate<Config> predicate) {
        return Stream.empty();
    }

    public String toString() {
        return "[" + this.realKey() + "] VALUE '" + (String)((ConfigNode.ValueNode)this.getNode()).get() + "'";
    }
}

