/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.GenericConfigMapperUtils;
import io.helidon.config.MissingValueException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

class FactoryMethodConfigMapper<T>
implements ConfigMapper<T> {
    private final Class<T> type;
    private final FactoryAccessor<T> factoryAccessor;

    FactoryMethodConfigMapper(Class<T> type, FactoryAccessor<T> factoryAccessor) {
        this.type = type;
        this.factoryAccessor = factoryAccessor;
    }

    @Override
    public T apply(Config config) throws ConfigMappingException, MissingValueException {
        return this.factoryAccessor.create(config);
    }

    static class FactoryAccessor<T> {
        private final Class<T> type;
        private final MethodHandle handle;
        private final LinkedHashMap<String, GenericConfigMapperUtils.PropertyWrapper<?>> parameterValueProviders;

        FactoryAccessor(ConfigMapperManager mapperManager, Class<T> type, MethodHandle handle, Parameter[] parameters) {
            this.type = type;
            this.handle = handle;
            this.parameterValueProviders = FactoryAccessor.initParameterValueProviders(mapperManager, parameters);
        }

        public T create(Config configNode) {
            List<Object> args = this.createArguments(configNode);
            try {
                Object obj = this.handle.invokeWithArguments(args);
                return this.type.cast(obj);
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to create '" + this.type.getName() + "' instance.", throwable);
            }
        }

        private List<Object> createArguments(Config configNode) {
            ArrayList<Object> arguments = new ArrayList<Object>(this.parameterValueProviders.size());
            this.parameterValueProviders.forEach((name, propertyWrapper) -> {
                Config subConfig = configNode.get((String)name);
                Object argument = propertyWrapper.get(subConfig).orElseThrow(() -> new ConfigMappingException(configNode.key(), this.type, "Missing value for parameter '" + name + "'."));
                arguments.add(argument);
            });
            return arguments;
        }

        private static LinkedHashMap<String, GenericConfigMapperUtils.PropertyWrapper<?>> initParameterValueProviders(ConfigMapperManager mapperManager, Parameter[] parameters) {
            LinkedHashMap parameterValueProvider = new LinkedHashMap();
            for (Parameter parameter : parameters) {
                String name = GenericConfigMapperUtils.propertyName(parameter);
                parameterValueProvider.put(name, FactoryAccessor.createPropertyWrapper(mapperManager, name, parameter));
            }
            return parameterValueProvider;
        }

        private static GenericConfigMapperUtils.PropertyWrapper<?> createPropertyWrapper(ConfigMapperManager mapperManager, String name, Parameter parameter) {
            Config.Value value = parameter.getAnnotation(Config.Value.class);
            Class propertyType = parameter.getType();
            Class configAsType = propertyType;
            boolean list = configAsType.isAssignableFrom(List.class);
            if (list) {
                Type genType = parameter.getParameterizedType();
                if (genType instanceof ParameterizedType) {
                    configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
                } else {
                    throw new ConfigException("Unable to find generic type of List on parameter type: " + parameter);
                }
            }
            return new GenericConfigMapperUtils.PropertyWrapper(mapperManager, name, propertyType, configAsType, list, GenericConfigMapperUtils.createDefaultSupplier(name, value));
        }
    }
}

