/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigSources;
import io.helidon.config.spi.ConfigNode;
import java.util.Collections;
import java.util.List;

final class FallbackMergingStrategy
implements ConfigSources.MergingStrategy {
    FallbackMergingStrategy() {
    }

    @Override
    public ConfigNode.ObjectNode merge(List<ConfigNode.ObjectNode> rootNodes) {
        Collections.reverse(rootNodes);
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        rootNodes.forEach(root -> root.forEach((key, node) -> FallbackMergingStrategy.addNode(builder, key, node)));
        return builder.build();
    }

    private static ConfigNode.ObjectNode.Builder addNode(ConfigNode.ObjectNode.Builder builder, String key, ConfigNode node) {
        switch (node.getNodeType()) {
            case OBJECT: {
                return builder.addObject(key, (ConfigNode.ObjectNode)node);
            }
            case LIST: {
                return builder.addList(key, (ConfigNode.ListNode)node);
            }
            case VALUE: {
                return builder.addValue(key, (ConfigNode.ValueNode)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }
}

