/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMapper;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappers;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.GenericConfigMapperUtils;
import io.helidon.config.MissingValueException;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

class GenericConfigMapper<T>
implements ConfigMapper<T> {
    private final Class<T> type;
    private final MethodHandle constructorHandle;
    private final Collection<PropertyAccessor> propertyAccessors;

    GenericConfigMapper(Class<T> type, MethodHandle constructorHandle, ConfigMapperManager mapperManager) {
        this.type = type;
        this.constructorHandle = constructorHandle;
        this.propertyAccessors = GenericConfigMapperUtils.getBeanProperties(mapperManager, type);
    }

    @Override
    public T apply(Config config) throws ConfigMappingException, MissingValueException {
        try {
            T instance = this.type.cast(this.constructorHandle.invoke());
            for (PropertyAccessor propertyAccessor : this.propertyAccessors) {
                propertyAccessor.set(instance, config.get(propertyAccessor.getName()));
            }
            return instance;
        }
        catch (ConfigMappingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ConfigMappingException(config.key(), this.type, "Generic java bean initialization has failed with an exception.", ex);
        }
    }

    static class SingleValueConfigImpl
    implements Config {
        private final ConfigMapperManager mapperManager;
        private final Config.Key key;
        private final String value;
        private final Instant timestamp;

        SingleValueConfigImpl(ConfigMapperManager mapperManager, String key, String value) {
            this.mapperManager = mapperManager;
            this.key = Config.Key.of(key);
            this.value = value;
            this.timestamp = Instant.now();
        }

        @Override
        public boolean hasValue() {
            return null != this.value;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        @Override
        public Optional<String> value() throws ConfigMappingException {
            return Optional.of(this.value);
        }

        @Override
        public Config.Type type() {
            return Config.Type.VALUE;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public Config get(Config.Key key) {
            if (key.isRoot()) {
                return this;
            }
            return Config.empty().get(this.key).get(key);
        }

        @Override
        public Config detach() {
            if (this.key.isRoot()) {
                return this;
            }
            return new SingleValueConfigImpl(this.mapperManager, "", this.value);
        }

        @Override
        public Stream<Config> traverse(Predicate<Config> predicate) {
            return Stream.empty();
        }

        @Override
        public Optional<Map<String, String>> asOptionalMap() {
            Map map = this.mapperManager.map(Map.class, this);
            if (map instanceof ConfigMappers.StringMap) {
                return Optional.of((ConfigMappers.StringMap)map);
            }
            return Optional.of(new ConfigMappers.StringMap(map));
        }

        @Override
        public <T> Optional<T> asOptional(Class<? extends T> type) throws ConfigMappingException {
            return Optional.ofNullable(this.mapperManager.map(type, this));
        }

        @Override
        public Optional<List<Config>> nodeList() throws ConfigMappingException {
            throw new ConfigMappingException(this.key(), "The Config node represents single value.");
        }

        @Override
        public <T> Optional<List<T>> asOptionalList(Class<? extends T> type) throws ConfigMappingException {
            throw new ConfigMappingException(this.key(), "The Config node represents single value.");
        }
    }

    static class PropertyAccessor<T> {
        private final String name;
        private final MethodHandle handle;
        private final boolean hasValueAnnotation;
        private final GenericConfigMapperUtils.PropertyWrapper<T> propertyWrapper;

        PropertyAccessor(ConfigMapperManager mapperManager, String name, Class<T> propertyType, Class<?> configAsType, boolean list, MethodHandle handle, Config.Value value) {
            this.name = name;
            this.handle = handle;
            this.hasValueAnnotation = value != null;
            this.propertyWrapper = new GenericConfigMapperUtils.PropertyWrapper<T>(mapperManager, name, propertyType, configAsType, list, GenericConfigMapperUtils.createDefaultSupplier(name, value));
        }

        public String getName() {
            return this.name;
        }

        void set(T instance, Config configNode) {
            this.propertyWrapper.get(configNode).ifPresent(value -> this.setImpl(instance, value));
        }

        private void setImpl(T instance, Object value) {
            try {
                this.handle.invoke(instance, value);
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to set '" + this.name + "' property.", throwable);
            }
        }

        MethodHandle getHandle() {
            return this.handle;
        }

        boolean hasValueAnnotation() {
            return this.hasValueAnnotation;
        }

        void setValueAnnotation(Config.Value value) {
            this.propertyWrapper.setDefaultSupplier(GenericConfigMapperUtils.createDefaultSupplier(this.name, value));
        }
    }
}

