/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.GenericConfigMapper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Logger;

final class GenericConfigMapperUtils {
    private static final Logger LOGGER = Logger.getLogger(GenericConfigMapperUtils.class.getName());

    private GenericConfigMapperUtils() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static <T> Collection<GenericConfigMapper.PropertyAccessor> getBeanProperties(ConfigMapperManager mapperManager, Class<T> type) {
        return GenericConfigMapperUtils.getPropertyAccessors(mapperManager, type).values();
    }

    static <T> Map<String, GenericConfigMapper.PropertyAccessor> getPropertyAccessors(ConfigMapperManager mapperManager, Class<T> type) {
        HashSet<String> transientProps = new HashSet<String>();
        HashMap<String, GenericConfigMapper.PropertyAccessor> propertyAccessors = new HashMap<String, GenericConfigMapper.PropertyAccessor>();
        GenericConfigMapperUtils.initMethods(mapperManager, type, transientProps, propertyAccessors);
        GenericConfigMapperUtils.initFields(mapperManager, type, transientProps, propertyAccessors);
        return propertyAccessors;
    }

    static <T> void initMethods(ConfigMapperManager mapperManager, Class<T> type, Set<String> transientProps, Map<String, GenericConfigMapper.PropertyAccessor> propertyAccessors) {
        for (Method method : type.getMethods()) {
            if (!GenericConfigMapperUtils.isSetter(method)) continue;
            String name = GenericConfigMapperUtils.propertyName(method);
            if (GenericConfigMapperUtils.isTransient(method)) {
                transientProps.add(name);
                continue;
            }
            propertyAccessors.put(name, GenericConfigMapperUtils.createPropertyAccessor(mapperManager, type, name, method));
        }
    }

    static <T> void initFields(ConfigMapperManager mapperManager, Class<T> type, Set<String> transientProps, Map<String, GenericConfigMapper.PropertyAccessor> propertyAccessors) {
        for (Field field : type.getFields()) {
            if (!GenericConfigMapperUtils.isAccessible(field)) continue;
            String name = GenericConfigMapperUtils.propertyName(field);
            if (GenericConfigMapperUtils.isTransient(field)) {
                if (!propertyAccessors.containsKey(name)) continue;
                throw new ConfigException("Illegal use of both @Config.Value (method) and @Config.Transient (field) annotations on single '" + name + "' property.");
            }
            if (transientProps.contains(name)) {
                if (!field.isAnnotationPresent(Config.Value.class)) continue;
                throw new ConfigException("Illegal use of both @Config.Value (field) and @Config.Transient (method) annotations on single '" + name + "' property.");
            }
            if (propertyAccessors.containsKey(name)) {
                if (field.getAnnotation(Config.Value.class) == null) continue;
                GenericConfigMapper.PropertyAccessor propertyAccessor = propertyAccessors.get(name);
                if (!propertyAccessor.hasValueAnnotation()) {
                    propertyAccessor.setValueAnnotation(field.getAnnotation(Config.Value.class));
                    continue;
                }
                LOGGER.fine(() -> "Annotation @Config.Value on '" + name + "' field is ignored because setter method already has one.");
                continue;
            }
            propertyAccessors.put(name, GenericConfigMapperUtils.createPropertyAccessor(mapperManager, type, name, field));
        }
    }

    static <T> GenericConfigMapper.PropertyAccessor<T> createPropertyAccessor(ConfigMapperManager mapperManager, Class<T> type, String name, Method method) {
        try {
            Class propertyType;
            Class configAsType = propertyType = method.getParameterTypes()[0];
            boolean list = configAsType.isAssignableFrom(List.class);
            if (list) {
                Type genType = method.getGenericParameterTypes()[0];
                if (genType instanceof ParameterizedType) {
                    configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
                } else {
                    throw new ConfigException("Unable to find generic type of List on setter parameter: " + method);
                }
            }
            MethodHandle handle = MethodHandles.publicLookup().findVirtual(type, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()));
            return new GenericConfigMapper.PropertyAccessor(mapperManager, name, propertyType, configAsType, list, handle, method.getAnnotation(Config.Value.class));
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException ex) {
            throw new ConfigException("Cannot access setter: " + method, ex);
        }
    }

    static <T> GenericConfigMapper.PropertyAccessor<T> createPropertyAccessor(ConfigMapperManager mapperManager, Class<T> type, String name, Field field) {
        try {
            Class propertyType;
            Class configAsType = propertyType = field.getType();
            boolean list = configAsType.isAssignableFrom(List.class);
            if (list) {
                Type genType = field.getGenericType();
                if (genType instanceof ParameterizedType) {
                    configAsType = (Class)((ParameterizedType)genType).getActualTypeArguments()[0];
                } else {
                    throw new ConfigException("Unable to find generic type of List on field type: " + field);
                }
            }
            MethodHandle handle = MethodHandles.publicLookup().findSetter(type, field.getName(), field.getType());
            return new GenericConfigMapper.PropertyAccessor(mapperManager, name, propertyType, configAsType, list, handle, field.getAnnotation(Config.Value.class));
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException ex) {
            throw new ConfigException("Cannot access field: " + field, ex);
        }
    }

    static boolean isTransient(Method method) throws ConfigException {
        if (method.isAnnotationPresent(Config.Transient.class)) {
            if (method.isAnnotationPresent(Config.Value.class)) {
                throw new ConfigException("Illegal use of both @Config.Value and @Config.Transient annotations on single '" + method.getName() + "' setter.");
            }
            return true;
        }
        return false;
    }

    static boolean isTransient(Field field) throws ConfigException {
        if (field.isAnnotationPresent(Config.Transient.class)) {
            if (field.isAnnotationPresent(Config.Value.class)) {
                throw new ConfigException("Illegal use of both @Config.Value and @Config.Transient annotations on single field '" + field.getName() + "'.");
            }
            return true;
        }
        return false;
    }

    static boolean isAccessible(Field field) {
        return !Modifier.isFinal(field.getModifiers());
    }

    static boolean isSetter(Method method) {
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (!method.isAnnotationPresent(Config.Value.class)) {
            if (method.getName().length() <= 3) {
                return false;
            }
            if (!method.getName().startsWith("set")) {
                return false;
            }
            if (!method.getReturnType().equals(Void.TYPE)) {
                return false;
            }
        }
        return true;
    }

    static String propertyName(Method method) {
        Config.Value value = method.getAnnotation(Config.Value.class);
        String name = Optional.ofNullable(value).map(Config.Value::key).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
        if (name == null && (name = method.getName()).startsWith("set") && name.length() > 3) {
            name = GenericConfigMapperUtils.decapitalize(name.substring("set".length()));
        }
        return name;
    }

    static String propertyName(Parameter parameter) {
        Config.Value value = parameter.getAnnotation(Config.Value.class);
        String name = Optional.ofNullable(value).map(Config.Value::key).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
        if (name == null) {
            name = parameter.getName();
        }
        return name;
    }

    static String propertyName(Field field) {
        Config.Value value = field.getAnnotation(Config.Value.class);
        String name = Optional.ofNullable(value).map(Config.Value::key).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
        if (name == null) {
            name = field.getName();
        }
        return name;
    }

    static String decapitalize(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static <T> BiFunction<Class<T>, ConfigMapperManager, T> createDefaultSupplier(String name, Config.Value annotation) {
        if (annotation != null) {
            if (annotation.withDefaultSupplier() != Config.Value.None.class) {
                return (type, mapperManager) -> {
                    try {
                        return type.cast(annotation.withDefaultSupplier().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get());
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new ConfigException("Error creating default value supplier.", ex);
                    }
                };
            }
            if (!annotation.withDefault().equals("io.helidon.config:default=null")) {
                return (type, mapperManager) -> mapperManager.map(type, new GenericConfigMapper.SingleValueConfigImpl((ConfigMapperManager)mapperManager, name, annotation.withDefault()));
            }
        }
        return null;
    }

    static class PropertyWrapper<T> {
        private final ConfigMapperManager mapperManager;
        private final String name;
        private final Class<T> propertyType;
        private final Class<?> configAsType;
        private final boolean list;
        private BiFunction<Class<T>, ConfigMapperManager, T> defaultSupplier;

        PropertyWrapper(ConfigMapperManager mapperManager, String name, Class<T> propertyType, Class<?> configAsType, boolean list, BiFunction<Class<T>, ConfigMapperManager, T> defaultSupplier) {
            this.mapperManager = mapperManager;
            this.name = name;
            this.propertyType = ConfigMapperManager.supportedType(propertyType);
            this.configAsType = configAsType;
            this.list = list;
            this.defaultSupplier = defaultSupplier;
        }

        Optional<T> get(Config configNode) {
            try {
                if (configNode.exists()) {
                    if (this.list) {
                        return Optional.of(this.propertyType.cast(configNode.asList(this.configAsType)));
                    }
                    return Optional.of(this.propertyType.cast(configNode.as(this.configAsType)));
                }
                if (this.defaultSupplier != null) {
                    return Optional.ofNullable(this.defaultSupplier.apply(this.propertyType, this.mapperManager));
                }
                return Optional.empty();
            }
            catch (ConfigException ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                throw new ConfigException("Unable to set '" + this.name + "' property.", throwable);
            }
        }

        void setDefaultSupplier(BiFunction<Class<T>, ConfigMapperManager, T> defaultSupplier) {
            this.defaultSupplier = defaultSupplier;
        }
    }
}

