/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.reactive.Flow;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.FilesystemWatchPollingStrategy;
import io.helidon.config.internal.ScheduledPollingStrategy;
import io.helidon.config.spi.PollingStrategy;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public final class PollingStrategies {
    private PollingStrategies() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static PollingStrategy nop() {
        return NopPollingStrategyHolder.NOP;
    }

    public static ScheduledBuilder regular(Duration interval) {
        return new ScheduledBuilder(new ScheduledPollingStrategy.RegularRecurringPolicy(interval));
    }

    public static FilesystemWatchBuilder watch(Path watchedPath) {
        return new FilesystemWatchBuilder(watchedPath);
    }

    private static final class NopPollingStrategyHolder {
        private static final PollingStrategy NOP = () -> Flow.Subscriber::onComplete;

        private NopPollingStrategyHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static final class FilesystemWatchBuilder
    implements Supplier<PollingStrategy> {
        private Path path;
        private ScheduledExecutorService executor;

        FilesystemWatchBuilder(Path path) {
            this.path = path;
        }

        public FilesystemWatchBuilder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public PollingStrategy build() {
            return new FilesystemWatchPollingStrategy(this.path, this.executor);
        }

        @Override
        public PollingStrategy get() {
            return this.build();
        }
    }

    public static final class ScheduledBuilder
    implements Supplier<PollingStrategy> {
        private static final String INTERVAL_KEY = "interval";
        private ScheduledPollingStrategy.RecurringPolicy recurringPolicy;
        private ScheduledExecutorService executor;

        ScheduledBuilder(ScheduledPollingStrategy.RecurringPolicy recurringPolicy) {
            this.recurringPolicy = recurringPolicy;
        }

        public static ScheduledBuilder from(Config metaConfig) throws ConfigMappingException, MissingValueException {
            return PollingStrategies.regular(metaConfig.get(INTERVAL_KEY).as(Duration.class));
        }

        public ScheduledBuilder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public PollingStrategy build() {
            ScheduledExecutorService executor = this.executor;
            return new ScheduledPollingStrategy(this.recurringPolicy, executor);
        }

        @Override
        public PollingStrategy get() {
            return this.build();
        }
    }
}

