/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.ClasspathSourceHelper;
import io.helidon.config.spi.AbstractParsableConfigSource;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClasspathConfigSource
extends AbstractParsableConfigSource<Instant> {
    private static final Logger LOGGER = Logger.getLogger(ClasspathConfigSource.class.getName());
    private static final String RESOURCE_KEY = "resource";
    private final String resource;

    ClasspathConfigSource(ClasspathBuilder builder, String resource) {
        super(builder);
        this.resource = resource.startsWith("/") ? resource.substring(1) : resource;
    }

    public static ClasspathConfigSource from(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return (ClasspathConfigSource)new ClasspathBuilder(metaConfig.get(RESOURCE_KEY).asString()).init(metaConfig).build();
    }

    @Override
    protected String uid() {
        return ClasspathSourceHelper.uid(this.resource);
    }

    @Override
    protected String getMediaType() {
        return OptionalHelper.from(Optional.ofNullable(super.getMediaType())).or(this::probeContentType).asOptional().orElse(null);
    }

    private Optional<String> probeContentType() {
        return Optional.ofNullable(ConfigHelper.detectContentType(Paths.get(this.resource, new String[0])));
    }

    @Override
    protected Optional<Instant> dataStamp() {
        return Optional.ofNullable(ClasspathSourceHelper.resourceTimestamp(this.resource));
    }

    @Override
    protected ConfigParser.Content<Instant> content() throws ConfigException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            LOGGER.log(Level.FINE, String.format("Error to get %s using %s CONTEXT ClassLoader.", this.description(), classLoader));
            throw new ConfigException(this.description() + " does not exist. Used ClassLoader: " + classLoader);
        }
        Optional<Instant> resourceTimestamp = Optional.ofNullable(ClasspathSourceHelper.resourceTimestamp(this.resource));
        try {
            LOGGER.log(Level.FINE, String.format("Getting content from '%s'. Last modified at %s. Used ClassLoader: %s", ClasspathSourceHelper.resourcePath(this.resource), resourceTimestamp, classLoader));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error to get resource '" + this.resource + "' path. Used ClassLoader: " + classLoader, ex);
        }
        return ConfigParser.Content.from(new InputStreamReader(inputStream, StandardCharsets.UTF_8), this.getMediaType(), resourceTimestamp);
    }

    public static final class ClasspathBuilder
    extends AbstractParsableConfigSource.Builder<ClasspathBuilder, Path> {
        private String resource;

        public ClasspathBuilder(String resource) {
            super(Path.class);
            Objects.requireNonNull(resource, "resource name cannot be null");
            this.resource = resource;
        }

        @Override
        protected ClasspathBuilder init(Config metaConfig) {
            return (ClasspathBuilder)super.init(metaConfig);
        }

        @Override
        protected Path getTarget() {
            try {
                Path resourcePath = ClasspathSourceHelper.resourcePath(this.resource);
                if (resourcePath != null) {
                    return resourcePath;
                }
                throw new ConfigException("Could not find a filesystem path for resource '" + this.resource + "'.");
            }
            catch (Exception ex) {
                throw new ConfigException("Could not find a filesystem path for resource '" + this.resource + "'.", ex);
            }
        }

        @Override
        public ConfigSource build() {
            return new ClasspathConfigSource(this, this.resource);
        }

        PollingStrategy getPollingStrategyInternal() {
            return super.getPollingStrategy();
        }
    }
}

