/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.internal.ClasspathSourceHelper;
import io.helidon.config.spi.AbstractOverrideSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClasspathOverrideSource
extends AbstractOverrideSource<Instant> {
    private static final Logger LOGGER = Logger.getLogger(ClasspathOverrideSource.class.getName());
    private final String resource;

    ClasspathOverrideSource(ClasspathBuilder builder, String resource) {
        super(builder);
        this.resource = resource.startsWith("/") ? resource.substring(1) : resource;
    }

    @Override
    protected String uid() {
        return ClasspathSourceHelper.uid(this.resource);
    }

    @Override
    protected Optional<Instant> dataStamp() {
        return Optional.of(ClasspathSourceHelper.resourceTimestamp(this.resource));
    }

    @Override
    public AbstractSource.Data<OverrideSource.OverrideData, Instant> loadData() throws ConfigException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.resource);
        if (inputStream == null) {
            LOGGER.log(Level.FINE, String.format("Error to get %s using %s CONTEXT ClassLoader.", this.description(), classLoader));
            throw new ConfigException(this.description() + " does not exist. Used ClassLoader: " + classLoader);
        }
        Instant resourceTimestamp = ClasspathSourceHelper.resourceTimestamp(this.resource);
        try {
            LOGGER.log(Level.FINE, String.format("Getting content from '%s'. Last modified at %s. Used ClassLoader: %s", ClasspathSourceHelper.resourcePath(this.resource), resourceTimestamp, classLoader));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error to get resource '" + this.resource + "' path. Used ClassLoader: " + classLoader, ex);
        }
        try {
            return new AbstractSource.Data<OverrideSource.OverrideData, Instant>(Optional.of(OverrideSource.OverrideData.from(new InputStreamReader(inputStream, StandardCharsets.UTF_8))), Optional.ofNullable(resourceTimestamp));
        }
        catch (IOException e) {
            throw new ConfigException("Cannot load dta from resource.", e);
        }
    }

    public static final class ClasspathBuilder
    extends AbstractOverrideSource.Builder<ClasspathBuilder, Path> {
        private String resource;

        public ClasspathBuilder(String resource) {
            super(Path.class);
            Objects.requireNonNull(resource, "resource name cannot be null");
            this.resource = resource;
        }

        @Override
        protected Path getTarget() {
            try {
                Path resourcePath = ClasspathSourceHelper.resourcePath(this.resource);
                if (resourcePath != null) {
                    return resourcePath;
                }
                throw new ConfigException("Could not find a filesystem path for resource '" + this.resource + "'.");
            }
            catch (Exception ex) {
                throw new ConfigException("Could not find a filesystem path for resource '" + this.resource + "'.", ex);
            }
        }

        @Override
        public OverrideSource build() {
            return new ClasspathOverrideSource(this, this.resource);
        }

        PollingStrategy getPollingStrategyInternal() {
            return super.getPollingStrategy();
        }
    }
}

