/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.internal.FileSourceHelper;
import io.helidon.config.spi.AbstractConfigSource;
import io.helidon.config.spi.AbstractSource;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class DirectoryConfigSource
extends AbstractConfigSource<Instant> {
    private static final String PATH_KEY = "path";
    private final Path directoryPath;

    DirectoryConfigSource(DirectoryBuilder builder, Path directoryPath) {
        super(builder);
        this.directoryPath = directoryPath;
    }

    public static DirectoryConfigSource from(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return (DirectoryConfigSource)new DirectoryBuilder(metaConfig.get(PATH_KEY).as(Path.class)).init(metaConfig).build();
    }

    @Override
    protected String uid() {
        return this.directoryPath.toString();
    }

    @Override
    protected Optional<Instant> dataStamp() {
        return Optional.ofNullable(FileSourceHelper.lastModifiedTime(this.directoryPath));
    }

    @Override
    protected AbstractSource.Data<ConfigNode.ObjectNode, Instant> loadData() throws ConfigException {
        try {
            ConfigNode.ObjectNode.Builder objectNodeRoot = ConfigNode.ObjectNode.builder();
            Files.walk(this.directoryPath, 1, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String content = FileSourceHelper.safeReadContent(path);
                objectNodeRoot.addValue(path.getFileName().toString(), content);
            });
            return new AbstractSource.Data<ConfigNode.ObjectNode, Instant>(Optional.of(objectNodeRoot.build()), this.dataStamp());
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at directory '" + this.directoryPath + "' is not accessible.", ex);
        }
    }

    public static final class DirectoryBuilder
    extends AbstractConfigSource.Builder<DirectoryBuilder, Path> {
        private Path path;

        public DirectoryBuilder(Path path) {
            super(Path.class);
            Objects.requireNonNull(path, "directory path cannot be null");
            this.path = path;
        }

        @Override
        protected DirectoryBuilder init(Config metaConfig) {
            return (DirectoryBuilder)super.init(metaConfig);
        }

        @Override
        protected Path getTarget() {
            return this.path;
        }

        @Override
        public ConfigSource build() {
            return new DirectoryConfigSource(this, this.path);
        }
    }
}

