/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.SubmissionPublisher;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.internal.ConfigThreadFactory;
import io.helidon.config.internal.ConfigUtils;
import io.helidon.config.spi.PollingStrategy;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesystemWatchPollingStrategy
implements PollingStrategy {
    private static final Logger LOGGER = Logger.getLogger(FilesystemWatchPollingStrategy.class.getName());
    private static final long DEFAULT_RECURRING_INTERVAL = 5L;
    private final Path path;
    private final SubmissionPublisher<PollingStrategy.PollingEvent> ticksSubmitter;
    private final Flow.Publisher<PollingStrategy.PollingEvent> ticksPublisher;
    private final boolean customExecutor;
    private ScheduledExecutorService executor;
    private WatchService watchService;
    private final List<WatchEvent.Modifier> watchServiceModifiers;
    private WatchKey watchKey;
    private Future watchThreadFuture;

    public FilesystemWatchPollingStrategy(Path path, ScheduledExecutorService executor) {
        if (executor == null) {
            this.customExecutor = false;
        } else {
            this.customExecutor = true;
            this.executor = executor;
        }
        this.path = path;
        this.ticksSubmitter = new SubmissionPublisher(Runnable::run, 1);
        this.ticksPublisher = ConfigHelper.suspendablePublisher(this.ticksSubmitter, this::startWatchService, this::stopWatchService);
        this.watchServiceModifiers = new LinkedList<WatchEvent.Modifier>();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public Flow.Publisher<PollingStrategy.PollingEvent> ticks() {
        return this.ticksPublisher;
    }

    private void fireEvent(WatchEvent<?> watchEvent) {
        this.getTicksSubmitter().offer((Object)PollingStrategy.PollingEvent.now(), (subscriber, pollingEvent) -> {
            LOGGER.log(Level.FINER, String.format("Event %s has not been delivered to %s.", pollingEvent, subscriber));
            return false;
        });
    }

    void initWatchServiceModifiers(WatchEvent.Modifier ... modifiers) {
        this.watchServiceModifiers.addAll(Arrays.asList(modifiers));
    }

    void startWatchService() {
        if (!this.customExecutor) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ConfigThreadFactory("file-watch-polling"));
        }
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new ConfigException("Cannot obtain WatchService.", e);
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.watchThreadFuture = this.executor.scheduleWithFixedDelay(new Monitor(this.path, latch, this.watchServiceModifiers), 0L, 5L, TimeUnit.SECONDS);
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ConfigException("Thread which is supposed to register to watch service exceeded the limit 1s.", e);
        }
    }

    void stopWatchService() {
        if (this.watchKey != null) {
            this.watchKey.cancel();
        }
        if (this.watchThreadFuture != null) {
            this.watchThreadFuture.cancel(true);
        }
        if (!this.customExecutor) {
            ConfigUtils.shutdownExecutor(this.executor);
            this.executor = null;
        }
    }

    SubmissionPublisher<PollingStrategy.PollingEvent> getTicksSubmitter() {
        return this.ticksSubmitter;
    }

    Future getWatchThreadFuture() {
        return this.watchThreadFuture;
    }

    public String toString() {
        return "FilesystemWatchPollingStrategy{path=" + this.path + '}';
    }

    private class Monitor
    implements Runnable {
        private final Path path;
        private final CountDownLatch latch;
        private final List<WatchEvent.Modifier> watchServiceModifiers;
        private boolean fail;

        private Monitor(Path path, CountDownLatch latch, List<WatchEvent.Modifier> watchServiceModifiers) {
            this.path = path;
            this.latch = latch;
            this.watchServiceModifiers = watchServiceModifiers;
        }

        @Override
        public void run() {
            block10: {
                WatchKey key;
                Path dir = this.path.getParent();
                try {
                    this.register();
                    if (this.fail) {
                        FilesystemWatchPollingStrategy.this.fireEvent(null);
                        this.fail = false;
                    }
                }
                catch (Exception e2) {
                    this.fail = true;
                    LOGGER.log(Level.FINE, "Cannot register to watch service.", e2);
                    return;
                }
                finally {
                    this.latch.countDown();
                }
                do {
                    try {
                        key = FilesystemWatchPollingStrategy.this.watchService.take();
                    }
                    catch (Exception ie) {
                        this.fail = true;
                        LOGGER.log(Level.FINE, ie, () -> "Watch service on '" + dir + "' directory interrupted.");
                        break block10;
                    }
                    List<WatchEvent<?>> events = key.pollEvents();
                    events.stream().filter(e -> FilesystemWatchPollingStrategy.this.path.endsWith((Path)e.context())).forEach(x$0 -> FilesystemWatchPollingStrategy.this.fireEvent(x$0));
                } while (key.reset());
                this.fail = true;
                LOGGER.log(Level.FINE, () -> "Directory '" + dir + "' is no more valid to be watched.");
                FilesystemWatchPollingStrategy.this.fireEvent(null);
            }
        }

        private void register() throws IOException {
            Path target = this.getTarget(this.path);
            Path dir = this.getParentDir(target);
            WatchKey oldWatchKey = FilesystemWatchPollingStrategy.this.watchKey;
            FilesystemWatchPollingStrategy.this.watchKey = dir.register(FilesystemWatchPollingStrategy.this.watchService, CollectionsHelper.listOf((Object[])new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}).toArray(new WatchEvent.Kind[0]), this.watchServiceModifiers.toArray(new WatchEvent.Modifier[0]));
            if (oldWatchKey != null) {
                oldWatchKey.cancel();
            }
        }

        private Path getTarget(Path path) throws IOException {
            Path target = path;
            while (Files.isSymbolicLink(target)) {
                target = target.toRealPath(new LinkOption[0]);
            }
            return target;
        }

        private Path getParentDir(Path path) {
            Path parent = path.getParent();
            if (parent == null) {
                throw new ConfigException(String.format("Cannot find parent directory for '%s' to register watch service.", path.toString()));
            }
            return parent;
        }
    }
}

