/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.internal.AbstractNodeBuilderImpl;
import io.helidon.config.internal.ListNodeBuilderImpl;
import io.helidon.config.internal.MergeableNode;
import io.helidon.config.internal.ObjectNodeImpl;
import io.helidon.config.internal.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

class ListNodeImpl
extends AbstractList<ConfigNode>
implements ConfigNode.ListNode,
MergeableNode {
    private final List<MergeableNode> elements;
    private String description;
    private final String value;

    ListNodeImpl(List<MergeableNode> elements, String value) {
        this.elements = elements;
        this.description = null;
        this.value = value;
    }

    static ListNodeImpl wrap(ConfigNode.ListNode listNode, Function<String, String> resolveTokenFunction) {
        if (listNode instanceof ListNodeImpl) {
            return (ListNodeImpl)listNode;
        }
        return ListNodeBuilderImpl.from(listNode).value((String)listNode.get()).build();
    }

    @Override
    public MergeableNode get(int index) {
        return this.elements.get(index);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public MergeableNode merge(MergeableNode node) {
        switch (node.getNodeType()) {
            case OBJECT: {
                return this.mergeWithObject((ObjectNodeImpl)node);
            }
            case LIST: {
                return this.mergeWithList((ListNodeImpl)node);
            }
            case VALUE: {
                return new ListNodeImpl(this.elements, ((ValueNodeImpl)node).get());
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private MergeableNode mergeWithList(ListNodeImpl node) {
        if (node.hasValue()) {
            return node;
        }
        if (this.hasValue()) {
            return new ListNodeImpl(node.elements, this.value);
        }
        return node;
    }

    private MergeableNode mergeWithObject(ObjectNodeImpl node) {
        HashSet unprocessedPeerNames = new HashSet(node.keySet());
        ListNodeBuilderImpl builder = new ListNodeBuilderImpl(Function.identity());
        if (node.hasValue()) {
            builder.value(node.get());
        } else if (this.hasValue()) {
            builder.value(this.value);
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            MergeableNode element = this.elements.get(i);
            String name = String.valueOf(i);
            if (unprocessedPeerNames.contains(name)) {
                unprocessedPeerNames.remove(name);
                element = element.merge((MergeableNode)node.get(name));
            }
            builder.addNode(element);
        }
        if (!unprocessedPeerNames.isEmpty()) {
            throw new ConfigException(String.format("Cannot merge OBJECT members %s%s with an LIST node%s.", unprocessedPeerNames, AbstractNodeBuilderImpl.formatFrom(node.getDescription()), AbstractNodeBuilderImpl.formatFrom(this.description)));
        }
        return builder.build();
    }

    @Override
    public String toString() {
        return "ListNode[" + this.elements.size() + "]" + super.toString() + "=" + this.value;
    }

    public ListNodeImpl initDescription(String description) {
        this.description = description;
        this.elements.forEach(node -> ObjectNodeImpl.initDescription(node, description));
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasValue() {
        return null != this.value;
    }

    @Override
    public String get() {
        return this.value;
    }
}

