/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.ConfigException;
import io.helidon.config.internal.AbstractNodeBuilderImpl;
import io.helidon.config.internal.ListNodeImpl;
import io.helidon.config.internal.MergeableNode;
import io.helidon.config.internal.ObjectNodeImpl;
import io.helidon.config.internal.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ObjectNodeBuilderImpl
extends AbstractNodeBuilderImpl<String, ConfigNode.ObjectNode.Builder>
implements ConfigNode.ObjectNode.Builder {
    private final Map<String, MergeableNode> members = new HashMap<String, MergeableNode>();
    private String value;

    public ObjectNodeBuilderImpl() {
        this(Function.identity());
    }

    public ObjectNodeBuilderImpl(Function<String, String> tokenResolver) {
        super(tokenResolver);
    }

    public static ObjectNodeBuilderImpl from(Map<String, ConfigNode> members) {
        return ObjectNodeBuilderImpl.from(members, Function.identity());
    }

    public static ObjectNodeBuilderImpl from(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction) {
        return new ObjectNodeBuilderImpl(resolveTokenFunction).fromMap(members);
    }

    private ObjectNodeBuilderImpl fromMap(Map<String, ConfigNode> members) {
        members.forEach(this::addNode);
        return this;
    }

    public ObjectNodeBuilderImpl addNode(String name, ConfigNode node) {
        this.members.put(this.getTokenResolver().apply(name), ObjectNodeBuilderImpl.wrap(node, this.getTokenResolver()));
        return this;
    }

    @Override
    protected String typeDescription() {
        return "an OBJECT node";
    }

    @Override
    protected String id(AbstractNodeBuilderImpl.MergingKey key) {
        return key.first();
    }

    @Override
    protected MergeableNode member(String name) {
        return this.members.computeIfAbsent(name, k -> new ObjectNodeImpl(CollectionsHelper.mapOf(), this.getTokenResolver()));
    }

    @Override
    protected void update(String name, MergeableNode node) {
        this.members.put(this.getTokenResolver().apply(name), node);
    }

    @Override
    protected void merge(String name, MergeableNode node) {
        try {
            this.members.merge(name, node, MergeableNode::merge);
        }
        catch (ConfigException ex) {
            throw new ConfigException(name + ": " + ex.getLocalizedMessage(), ex);
        }
    }

    private String encodeDotsInTokenReferences(String key) {
        return key.replaceAll("\\.+(?=[^(\\$\\{)]*\\})", "~1");
    }

    @Override
    public ObjectNodeBuilderImpl value(String value) {
        this.value = value;
        return this;
    }

    @Override
    public ConfigNode.ObjectNode.Builder addValue(String key, ConfigNode.ValueNode value) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.getTokenResolver().apply(key))), ValueNodeImpl.wrap(value));
    }

    @Override
    public ConfigNode.ObjectNode.Builder addObject(String key, ConfigNode.ObjectNode object) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.getTokenResolver().apply(key))), ObjectNodeImpl.wrap(object, this.getTokenResolver()));
    }

    @Override
    public ConfigNode.ObjectNode.Builder addList(String key, ConfigNode.ListNode list) {
        return (ConfigNode.ObjectNode.Builder)this.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(this.encodeDotsInTokenReferences(this.getTokenResolver().apply(key))), ListNodeImpl.wrap(list, this.getTokenResolver()));
    }

    @Override
    public ObjectNodeImpl build() {
        return new ObjectNodeImpl(Collections.unmodifiableMap(this.members), this.getTokenResolver(), this.value);
    }

    public String toString() {
        return "ObjectNodeBuilderImpl{members=" + this.members + "} " + super.toString();
    }
}

