/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.internal.AbstractNodeBuilderImpl;
import io.helidon.config.internal.ListNodeImpl;
import io.helidon.config.internal.MergeableNode;
import io.helidon.config.internal.ObjectNodeBuilderImpl;
import io.helidon.config.internal.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ObjectNodeImpl
extends AbstractMap<String, ConfigNode>
implements ConfigNode.ObjectNode,
MergeableNode {
    private final Map<String, ConfigNode> members;
    private final Function<String, String> resolveTokenFunction;
    private final String value;
    private String description;

    ObjectNodeImpl(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction) {
        this(members, resolveTokenFunction, null);
    }

    ObjectNodeImpl(Map<String, ConfigNode> members, Function<String, String> resolveTokenFunction, String value) {
        this.members = members;
        this.resolveTokenFunction = resolveTokenFunction;
        this.value = value;
    }

    public static ObjectNodeImpl wrap(ConfigNode.ObjectNode objectNode) {
        return ObjectNodeImpl.wrap(objectNode, Function.identity());
    }

    public static ObjectNodeImpl wrap(ConfigNode.ObjectNode objectNode, Function<String, String> resolveTokenFunction) {
        return ObjectNodeBuilderImpl.from(objectNode, resolveTokenFunction).value((String)objectNode.get()).build();
    }

    @Override
    public Set<Map.Entry<String, ConfigNode>> entrySet() {
        return this.members.entrySet();
    }

    static void initDescription(ConfigNode node, String description) {
        switch (node.getNodeType()) {
            case OBJECT: {
                ((ObjectNodeImpl)node).initDescription(description);
                break;
            }
            case LIST: {
                ((ListNodeImpl)node).initDescription(description);
                break;
            }
            case VALUE: {
                ((ValueNodeImpl)node).initDescription(description);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
            }
        }
    }

    @Override
    public MergeableNode merge(MergeableNode node) {
        switch (node.getNodeType()) {
            case OBJECT: {
                return this.mergeWithObjectNode((ObjectNodeImpl)node);
            }
            case LIST: {
                throw new ConfigException(String.format("Cannot merge a LIST node%s with an OBJECT node%s.", AbstractNodeBuilderImpl.formatFrom(((ListNodeImpl)node).getDescription()), AbstractNodeBuilderImpl.formatFrom(this.description)));
            }
            case VALUE: {
                return this.mergeWithValueNode((ValueNodeImpl)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    private MergeableNode mergeWithValueNode(ValueNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.from(this.members, this.resolveTokenFunction);
        builder.value(node.get());
        return builder.build();
    }

    private MergeableNode mergeWithObjectNode(ObjectNodeImpl node) {
        ObjectNodeBuilderImpl builder = ObjectNodeBuilderImpl.from(this.members, this.resolveTokenFunction);
        node.forEach((name, member) -> {
            ConfigNode.ObjectNode.Builder cfr_ignored_0 = (ConfigNode.ObjectNode.Builder)builder.deepMerge(AbstractNodeBuilderImpl.MergingKey.of(name), AbstractNodeBuilderImpl.wrap(member));
        });
        if (node.hasValue()) {
            builder.value(node.value);
        } else if (this.hasValue()) {
            builder.value(this.value);
        }
        return builder.build();
    }

    @Override
    public String toString() {
        if (null == this.value) {
            return "ObjectNode[" + this.members.size() + "]" + super.toString();
        }
        return "ObjectNode(\"" + this.value + "\")[" + this.members.size() + "]" + super.toString();
    }

    public ObjectNodeImpl initDescription(String description) {
        this.description = description;
        this.members.values().forEach((? super T node) -> ObjectNodeImpl.initDescription(node, description));
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasValue() {
        return null != this.value;
    }

    @Override
    public String get() {
        return this.value;
    }
}

