/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.internal;

import io.helidon.config.ConfigException;
import io.helidon.config.spi.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class RetryPolicyImpl
implements RetryPolicy {
    private static final Logger LOGGER = Logger.getLogger(RetryPolicyImpl.class.getName());
    private final int retries;
    private final Duration delay;
    private final double delayFactor;
    private final Duration callTimeout;
    private final Duration overallTimeout;
    private final ScheduledExecutorService executorService;
    private volatile ScheduledFuture future;

    public RetryPolicyImpl(int retries, Duration delay, double delayFactor, Duration callTimeout, Duration overallTimeout, ScheduledExecutorService executorService) {
        this.retries = retries;
        this.delay = delay;
        this.delayFactor = delayFactor;
        this.callTimeout = callTimeout;
        this.overallTimeout = overallTimeout;
        this.executorService = executorService;
    }

    @Override
    public <T> T execute(Supplier<T> call) throws ConfigException {
        Duration currentDelay = Duration.ZERO;
        long overallTimeoutsLeft = this.overallTimeout.toMillis();
        for (int i = 0; i <= this.retries; ++i) {
            try {
                ScheduledFuture<Object> localFuture;
                LOGGER.finest("next delay: " + currentDelay);
                if ((overallTimeoutsLeft -= currentDelay.toMillis()) < 0L) {
                    LOGGER.finest("overall timeout left [ms]: " + overallTimeoutsLeft);
                    throw new ConfigException("Cannot schedule the next call, the current delay would exceed the overall timeout.");
                }
                this.future = localFuture = this.executorService.schedule(call::get, currentDelay.toMillis(), TimeUnit.MILLISECONDS);
                return (T)localFuture.get(Math.min(currentDelay.plus(this.callTimeout).toMillis(), overallTimeoutsLeft), TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                if (t instanceof CancellationException) {
                    throw new ConfigException("An invocation has been canceled.", t);
                }
                if (t instanceof InterruptedException) {
                    throw new ConfigException("An invocation has been interrupted.", t);
                }
                if (t instanceof TimeoutException) {
                    throw new ConfigException("A timeout has been reached.", t);
                }
                currentDelay = this.nextDelay(i, currentDelay);
                continue;
            }
        }
        throw new ConfigException("All repeated calls failed.");
    }

    Duration nextDelay(int invocation, Duration currentDelay) {
        if (invocation == 0) {
            return this.delay;
        }
        return Duration.ofMillis((long)((double)currentDelay.toMillis() * this.delayFactor));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.future != null && !this.future.isDone() && !this.future.isCancelled()) {
            return this.future.cancel(mayInterruptIfRunning);
        }
        return false;
    }

    public int getRetries() {
        return this.retries;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getCallTimeout() {
        return this.callTimeout;
    }

    public Duration getOverallTimeout() {
        return this.overallTimeout;
    }
}

